/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.pump;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.pump.PumpChart;
import neqsim.processSimulation.processEquipment.pump.PumpInterface;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class Pump
extends ProcessEquipmentBaseClass
implements PumpInterface {
    private static final long serialVersionUID = 1000L;
    SystemInterface thermoSystem;
    private StreamInterface inStream;
    StreamInterface outStream;
    double dH = 0.0;
    double pressure = 0.0;
    private double molarFlow = 10.0;
    private double speed = 1000.0;
    private double outTemperature = 298.15;
    private boolean useOutTemperature = false;
    private boolean calculateAsCompressor = true;
    public double isentropicEfficiency = 1.0;
    public boolean powerSet = false;
    private String pressureUnit = "bara";
    private PumpChart pumpChart = new PumpChart();

    public Pump() {
    }

    public Pump(StreamInterface inletStream) {
        this.setInletStream(inletStream);
    }

    public Pump(String name, StreamInterface inletStream) {
        super(name);
        this.setInletStream(inletStream);
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inStream = inletStream;
        this.outStream = inletStream.clone();
    }

    @Override
    public void setOutletPressure(double pressure) {
        this.pressure = pressure;
    }

    @Override
    public double getEnergy() {
        return this.dH;
    }

    @Override
    public double getPower() {
        return this.dH;
    }

    public double getPower(String unit) {
        if (unit.equals("W")) {
            return this.dH;
        }
        if (unit.equals("kW")) {
            return this.dH / 1000.0;
        }
        if (unit.equals("MW")) {
            return this.dH / 1000000.0;
        }
        return this.dH;
    }

    public double getDuty() {
        return this.dH;
    }

    @Override
    public StreamInterface getOutStream() {
        return this.outStream;
    }

    public void calculateAsCompressor(boolean setPumpCalcType) {
        this.calculateAsCompressor = setPumpCalcType;
    }

    @Override
    public void run() {
        this.inStream.getThermoSystem().init(3);
        double hinn = this.inStream.getThermoSystem().getEnthalpy();
        double entropy = this.inStream.getThermoSystem().getEntropy();
        if (this.useOutTemperature) {
            this.thermoSystem = this.inStream.getThermoSystem().clone();
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
            this.thermoSystem.setTemperature(this.outTemperature);
            this.thermoSystem.setPressure(this.pressure, this.pressureUnit);
            thermoOps.TPflash();
            this.thermoSystem.init(3);
        } else if (this.calculateAsCompressor) {
            this.thermoSystem = this.inStream.getThermoSystem().clone();
            this.thermoSystem.setPressure(this.pressure, this.pressureUnit);
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
            thermoOps.PSflash(entropy);
            if (!this.powerSet) {
                this.dH = (this.getThermoSystem().getEnthalpy() - hinn) / this.isentropicEfficiency;
            }
            double hout = hinn + this.dH;
            this.isentropicEfficiency = (this.getThermoSystem().getEnthalpy() - hinn) / this.dH;
            this.dH = hout - hinn;
            thermoOps = new ThermodynamicOperations(this.getThermoSystem());
            thermoOps.PHflash(hout, 0);
        } else if (this.pumpChart.isUsePumpChart()) {
            double pumpHead = 0.0;
            pumpHead = this.getPumpChart().getHead(this.thermoSystem.getFlowRate("m3/hr"), this.getSpeed());
            this.isentropicEfficiency = this.getPumpChart().getEfficiency(this.thermoSystem.getFlowRate("m3/hr"), this.getSpeed());
            double deltaP = pumpHead * 1000.0 * 9.80665 / 100000.0;
            this.thermoSystem = this.inStream.getThermoSystem().clone();
            this.thermoSystem.setPressure(this.inStream.getPressure() + deltaP);
            double dH = this.thermoSystem.getFlowRate("kg/sec") / this.thermoSystem.getDensity("kg/m3") * (this.thermoSystem.getPressure("Pa") - this.inStream.getThermoSystem().getPressure("Pa")) / (this.isentropicEfficiency / 100.0);
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.getThermoSystem());
            double hout = hinn + dH;
            thermoOps.PHflash(hout, 0);
            this.thermoSystem.init(3);
        } else {
            this.thermoSystem = this.inStream.getThermoSystem().clone();
            this.thermoSystem.setPressure(this.pressure, this.pressureUnit);
            double dH = this.thermoSystem.getFlowRate("kg/sec") / this.thermoSystem.getDensity("kg/m3") * (this.thermoSystem.getPressure("Pa") - this.inStream.getThermoSystem().getPressure("Pa")) / this.isentropicEfficiency;
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.getThermoSystem());
            double hout = hinn + dH;
            thermoOps.PHflash(hout, 0);
            this.thermoSystem.init(3);
        }
        this.dH = this.thermoSystem.getEnthalpy() - hinn;
        this.outStream.setThermoSystem(this.thermoSystem);
    }

    @Override
    public void displayResult() {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        JDialog dialog = new JDialog((Frame)new JFrame(), "Results from TPflash");
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new FlowLayout());
        this.thermoSystem.initPhysicalProperties();
        Object[][] table = new String[50][5];
        Object[] names = new String[]{"", "Phase 1", "Phase 2", "Phase 3", "Unit"};
        table[0][0] = "";
        table[0][1] = "";
        table[0][2] = "";
        table[0][3] = "";
        StringBuffer buf = new StringBuffer();
        FieldPosition test2 = new FieldPosition(0);
        int i = 0;
        while (i < this.thermoSystem.getNumberOfPhases()) {
            int j = 0;
            while (j < this.thermoSystem.getPhases()[0].getNumberOfComponents()) {
                table[j + 1][0] = this.thermoSystem.getPhases()[0].getComponents()[j].getName();
                buf = new StringBuffer();
                table[j + 1][i + 1] = nf.format(this.thermoSystem.getPhases()[i].getComponents()[j].getx(), buf, test2).toString();
                table[j + 1][4] = "[-]";
                ++j;
            }
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 2][0] = "Density";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 2][i + 1] = nf.format(this.thermoSystem.getPhases()[i].getPhysicalProperties().getDensity(), buf, test2).toString();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 2][4] = "[kg/m^3]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 3][0] = "PhaseFraction";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 3][i + 1] = nf.format(this.thermoSystem.getPhases()[i].getBeta(), buf, test2).toString();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 3][4] = "[-]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 4][0] = "MolarMass";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 4][i + 1] = nf.format(this.thermoSystem.getPhases()[i].getMolarMass() * 1000.0, buf, test2).toString();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 4][4] = "[kg/kmol]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 5][0] = "Cp";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 5][i + 1] = nf.format(this.thermoSystem.getPhases()[i].getCp() / this.thermoSystem.getPhases()[i].getNumberOfMolesInPhase() * 1.0 / this.thermoSystem.getPhases()[i].getMolarMass() * 1000.0, buf, test2).toString();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 5][4] = "[kJ/kg*K]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 7][0] = "Viscosity";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 7][i + 1] = nf.format(this.thermoSystem.getPhases()[i].getPhysicalProperties().getViscosity(), buf, test2).toString();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 7][4] = "[kg/m*sec]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 8][0] = "Conductivity";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 8][i + 1] = nf.format(this.thermoSystem.getPhases()[i].getPhysicalProperties().getConductivity(), buf, test2).toString();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 8][4] = "[W/m*K]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 10][0] = "Pressure";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 10][i + 1] = Double.toString(this.thermoSystem.getPhases()[i].getPressure());
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 10][4] = "[bar]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 11][0] = "Temperature";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 11][i + 1] = Double.toString(this.thermoSystem.getPhases()[i].getTemperature());
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 11][4] = "[K]";
            Double.toString(this.thermoSystem.getPhases()[i].getTemperature());
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 13][0] = "Stream";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 13][i + 1] = this.name;
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 13][4] = "-";
            ++i;
        }
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public void runTransient() {
    }

    public double getMolarFlow() {
        return this.molarFlow;
    }

    public void setMolarFlow(double molarFlow) {
        this.molarFlow = molarFlow;
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.thermoSystem;
    }

    public double getIsentropicEfficiency() {
        return this.isentropicEfficiency;
    }

    public void setIsentropicEfficiency(double isentropicEfficientcy) {
        this.isentropicEfficiency = isentropicEfficientcy;
    }

    public double getOutTemperature() {
        if (this.useOutTemperature) {
            return this.outTemperature;
        }
        return this.getThermoSystem().getTemperature();
    }

    public void setOutTemperature(double outTemperature) {
        this.useOutTemperature = true;
        this.outTemperature = outTemperature;
    }

    @Override
    public double getEntropyProduction(String unit) {
        return this.outStream.getThermoSystem().getEntropy(unit) - this.inStream.getThermoSystem().getEntropy(unit);
    }

    @Override
    public void setPressure(double pressure) {
        this.setOutletPressure(pressure);
    }

    public void setPressure(double pressure, String unit) {
        this.setOutletPressure(pressure);
        this.pressureUnit = unit;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getSpeed() {
        return this.speed;
    }

    public PumpChart getPumpChart() {
        return this.pumpChart;
    }

    public StreamInterface getInStream() {
        return this.inStream;
    }
}

