/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.heatExchanger;

import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class ReBoiler
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    boolean setTemperature = false;
    StreamInterface outStream;
    StreamInterface inStream;
    SystemInterface system;
    private double reboilerDuty = 0.0;

    public ReBoiler() {
    }

    public ReBoiler(StreamInterface inStream) {
        this.inStream = inStream;
        this.outStream = inStream.clone();
    }

    public StreamInterface getOutStream() {
        return this.outStream;
    }

    @Override
    public void run() {
        this.system = this.inStream.getThermoSystem().clone();
        ThermodynamicOperations testOps = new ThermodynamicOperations(this.system);
        testOps.TPflash();
        double oldH = this.system.getEnthalpy();
        testOps = new ThermodynamicOperations(this.system);
        testOps.TPflash();
        testOps.PHflash(oldH + this.reboilerDuty, 0);
        this.outStream.setThermoSystem(this.system);
    }

    @Override
    public void displayResult() {
        System.out.println("out Temperature " + this.reboilerDuty);
    }

    public void runTransient() {
    }

    public double getReboilerDuty() {
        return this.reboilerDuty;
    }

    public void setReboilerDuty(double reboilerDuty) {
        this.reboilerDuty = reboilerDuty;
    }
}

