/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.expander;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.expander.ExpanderInterface;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class ExpanderOld
extends ProcessEquipmentBaseClass
implements ExpanderInterface {
    private static final long serialVersionUID = 1000L;
    SystemInterface thermoSystem;
    ThermodynamicOperations thermoOps;
    StreamInterface inletStream;
    StreamInterface outStream;
    double dH = 0.0;
    double pressure = 0.0;

    public ExpanderOld() {
    }

    public ExpanderOld(Stream inletStream) {
        this.setInletStream(inletStream);
    }

    public ExpanderOld(String name, StreamInterface inletStream) {
        this.name = name;
        this.setInletStream(inletStream);
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.outStream = inletStream.clone();
    }

    @Override
    public void setOutletPressure(double pressure) {
        this.pressure = pressure;
    }

    @Override
    public double getEnergy() {
        return this.dH;
    }

    @Override
    public StreamInterface getOutStream() {
        return this.outStream;
    }

    @Override
    public void run() {
        System.out.println("expander running..");
        this.thermoSystem = this.inletStream.getThermoSystem().clone();
        this.thermoOps = new ThermodynamicOperations(this.thermoSystem);
        this.thermoSystem.init(3);
        double hinn = this.thermoSystem.getEnthalpy();
        double entropy = this.thermoSystem.getEntropy();
        this.thermoSystem.setPressure(this.pressure);
        System.out.println("entropy inn.." + entropy);
        this.thermoOps.PSflash(entropy);
        this.dH = this.thermoSystem.getEnthalpy() - hinn;
        this.outStream.setThermoSystem(this.thermoSystem);
    }

    @Override
    public void displayResult() {
        DecimalFormat nf = new DecimalFormat();
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        JDialog dialog = new JDialog((Frame)new JFrame(), "Results from TPflash");
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new FlowLayout());
        this.thermoSystem.initPhysicalProperties();
        Object[][] table = new String[20][5];
        Object[] names = new String[]{"", "Phase 1", "Phase 2", "Phase 3", "Unit"};
        table[0][0] = "";
        table[0][1] = "";
        table[0][2] = "";
        table[0][3] = "";
        StringBuffer buf = new StringBuffer();
        FieldPosition test2 = new FieldPosition(0);
        int i = 0;
        while (i < this.thermoSystem.getNumberOfPhases()) {
            int j = 0;
            while (j < this.thermoSystem.getPhases()[0].getNumberOfComponents()) {
                table[j + 1][0] = this.thermoSystem.getPhases()[0].getComponents()[j].getName();
                buf = new StringBuffer();
                table[j + 1][i + 1] = nf.format(this.thermoSystem.getPhases()[i].getComponents()[j].getx(), buf, test2).toString();
                table[j + 1][4] = "[-]";
                ++j;
            }
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 2][0] = "Density";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 2][i + 1] = nf.format(this.thermoSystem.getPhases()[i].getPhysicalProperties().getDensity(), buf, test2).toString();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 2][4] = "[kg/m^3]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 3][0] = "PhaseFraction";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 3][i + 1] = nf.format(this.thermoSystem.getPhases()[i].getBeta(), buf, test2).toString();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 3][4] = "[-]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 4][0] = "MolarMass";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 4][i + 1] = nf.format(this.thermoSystem.getPhases()[i].getMolarMass() * 1000.0, buf, test2).toString();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 4][4] = "[kg/kmol]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 5][0] = "Cp";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 5][i + 1] = nf.format(this.thermoSystem.getPhases()[i].getCp() / this.thermoSystem.getPhases()[i].getNumberOfMolesInPhase() * 1.0 / this.thermoSystem.getPhases()[i].getMolarMass() * 1000.0, buf, test2).toString();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 5][4] = "[kJ/kg*K]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 7][0] = "Viscosity";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 7][i + 1] = nf.format(this.thermoSystem.getPhases()[i].getPhysicalProperties().getViscosity(), buf, test2).toString();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 7][4] = "[kg/m*sec]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 8][0] = "Conductivity";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 8][i + 1] = nf.format(this.thermoSystem.getPhases()[i].getPhysicalProperties().getConductivity(), buf, test2).toString();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 8][4] = "[W/m*K]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 10][0] = "Pressure";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 10][i + 1] = Double.toString(this.thermoSystem.getPhases()[i].getPressure());
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 10][4] = "[bar]";
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 11][0] = "Temperature";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 11][i + 1] = Double.toString(this.thermoSystem.getPhases()[i].getTemperature());
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 11][4] = "[K]";
            Double.toString(this.thermoSystem.getPhases()[i].getTemperature());
            buf = new StringBuffer();
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 13][0] = "Stream";
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 13][i + 1] = this.name;
            table[this.thermoSystem.getPhases()[0].getNumberOfComponents() + 13][4] = "-";
            ++i;
        }
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public void runTransient() {
    }
}

