/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.distillation;

import neqsim.processSimulation.processEquipment.distillation.TrayInterface;
import neqsim.processSimulation.processEquipment.mixer.Mixer;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class SimpleTray
extends Mixer
implements TrayInterface {
    private static final long serialVersionUID = 1000L;
    double heatInput = 0.0;
    private double temperature = Double.NaN;
    private double trayPressure = -1.0;

    public void init() {
        int pp = 0;
        if (this.streams.size() == 3) {
            pp = 1;
        }
        int k = pp;
        while (k < this.streams.size()) {
            ((StreamInterface)this.streams.get(k)).getThermoSystem().setTemperature(this.temperature);
            ++k;
        }
    }

    @Override
    public void setHeatInput(double heatinp) {
        this.heatInput = heatinp;
    }

    public double calcMixStreamEnthalpy0() {
        double enthalpy = 0.0;
        int k = 0;
        while (k < this.streams.size()) {
            ((StreamInterface)this.streams.get(k)).getThermoSystem().init(3);
            enthalpy += ((StreamInterface)this.streams.get(k)).getThermoSystem().getEnthalpy();
            ++k;
        }
        return enthalpy;
    }

    @Override
    public double calcMixStreamEnthalpy() {
        double enthalpy = this.heatInput;
        if (this.isSetEnergyStream()) {
            enthalpy -= this.energyStream.getDuty();
        }
        int k = 0;
        while (k < this.streams.size()) {
            ((StreamInterface)this.streams.get(k)).getThermoSystem().init(3);
            enthalpy += ((StreamInterface)this.streams.get(k)).getThermoSystem().getEnthalpy();
            ++k;
        }
        return enthalpy;
    }

    public void run2() {
        super.run();
        this.temperature = this.mixedStream.getTemperature();
    }

    public void TPflash() {
    }

    @Override
    public void run() {
        double enthalpy = 0.0;
        SystemInterface thermoSystem2 = ((StreamInterface)this.streams.get(0)).getThermoSystem().clone();
        if (this.trayPressure > 0.0) {
            thermoSystem2.setPressure(this.trayPressure);
        }
        this.mixedStream.setThermoSystem(thermoSystem2);
        ThermodynamicOperations testOps = new ThermodynamicOperations(thermoSystem2);
        if (this.streams.size() > 0) {
            this.mixedStream.getThermoSystem().setNumberOfPhases(2);
            this.mixedStream.getThermoSystem().reInitPhaseType();
            this.mixedStream.getThermoSystem().init(0);
            this.mixStream();
            if (this.trayPressure > 0.0) {
                this.mixedStream.setPressure(this.trayPressure, "bara");
            }
            enthalpy = this.calcMixStreamEnthalpy();
            if (this.isSetOutTemperature()) {
                this.mixedStream.setTemperature(this.getOutTemperature(), "K");
            }
        }
        if (this.isSetOutTemperature()) {
            if (!Double.isNaN(this.getOutTemperature())) {
                this.mixedStream.getThermoSystem().setTemperature(this.getOutTemperature());
            }
            testOps.TPflash();
            this.mixedStream.getThermoSystem().init(2);
        } else {
            try {
                testOps.PHflash(enthalpy, 0);
            }
            catch (Exception e) {
                if (!Double.isNaN(this.getOutTemperature())) {
                    this.mixedStream.getThermoSystem().setTemperature(this.getOutTemperature());
                }
                testOps.TPflash();
            }
        }
        this.setTemperature(this.mixedStream.getTemperature());
    }

    @Override
    public void runTransient() {
    }

    public Stream getGasOutStream() {
        return new Stream("", this.mixedStream.getThermoSystem().phaseToSystem(0));
    }

    public Stream getLiquidOutStream() {
        return new Stream("", this.mixedStream.getThermoSystem().phaseToSystem(1));
    }

    public double getTemperature() {
        return this.temperature;
    }

    @Override
    public void setPressure(double pres) {
        this.trayPressure = pres;
    }

    @Override
    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @Override
    public double guessTemperature() {
        if (Double.isNaN(this.temperature)) {
            double gtemp = 0.0;
            int k = 0;
            while (k < this.streams.size()) {
                gtemp += ((StreamInterface)this.streams.get(k)).getThermoSystem().getTemperature() * ((StreamInterface)this.streams.get(k)).getThermoSystem().getNumberOfMoles() / this.mixedStream.getThermoSystem().getNumberOfMoles();
                ++k;
            }
            return gtemp;
        }
        return this.temperature;
    }
}

