/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.absorber;

import neqsim.processSimulation.mechanicalDesign.absorber.AbsorberMechanicalDesign;
import neqsim.processSimulation.processEquipment.absorber.AbsorberInterface;
import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.thermo.system.SystemInterface;

public class SimpleAbsorber
extends Separator
implements AbsorberInterface {
    private static final long serialVersionUID = 1000L;
    boolean setTemperature = false;
    Stream[] outStream;
    Stream[] inStream;
    SystemInterface system;
    protected double temperatureOut = 0.0;
    protected double dT = 0.0;
    private int numberOfStages = 5;
    private double numberOfTheoreticalStages = 3.0;
    double absorptionEfficiency = 0.5;
    private double HTU = 0.85;
    private double NTU = 2.0;
    private double stageEfficiency = 0.25;
    private double fsFactor = 0.0;

    public SimpleAbsorber() {
        this.mechanicalDesign = new AbsorberMechanicalDesign(this);
    }

    public SimpleAbsorber(Stream inStream1) {
        this.mechanicalDesign = new AbsorberMechanicalDesign(this);
        this.outStream = new Stream[2];
        this.inStream = new Stream[2];
        this.inStream[0] = inStream1;
        this.inStream[1] = inStream1;
        this.outStream[0] = inStream1.clone();
        this.outStream[1] = inStream1.clone();
        SystemInterface systemOut1 = inStream1.getThermoSystem().clone();
        this.outStream[0].setThermoSystem(systemOut1);
        double molCO2 = inStream1.getThermoSystem().getPhase(0).getComponent("CO2").getNumberOfmoles();
        System.out.println("mol CO2 " + molCO2);
        SystemInterface systemOut0 = inStream1.getThermoSystem().clone();
        systemOut0.init(0);
        systemOut0.addComponent("MDEA", molCO2 * this.absorptionEfficiency);
        systemOut0.addComponent("water", molCO2 * this.absorptionEfficiency * 10.0);
        systemOut0.chemicalReactionInit();
        systemOut0.createDatabase(true);
        systemOut0.setMixingRule(4);
        this.outStream[1].setThermoSystem(systemOut0);
        this.outStream[1].run();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    public void setdT(double dT) {
        this.dT = dT;
    }

    public Stream getOutStream() {
        return this.outStream[0];
    }

    public Stream getOutStream(int i) {
        return this.outStream[i];
    }

    public Stream getSolventInStream() {
        return this.inStream[0];
    }

    public Stream getInStream(int i) {
        return this.inStream[i];
    }

    public void setOutTemperature(double temperature) {
        this.temperatureOut = temperature;
    }

    public void getOutTemperature(int i) {
        this.outStream[i].getThermoSystem().getTemperature();
    }

    public void getInTemperature(int i) {
        this.inStream[i].getThermoSystem().getTemperature();
    }

    @Override
    public void run() {
        SystemInterface systemOut1 = this.inStream[1].getThermoSystem().clone();
        this.outStream[0].setThermoSystem(systemOut1);
        this.outStream[0].run();
        this.outStream[1].run();
        double error = 100000.0;
        error = this.absorptionEfficiency - (this.outStream[1].getThermoSystem().getPhase(1).getComponent("CO2").getNumberOfMolesInPhase() + this.outStream[1].getThermoSystem().getPhase(1).getComponent("HCO3-").getNumberOfMolesInPhase()) / (this.outStream[1].getThermoSystem().getPhase(1).getComponent("MDEA").getNumberOfMolesInPhase() + this.outStream[1].getThermoSystem().getPhase(1).getComponent("MDEA+").getNumberOfMolesInPhase());
        int iter = 0;
        do {
            ++iter;
            double factor = this.outStream[1].getThermoSystem().getPhase(1).getComponent("MDEA").getNumberOfMolesInPhase() + this.outStream[1].getThermoSystem().getPhase(1).getComponent("MDEA+").getNumberOfMolesInPhase();
            this.outStream[1].getThermoSystem().addComponent("MDEA", -error * factor);
            this.outStream[1].getThermoSystem().addComponent("water", -error * 10.0 * factor);
            this.outStream[1].run();
            error = this.absorptionEfficiency - (this.outStream[1].getThermoSystem().getPhase(1).getComponent("CO2").getNumberOfMolesInPhase() + this.outStream[1].getThermoSystem().getPhase(1).getComponent("HCO3-").getNumberOfMolesInPhase()) / (this.outStream[1].getThermoSystem().getPhase(1).getComponent("MDEA").getNumberOfMolesInPhase() + this.outStream[1].getThermoSystem().getPhase(1).getComponent("MDEA+").getNumberOfMolesInPhase());
            System.out.println("error " + error);
        } while (Math.abs(error) > 1.0E-4 && iter < 30 && this.outStream[1].getThermoSystem().getPhase(1).getBeta() > 0.0 && this.outStream[0].getThermoSystem().getPhase(1).getBeta() > 0.0);
    }

    @Override
    public void displayResult() {
        this.outStream[0].displayResult();
        this.outStream[1].displayResult();
    }

    public void runTransient() {
    }

    @Override
    public void setAproachToEquilibrium(double eff) {
        this.absorptionEfficiency = eff;
    }

    public double getNumberOfTheoreticalStages() {
        return this.numberOfTheoreticalStages;
    }

    public void setNumberOfTheoreticalStages(double numberOfTheoreticalStages) {
        this.numberOfTheoreticalStages = numberOfTheoreticalStages;
    }

    public int getNumberOfStages() {
        return this.numberOfStages;
    }

    public void setNumberOfStages(int numberOfStages) {
        this.numberOfStages = numberOfStages;
    }

    public double getStageEfficiency() {
        return this.stageEfficiency;
    }

    public void setStageEfficiency(double stageEfficiency) {
        this.stageEfficiency = stageEfficiency;
    }

    public double getHTU() {
        return this.HTU;
    }

    public void setHTU(double HTU) {
        this.HTU = HTU;
    }

    public double getNTU() {
        return this.NTU;
    }

    public void setNTU(double NTU) {
        this.NTU = NTU;
    }

    public double getFsFactor() {
        double intArea = 3.14 * this.getInternalDiameter() * this.getInternalDiameter() / 4.0;
        return this.getGasOutStream().getThermoSystem().getFlowRate("m3/sec") / intArea * Math.sqrt(this.getGasOutStream().getThermoSystem().getDensity("kg/m3"));
    }

    public double getWettingRate() {
        double intArea = 3.14 * this.getInternalDiameter() * this.getInternalDiameter() / 4.0;
        return this.getLiquidOutStream().getThermoSystem().getFlowRate("m3/hr") / intArea;
    }
}

