/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.measurementDevice;

import neqsim.processSimulation.measurementDevice.MeasurementDeviceBaseClass;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;

public class WaterContentAnalyser
extends MeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1000L;
    protected int streamNumber = 0;
    protected static int numberOfStreams = 0;
    protected StreamInterface stream = null;

    public WaterContentAnalyser() {
    }

    public WaterContentAnalyser(StreamInterface stream) {
        this.stream = stream;
        this.streamNumber = ++numberOfStreams;
        this.name = "water analyser";
        this.unit = "kg/day";
    }

    @Override
    public void displayResult() {
        System.out.println("total water production [kg/dag]" + this.stream.getThermoSystem().getPhase(0).getComponent("water").getNumberOfmoles() * this.stream.getThermoSystem().getPhase(0).getComponent("water").getMolarMass() * 3600.0 * 24.0);
        System.out.println("water in phase 1 (ppm) " + this.stream.getThermoSystem().getPhase(0).getComponent("water").getx() * 1000000.0);
    }

    @Override
    public double getMeasuredValue() {
        return this.stream.getThermoSystem().getPhase(0).getComponent("water").getNumberOfmoles() * this.stream.getThermoSystem().getPhase(0).getComponent("water").getMolarMass() * 3600.0 * 24.0;
    }
}

