/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.util.parameterFitting.pureComponentParameterFitting.pureCompViscosity.chungMethod;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.physicalProperties.util.parameterFitting.pureComponentParameterFitting.pureCompViscosity.chungMethod.ChungFunction;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestChungFit {
    static Logger logger = LogManager.getLogger(TestChungFit.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM purecomponentviscosity");
        try {
            while (dataSet.next()) {
                ChungFunction function = new ChungFunction();
                double[] guess = new double[]{0.3211};
                function.setInitialGuess(guess);
                SystemSrkEos testSystem = new SystemSrkEos(280.0, 0.001);
                testSystem.addComponent("MDEA", 100.0);
                testSystem.createDatabase(true);
                testSystem.init(0);
                testSystem.setMixingRule(2);
                double[] sample1 = new double[]{Double.parseDouble(dataSet.getString("Temperature"))};
                double[] standardDeviation1 = new double[]{0.1};
                SampleValue sample = new SampleValue(Double.parseDouble(dataSet.getString("Viscosity")), 0.001, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayResult();
        optim.displayCurveFit();
    }
}

