/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.diffusivity;

import neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.LiquidPhysicalPropertyMethod;
import neqsim.physicalProperties.physicalPropertyMethods.methodInterface.DiffusivityInterface;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class Diffusivity
extends LiquidPhysicalPropertyMethod
implements DiffusivityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Diffusivity.class);
    double[][] binaryDiffusionCoefficients;
    double[] effectiveDiffusionCoefficient;

    public Diffusivity() {
    }

    public Diffusivity(PhysicalPropertiesInterface liquidPhase) {
        super(liquidPhase);
        this.binaryDiffusionCoefficients = new double[liquidPhase.getPhase().getNumberOfComponents()][liquidPhase.getPhase().getNumberOfComponents()];
        this.effectiveDiffusionCoefficient = new double[liquidPhase.getPhase().getNumberOfComponents()];
    }

    @Override
    public Diffusivity clone() {
        Diffusivity properties = null;
        try {
            properties = (Diffusivity)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        properties.binaryDiffusionCoefficients = (double[][])this.binaryDiffusionCoefficients.clone();
        int i = 0;
        while (i < this.liquidPhase.getPhase().getNumberOfComponents()) {
            System.arraycopy(this.binaryDiffusionCoefficients[i], 0, properties.binaryDiffusionCoefficients[i], 0, this.liquidPhase.getPhase().getNumberOfComponents());
            ++i;
        }
        return properties;
    }

    @Override
    public double[][] calcDiffusionCoefficients(int binaryDiffusionCoefficientMethod, int multicomponentDiffusionMethod) {
        int j;
        int i = 0;
        while (i < this.liquidPhase.getPhase().getNumberOfComponents()) {
            j = 0;
            while (j < this.liquidPhase.getPhase().getNumberOfComponents()) {
                this.binaryDiffusionCoefficients[i][j] = this.calcBinaryDiffusionCoefficient(i, j, binaryDiffusionCoefficientMethod);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.liquidPhase.getPhase().getNumberOfComponents()) {
            j = 0;
            while (j < this.liquidPhase.getPhase().getNumberOfComponents()) {
                if (i != j) {
                    this.binaryDiffusionCoefficients[i][j] = Math.pow(this.binaryDiffusionCoefficients[i][j], this.liquidPhase.getPhase().getComponents()[j].getx()) * Math.pow(this.binaryDiffusionCoefficients[j][i], this.liquidPhase.getPhase().getComponents()[i].getx());
                }
                ++j;
            }
            ++i;
        }
        return this.binaryDiffusionCoefficients;
    }

    @Override
    public void calcEffectiveDiffusionCoefficients() {
        double sum = 0.0;
        int i = 0;
        while (i < this.liquidPhase.getPhase().getNumberOfComponents()) {
            sum = 0.0;
            int j = 0;
            while (j < this.liquidPhase.getPhase().getNumberOfComponents()) {
                if (i != j) {
                    sum += this.liquidPhase.getPhase().getComponents()[j].getx() / this.binaryDiffusionCoefficients[i][j];
                }
                ++j;
            }
            this.effectiveDiffusionCoefficient[i] = (1.0 - this.liquidPhase.getPhase().getComponents()[i].getx()) / sum;
            ++i;
        }
    }

    @Override
    public double getMaxwellStefanBinaryDiffusionCoefficient(int i, int j) {
        return this.binaryDiffusionCoefficients[i][j];
    }

    @Override
    public double getEffectiveDiffusionCoefficient(int i) {
        return this.effectiveDiffusionCoefficient[i];
    }

    @Override
    public double getFickBinaryDiffusionCoefficient(int i, int j) {
        double temp = i == j ? 1.0 : 0.0;
        double nonIdealCorrection = temp + this.liquidPhase.getPhase().getComponents()[i].getx() * this.liquidPhase.getPhase().getComponents()[i].getdfugdn(j) * this.liquidPhase.getPhase().getNumberOfMolesInPhase();
        if (Double.isNaN(nonIdealCorrection)) {
            nonIdealCorrection = 1.0;
        }
        return this.binaryDiffusionCoefficients[i][j] * nonIdealCorrection;
    }
}

