/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.density;

import neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.LiquidPhysicalPropertyMethod;
import neqsim.physicalProperties.physicalPropertyMethods.methodInterface.DensityInterface;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Density
extends LiquidPhysicalPropertyMethod
implements DensityInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Density.class);

    public Density() {
    }

    public Density(PhysicalPropertiesInterface liquidPhase) {
        this.liquidPhase = liquidPhase;
    }

    @Override
    public Density clone() {
        Density properties = null;
        try {
            properties = (Density)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return properties;
    }

    @Override
    public double calcDensity() {
        double tempVar = 0.0;
        if (this.liquidPhase.getPhase().useVolumeCorrection()) {
            int i = 0;
            while (i < this.liquidPhase.getPhase().getNumberOfComponents()) {
                tempVar += this.liquidPhase.getPhase().getComponents()[i].getx() * (this.liquidPhase.getPhase().getComponents()[i].getVolumeCorrection() + this.liquidPhase.getPhase().getComponents()[i].getVolumeCorrectionT() * (this.liquidPhase.getPhase().getTemperature() - 288.15));
                ++i;
            }
        }
        return 1.0 / (this.liquidPhase.getPhase().getMolarVolume() - tempVar) * this.liquidPhase.getPhase().getMolarMass() * 100000.0;
    }
}

