/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.mixingRule;

import java.sql.ResultSet;
import neqsim.physicalProperties.mixingRule.PhysicalPropertyMixingRuleInterface;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhysicalPropertyMixingRule
implements PhysicalPropertyMixingRuleInterface,
ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PhysicalPropertyMixingRule.class);
    public double[][] Gij;

    @Override
    public PhysicalPropertyMixingRule clone() {
        PhysicalPropertyMixingRule mixRule = null;
        try {
            mixRule = (PhysicalPropertyMixingRule)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        double[][] Gij2 = (double[][])this.Gij.clone();
        int i = 0;
        while (i < Gij2.length) {
            Gij2[i] = (double[])Gij2[i].clone();
            ++i;
        }
        mixRule.Gij = Gij2;
        return mixRule;
    }

    @Override
    public double getViscosityGij(int i, int j) {
        return this.Gij[i][j];
    }

    @Override
    public void setViscosityGij(double val, int i, int j) {
        this.Gij[i][j] = val;
    }

    public PhysicalPropertyMixingRuleInterface getPhysicalPropertyMixingRule() {
        return this;
    }

    @Override
    public void initMixingRules(PhaseInterface phase) {
        this.Gij = new double[phase.getNumberOfComponents()][phase.getNumberOfComponents()];
        NeqSimDataBase database = null;
        ResultSet dataSet = null;
        database = new NeqSimDataBase();
        int l = 0;
        while (l < phase.getNumberOfComponents()) {
            if (phase.getComponent(l).isIsTBPfraction() || phase.getComponent(l).getIonicCharge() != 0.0) break;
            String component_name = phase.getComponents()[l].getComponentName();
            int k = l;
            while (k < phase.getNumberOfComponents()) {
                block20: {
                    if (k == l || phase.getComponent(k).getIonicCharge() != 0.0 || phase.getComponent(k).isIsTBPfraction()) break;
                    try {
                        try {
                            dataSet = database.getResultSet("SELECT gijvisc FROM inter WHERE (COMP1='" + component_name + "' AND COMP2='" + phase.getComponents()[k].getComponentName() + "') OR (COMP1='" + phase.getComponents()[k].getComponentName() + "' AND COMP2='" + component_name + "')");
                            this.Gij[l][k] = dataSet.next() ? Double.parseDouble(dataSet.getString("gijvisc")) : 0.0;
                            this.Gij[k][l] = this.Gij[l][k];
                        }
                        catch (Exception e) {
                            logger.error("err in phys prop.....");
                            String err = e.toString();
                            logger.error(err);
                            try {
                                if (dataSet != null) {
                                    dataSet.close();
                                }
                                break block20;
                            }
                            catch (Exception e2) {
                                logger.error("err closing dataSet in physical property mixing rule...", (Throwable)e2);
                            }
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (dataSet != null) {
                                dataSet.close();
                            }
                        }
                        catch (Exception e) {
                            logger.error("err closing dataSet in physical property mixing rule...", (Throwable)e);
                        }
                        throw throwable;
                    }
                    try {
                        if (dataSet != null) {
                            dataSet.close();
                        }
                    }
                    catch (Exception e) {
                        logger.error("err closing dataSet in physical property mixing rule...", (Throwable)e);
                    }
                }
                ++k;
            }
            ++l;
        }
        try {
            if (database.getStatement() != null) {
                database.getStatement().close();
            }
            if (database.getConnection() != null) {
                database.getConnection().close();
            }
        }
        catch (Exception e) {
            logger.error("error closing database.....", (Throwable)e);
        }
    }
}

