/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.interfaceProperties.surfaceTension;

import neqsim.physicalProperties.interfaceProperties.surfaceTension.GTSurfaceTensionUtils;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import no.uib.cipr.matrix.BandMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GTSurfaceTensionFullGT {
    static Logger logger = LogManager.getLogger(GTSurfaceTensionFullGT.class);
    private int ncomp;
    private SystemInterface sys;
    private double[] ci;
    private double[] mueq;
    private double[] rho_ph1;
    private double[] rho_ph2;
    private double t;
    private double[] p0;
    private static final double Pa = 1.0E-5;
    private static final double m3 = 1.0E-5;
    public double normtol = 1.0E-11;
    public double reltol = 1.0E-6;
    public double abstol = 1.0E-6;
    public int maxit = 40;
    private static final boolean NDEBUG = true;
    private static final boolean DEBUGPLOT = false;

    public GTSurfaceTensionFullGT(SystemInterface flashedSystem, int phase1, int phase2) {
        int i = 0;
        this.sys = flashedSystem.clone();
        this.ncomp = this.sys.getPhase(0).getNumberOfComponents();
        this.t = this.sys.getPhase(0).getTemperature();
        this.rho_ph1 = new double[this.ncomp];
        this.rho_ph2 = new double[this.ncomp];
        this.p0 = new double[1];
        this.ci = new double[this.ncomp];
        this.mueq = new double[this.ncomp];
        boolean hasAddedComp = false;
        i = 0;
        while (i < this.ncomp) {
            if (this.sys.getPhase(phase1).getComponent(i).getx() < Double.MIN_VALUE) {
                this.sys.addComponent(i, this.sys.getTotalNumberOfMoles() / 1.0E10);
                hasAddedComp = true;
            }
            ++i;
        }
        if (hasAddedComp) {
            ThermodynamicOperations ops = new ThermodynamicOperations(this.sys);
            ops.TPflash();
        }
        i = 0;
        while (i < this.ncomp) {
            this.ci[i] = this.sys.getPhase(0).getComponent(i).getSurfaceTenisionInfluenceParameter(this.t);
            this.rho_ph1[i] = this.sys.getPhase(phase1).getComponent(i).getx() / this.sys.getPhase(phase1).getMolarVolume() / 1.0E-5;
            this.rho_ph2[i] = this.sys.getPhase(phase2).getComponent(i).getx() / this.sys.getPhase(phase2).getMolarVolume() / 1.0E-5;
            ++i;
        }
        this.sys.setBeta(1.0);
        this.sys.init(0);
        this.sys.setUseTVasIndependentVariables(true);
        this.sys.setNumberOfPhases(1);
        this.sys.getPhase(0).setTotalVolume(1.0);
        this.sys.useVolumeCorrection(false);
        this.sys.setEmptyFluid();
        double[] nv = new double[this.ncomp];
        i = 0;
        while (i < this.ncomp) {
            nv[i] = this.rho_ph1[i] * 1.0E-5;
            ++i;
        }
        this.sys.setTotalFlowRate(1.0, "mol/sec");
        this.sys.setMolarComposition(nv);
        this.sys.init_x_y();
        this.sys.setBeta(1.0);
        this.sys.init(3);
    }

    /*
     * Unable to fully structure code
     */
    public double runcase() {
        cij = new double[this.ncomp][this.ncomp];
        delta_mu = new double[this.ncomp];
        dmu_drho = new double[this.ncomp][this.ncomp];
        sigma = 0.0;
        Nlevel = 3;
        Ngrid = (1 << Nlevel) + 1;
        rhomat = new double[Ngrid][this.ncomp];
        Nrefinements = 7;
        StopTolerance = 0.01;
        sigma_old = 9.9E99;
        nm = 1.0;
        L = 3.0 * nm;
        N_Newton = 20;
        maxRelChange = 0.5;
        highOrder = true;
        directMethod = true;
        GTSurfaceTensionFullGT.initmu(this.sys, this.ncomp, this.t, this.rho_ph1, this.rho_ph2, this.mueq, this.p0, this.reltol);
        N2 = 1 << Nlevel - 1;
        i = 0;
        while (i < N2) {
            rhomat[i] = (double[])this.rho_ph1.clone();
            ++i;
        }
        N1 = N2;
        N2 = 1 + (1 << Nlevel);
        i = N1;
        while (i < N2) {
            rhomat[i] = (double[])this.rho_ph2.clone();
            ++i;
        }
        i = 0;
        while (i < this.ncomp) {
            this.ci[i] = this.sys.getPhase(0).getComponent(i).getSurfaceTenisionInfluenceParameter(this.t);
            ++i;
        }
        i = 0;
        while (i < this.ncomp) {
            j = i;
            while (j < this.ncomp) {
                cij[i][j] = 1.0E18 * Math.sqrt(this.ci[i] * this.ci[j]);
                cij[j][i] = cij[i][j];
                ++j;
            }
            ++i;
        }
        GTSurfaceTensionFullGT.delta_mu(this.sys, this.ncomp, this.t, this.mueq, this.rho_ph1, delta_mu, dmu_drho);
        xgrid = GTSurfaceTensionFullGT.linspace(-L, L, Ngrid);
        i = 0;
        while (i < Nrefinements) {
            sigma = GTSurfaceTensionFullGT.Newton(cij, L, N_Newton, maxRelChange, highOrder, directMethod, rhomat, this.sys, this.ncomp, this.t, this.mueq);
            drhodz = new double[rhomat.length - 1][this.ncomp];
            sigma = GTSurfaceTensionFullGT.sigmaCalc(xgrid[1] - xgrid[0], rhomat, cij, false, drhodz, this.ncomp);
            std = this.calc_std_integral(xgrid, cij, drhodz);
            if (i > 0 && Math.abs(sigma - sigma_old) < StopTolerance * sigma) break;
            sigma_old = sigma;
            H = 2.0 * L / ((double)Ngrid - 1.0);
            Nhalf = (int)Math.round(Math.ceil(6.0 * std / H));
            Nideal = 2 * Nhalf + 1;
            Lnew = (double)Nhalf * H;
            NgridNew = 2 * Nideal - 1;
            xgridNew = GTSurfaceTensionFullGT.linspace(-Lnew, Lnew, NgridNew);
            kk = 0;
            rhotmp = new double[NgridNew][this.ncomp];
            j = 0;
            while (j < rhotmp.length) {
                block10: {
                    block9: {
                        if (!(xgridNew[j] < xgrid[0])) break block9;
                        rhotmp[j] = (double[])this.rho_ph1.clone();
                        break block10;
                    }
                    if (!(xgridNew[j] > xgrid[xgrid.length - 1])) ** GOTO lbl74
                    rhotmp[j] = (double[])this.rho_ph2.clone();
                    break block10;
lbl-1000:
                    // 1 sources

                    {
                        ++kk;
lbl74:
                        // 2 sources

                        ** while (xgridNew[j] > xgrid[kk + 1])
                    }
lbl75:
                    // 1 sources

                    alpha = (xgrid[kk + 1] - xgridNew[j]) / (xgrid[kk + 1] - xgrid[kk]);
                    k = 0;
                    while (k < this.ncomp) {
                        rhotmp[j][k] = alpha * rhomat[kk][k] + (1.0 - alpha) * rhomat[kk + 1][k];
                        ++k;
                    }
                }
                ++j;
            }
            rhotmp[0] = (double[])this.rho_ph1.clone();
            rhotmp[rhotmp.length - 1] = (double[])this.rho_ph2.clone();
            L = Lnew;
            rhomat = rhotmp;
            Ngrid = NgridNew;
            xgrid = xgridNew;
            ++i;
        }
        return sigma;
    }

    public static double Newton(double[][] cij, double L, int N_Newton, double allowedRelChange, boolean highOrder, boolean directMethod, double[][] rhomat, SystemInterface sys, int ncomp, double t, double[] mueq) {
        int k;
        int j;
        int Ngrid = rhomat.length;
        double H = 2.0 * L / (double)(Ngrid - 1);
        double[][][] Jac = new double[Ngrid][ncomp][ncomp];
        double[][] dmu = new double[Ngrid][ncomp];
        double[][] rres = new double[Ngrid][ncomp];
        double[][] rrho_prev = new double[Ngrid][ncomp];
        double[][] drhodz = new double[Ngrid - 1][ncomp];
        double sigma = 0.0;
        double[] xgrid = GTSurfaceTensionFullGT.linspace(-L, L, Ngrid);
        int i = 0;
        while (i < Ngrid) {
            GTSurfaceTensionFullGT.delta_mu(sys, ncomp, t, mueq, rhomat[i], dmu[i], Jac[i]);
            j = 0;
            while (j < ncomp) {
                rres[i][j] = dmu[i][j];
                k = 0;
                while (k < ncomp) {
                    double[] dArray = rres[i];
                    int n = j;
                    dArray[n] = dArray[n] - Jac[i][j][k] * rhomat[i][k];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (highOrder) {
            i = 1;
            while (i < Ngrid - 1) {
                j = 0;
                while (j < ncomp) {
                    double[] dArray = rres[i];
                    int n = j;
                    dArray[n] = dArray[n] + (dmu[i - 1][j] - 2.0 * dmu[i][j] + dmu[i + 1][j]) / 12.0;
                    ++j;
                }
                ++i;
            }
        }
        int NewtonStep = 0;
        while (NewtonStep < N_Newton) {
            i = 0;
            while (i < Ngrid) {
                j = 0;
                while (j < ncomp) {
                    rrho_prev[i][j] = rhomat[i][j];
                    ++j;
                }
                ++i;
            }
            GTSurfaceTensionFullGT.directsolve(rres, Jac, cij, H, Ngrid, rhomat, ncomp);
            double maxrelchange = 0.0;
            i = 1;
            while (i < Ngrid - 1) {
                j = 0;
                while (j < ncomp) {
                    if (Math.abs(rhomat[i][j] - rrho_prev[i][j]) > maxrelchange * Math.abs(rrho_prev[i][j])) {
                        maxrelchange = Math.abs(rhomat[i][j] - rrho_prev[i][j]) / Math.abs(rrho_prev[i][j]);
                    }
                    ++j;
                }
                ++i;
            }
            double urel_Newton = Math.min(allowedRelChange / maxrelchange, 1.0);
            i = 1;
            while (i < Ngrid - 1) {
                j = 0;
                while (j < ncomp) {
                    rhomat[i][j] = urel_Newton * rhomat[i][j] + (1.0 - urel_Newton) * rrho_prev[i][j];
                    ++j;
                }
                ++i;
            }
            if (urel_Newton * maxrelchange < 1.0E-5) break;
            sigma = GTSurfaceTensionFullGT.sigmaCalc(H, rhomat, cij, false, drhodz, ncomp);
            double sum_ztmp = 0.0;
            double sum_tmp = 0.0;
            i = 0;
            while (i < drhodz.length) {
                double tmp = 0.0;
                j = 0;
                while (j < ncomp) {
                    k = 0;
                    while (k < ncomp) {
                        tmp += drhodz[i][j] * cij[j][k] * drhodz[i][k];
                        ++k;
                    }
                    ++j;
                }
                sum_ztmp += 0.5 * (xgrid[i + 1] + xgrid[i]) * tmp;
                sum_tmp += tmp;
                ++i;
            }
            double cg = sum_ztmp / sum_tmp;
            int icorr = (int)Math.round(cg / H);
            if (icorr > 0) {
                i = 1;
                while (i < Ngrid - icorr) {
                    rhomat[i] = rhomat[i + icorr];
                    ++i;
                }
                i = Ngrid - icorr;
                while (i < Ngrid - 1) {
                    rhomat[i] = (double[])rhomat[Ngrid - 1].clone();
                    ++i;
                }
            } else if (icorr < 0) {
                icorr = -icorr;
                i = Ngrid - 2;
                while (i >= icorr) {
                    rhomat[i] = rhomat[i - icorr];
                    --i;
                }
                i = 1;
                while (i < icorr) {
                    rhomat[i] = (double[])rhomat[0].clone();
                    ++i;
                }
            }
            i = 1;
            while (i < Ngrid - 1) {
                GTSurfaceTensionFullGT.delta_mu(sys, ncomp, t, mueq, rhomat[i], dmu[i], Jac[i]);
                j = 0;
                while (j < ncomp) {
                    rres[i][j] = dmu[i][j];
                    k = 0;
                    while (k < ncomp) {
                        double[] dArray = rres[i];
                        int n = j;
                        dArray[n] = dArray[n] - Jac[i][j][k] * rhomat[i][k];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            if (highOrder) {
                i = 1;
                while (i < Ngrid - 1) {
                    j = 0;
                    while (j < ncomp) {
                        double[] dArray = rres[i];
                        int n = j;
                        dArray[n] = dArray[n] + (dmu[i - 1][j] - 2.0 * dmu[i][j] + dmu[i + 1][j]) / 12.0;
                        ++j;
                    }
                    ++i;
                }
            }
            ++NewtonStep;
        }
        return sigma;
    }

    public static void directsolve(double[][] rres, double[][][] JJ, double[][] C, double H, int Ngrid, double[][] rhomat, int ncomp) {
        int skip;
        int k;
        double bbtmp;
        int j;
        double H2 = H * H;
        int Neq = (Ngrid - 2) * ncomp;
        int kl = 2 * ncomp + 1;
        int ku = 2 * ncomp + 1;
        BandMatrix Jac = new BandMatrix(Neq, kl, ku);
        DenseMatrix bb = new DenseMatrix(Neq, 1);
        DenseMatrix drho = new DenseMatrix(Neq, 1);
        int iglob = 0;
        int i = 1;
        while (i < Ngrid - 1) {
            j = 0;
            while (j < ncomp) {
                bbtmp = rres[i][j];
                k = 0;
                while (k < ncomp) {
                    bbtmp += JJ[i][j][k] * rhomat[i][k] - C[j][k] * (rhomat[i - 1][k] - 2.0 * rhomat[i][k] + rhomat[i + 1][k]) / H2;
                    ++k;
                }
                bb.set(iglob++, 0, -bbtmp);
                ++j;
            }
            ++i;
        }
        i = 1;
        j = 0;
        while (j < ncomp) {
            k = 0;
            while (k < ncomp) {
                Jac.set(j, k, JJ[i][j][k] + 2.0 / H2 * C[j][k]);
                Jac.set(j, k + ncomp, -1.0 / H2 * C[j][k]);
                ++k;
            }
            ++j;
        }
        i = 2;
        while (i < Ngrid - 2) {
            skip = ncomp * (i - 1);
            j = 0;
            while (j < ncomp) {
                k = 0;
                while (k < ncomp) {
                    Jac.set(j + skip, k + skip - ncomp, -1.0 / H2 * C[j][k]);
                    Jac.set(j + skip, k + skip, JJ[i][j][k] + 2.0 / H2 * C[j][k]);
                    Jac.set(j + skip, k + skip + ncomp, -1.0 / H2 * C[j][k]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = Ngrid - 2;
        skip = ncomp * (i - 1);
        j = 0;
        while (j < ncomp) {
            k = 0;
            while (k < ncomp) {
                Jac.set(j + skip, k + skip - ncomp, -1.0 / H2 * C[j][k]);
                Jac.set(j + skip, k + skip, JJ[i][j][k] + 2.0 / H2 * C[j][k]);
                ++k;
            }
            ++j;
        }
        Jac.solve(bb, drho);
        iglob = 0;
        i = 1;
        while (i < Ngrid - 1) {
            j = 0;
            while (j < ncomp) {
                bbtmp = drho.get(iglob++, 0);
                double[] dArray = rhomat[i];
                int n = j++;
                dArray[n] = dArray[n] + bbtmp;
            }
            ++i;
        }
    }

    public static double sigmaCalc(double h, double[][] rrho, double[][] C, boolean highOrder, double[][] drhodz, int ncomp) {
        int j;
        int i = 0;
        while (i < rrho.length - 1) {
            j = 0;
            while (j < ncomp) {
                drhodz[i][j] = (rrho[i + 1][j] - rrho[i][j]) / h;
                ++j;
            }
            ++i;
        }
        double sigma = 0.0;
        j = 0;
        while (j < ncomp) {
            int k = 0;
            while (k < ncomp) {
                double drho2 = 0.0;
                i = 0;
                while (i < rrho.length - 1) {
                    drho2 += drhodz[i][j] * drhodz[i][k];
                    ++i;
                }
                sigma += C[j][k] * drho2;
                ++k;
            }
            ++j;
        }
        return sigma *= h * 1.0E-9;
    }

    public double calc_std_integral(double[] z, double[][] C, double[][] drhodz) {
        double h1 = z[1] - z[0];
        int Ngrid = drhodz.length + 1;
        double zdum = 0.0;
        double z2dum = 0.0;
        double sumdum = 0.0;
        int j = 0;
        while (j < Ngrid - 1) {
            double dum = 0.0;
            int m = 0;
            while (m < this.ncomp) {
                int n = 0;
                while (n < this.ncomp) {
                    dum = drhodz[j][m] * C[m][n] * drhodz[j][n];
                    ++n;
                }
                ++m;
            }
            sumdum += dum * h1;
            zdum += dum * (z[j + 1] * z[j + 1] - z[j] * z[j]) / 2.0;
            z2dum += dum * (z[j + 1] * z[j + 1] * z[j + 1] - z[j] * z[j] * z[j]) / 3.0;
            ++j;
        }
        double mean = zdum / sumdum;
        double std_integral = Math.sqrt(z2dum / sumdum - mean * mean);
        return std_integral;
    }

    public static void delta_mu(SystemInterface sys, int ncomp, double t, double[] mueq, double[] rho, double[] delta_mu, double[][] dmu_drho) {
        double[] pdummy = new double[ncomp];
        double[] mu = new double[ncomp];
        GTSurfaceTensionUtils.mufun(sys, ncomp, t, rho, mu, dmu_drho, pdummy);
        int i = 0;
        while (i < ncomp) {
            delta_mu[i] = mu[i] - mueq[i];
            ++i;
        }
    }

    public static double[] linspace(double a, double b, int N) {
        double[] x = new double[N];
        double dx = (b - a) / (double)(N - 1);
        int i = 0;
        while (i < N) {
            x[i] = a + (double)i * dx;
            ++i;
        }
        return x;
    }

    public static void debugPlot(double[] x, double[][] y) {
        int N = y.length;
        int M = y[0].length;
        double[] yy = new double[N];
        int j = 0;
        while (j < M) {
            int i = 0;
            while (i < N) {
                yy[i] = Math.log10(y[i][j]);
                ++i;
            }
            ++j;
        }
    }

    public static void initmu(SystemInterface sys, int ncomp, double t, double[] rho_ph1, double[] rho_ph2, double[] mueq, double[] p0, double reltol) {
        double maxerr = 0.0;
        double[][] dmu_drho1 = new double[ncomp][ncomp];
        double[][] dmu_drho2 = new double[ncomp][ncomp];
        double[] mueq2 = new double[ncomp];
        GTSurfaceTensionUtils.mufun(sys, ncomp, t, rho_ph1, mueq, dmu_drho1, p0);
        GTSurfaceTensionUtils.mufun(sys, ncomp, t, rho_ph2, mueq2, dmu_drho2, p0);
        int i = 0;
        while (i < ncomp) {
            maxerr = Math.max(maxerr, Math.abs(mueq[i] / mueq2[i] - 1.0));
            ++i;
        }
        if (maxerr > reltol) {
            logger.error("Flash is not properly solved.  Maximum relative error in chemical potential:  " + maxerr + " > " + reltol);
            throw new RuntimeException("Flash not solved!");
        }
    }
}

