/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.interfaceProperties.surfaceTension;

import neqsim.physicalProperties.interfaceProperties.surfaceTension.SurfaceTension;
import neqsim.thermo.system.SystemInterface;

public class FirozabadiRamleyInterfaceTension
extends SurfaceTension {
    private static final long serialVersionUID = 1000L;

    public FirozabadiRamleyInterfaceTension() {
    }

    public FirozabadiRamleyInterfaceTension(SystemInterface system) {
        super(system);
    }

    @Override
    public double calcPureComponentSurfaceTension(int componentNumber) {
        return 0.001 * Math.pow(this.system.getPhases()[0].getComponents()[componentNumber].getParachorParameter() * 1.0E-6 * (this.system.getPhases()[1].getPhysicalProperties().getDensity() / this.system.getPhases()[1].getMolarMass() * this.system.getPhases()[1].getComponents()[componentNumber].getx() - this.system.getPhases()[0].getPhysicalProperties().getDensity() / this.system.getPhases()[0].getMolarMass() * this.system.getPhases()[0].getComponents()[componentNumber].getx()), 4.0);
    }

    @Override
    public double calcSurfaceTension(int interface1, int interface2) {
        if (this.system.getNumberOfPhases() < 2) {
            return 0.0;
        }
        double deltaDens = Math.abs(this.system.getPhase(interface2).getPhysicalProperties().getDensity() - this.system.getPhase(interface1).getPhysicalProperties().getDensity());
        double Tr = this.system.getPhase(interface1).getTemperature() / this.system.getPhase(interface1).getPseudoCriticalTemperature();
        double a1 = 0.0;
        double b1 = 0.0;
        if (deltaDens / 1000.0 < 0.2) {
            a1 = 2.2062;
            b1 = -0.94716;
        } else if (deltaDens / 1000.0 < 0.5) {
            a1 = 2.915;
            b1 = -0.76852;
        } else {
            a1 = 3.3858;
            b1 = -0.6259;
        }
        double temp1 = a1 * Math.pow(deltaDens / 1000.0, b1 + 1.0) / Math.pow(Tr, 0.3125);
        return Math.pow(temp1, 4.0) / 1000.0;
    }
}

