/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowSystem;

import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.flowSolver.FlowSolverInterface;
import neqsim.fluidMechanics.geometryDefinitions.GeometryDefinitionInterface;
import neqsim.fluidMechanics.util.fluidMechanicsDataHandeling.FileWriterInterface;
import neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowSystemVisualization.FlowSystemVisualizationInterface;
import neqsim.fluidMechanics.util.timeSeries.TimeSeries;
import neqsim.thermo.system.SystemInterface;

public interface FlowSystemInterface {
    public void init();

    public void setNodes();

    public void solveTransient(int var1);

    public TimeSeries getTimeSeries();

    public FlowSystemVisualizationInterface getDisplay();

    public FileWriterInterface getFileWriter(int var1);

    public FlowSolverInterface getSolver();

    public double getInletTemperature();

    public double getInletPressure();

    public void setNumberOfLegs(int var1);

    public int getNumberOfLegs();

    public void setNumberOfNodesInLeg(int var1);

    public int getNumberOfNodesInLeg(int var1);

    public void setLegHeights(double[] var1);

    public double[] getLegHeights();

    public void setLegPositions(double[] var1);

    public void createSystem();

    public FlowNodeInterface getNode(int var1);

    public double getSystemLength();

    public void setLegOuterHeatTransferCoefficients(double[] var1);

    public void setLegWallHeatTransferCoefficients(double[] var1);

    public void setEquipmentGeometry(GeometryDefinitionInterface[] var1);

    public int getTotalNumberOfNodes();

    public void calcFluxes();

    public void setEndPressure(double var1);

    public void setInletThermoSystem(SystemInterface var1);

    public void solveSteadyState(int var1);

    public FlowNodeInterface[] getFlowNodes();

    public void print();

    public void setLegOuterTemperatures(double[] var1);

    public double getTotalMolarMassTransferRate(int var1);

    public double getTotalMolarMassTransferRate(int var1, int var2);

    public double getTotalPressureDrop();

    public double getTotalPressureDrop(int var1);

    public void setInitialFlowPattern(String var1);

    public void setFlowPattern(String var1);

    public void setEquilibriumMassTransfer(boolean var1);

    public void setEquilibriumHeatTransfer(boolean var1);
}

