/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowNode.twoPhaseNode.twoPhasePipeFlowNode;

import neqsim.fluidMechanics.flowNode.FlowNodeInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.nonEquilibriumFluidBoundary.filmModelBoundary.KrishnaStandartFilmModel;
import neqsim.fluidMechanics.flowNode.fluidBoundary.interphaseTransportCoefficient.interphaseTwoPhase.interphasePipeFlow.InterphaseStratifiedFlow;
import neqsim.fluidMechanics.flowNode.twoPhaseNode.TwoPhaseFlowNode;
import neqsim.fluidMechanics.flowNode.twoPhaseNode.twoPhasePipeFlowNode.DropletFlowNode;
import neqsim.fluidMechanics.geometryDefinitions.GeometryDefinitionInterface;
import neqsim.fluidMechanics.geometryDefinitions.pipe.PipeData;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class StratifiedFlowNode
extends TwoPhaseFlowNode {
    private static final long serialVersionUID = 1000L;

    public StratifiedFlowNode() {
        this.flowNodeType = "stratified";
    }

    public StratifiedFlowNode(SystemInterface system, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "stratified";
        this.interphaseTransportCoefficient = new InterphaseStratifiedFlow(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    public StratifiedFlowNode(SystemInterface system, SystemInterface interphaseSystem, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.flowNodeType = "stratified";
        this.interphaseTransportCoefficient = new InterphaseStratifiedFlow(this);
        this.fluidBoundary = new KrishnaStandartFilmModel(this);
    }

    @Override
    public StratifiedFlowNode clone() {
        StratifiedFlowNode clonedSystem = null;
        try {
            clonedSystem = (StratifiedFlowNode)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return clonedSystem;
    }

    @Override
    public void init() {
        this.inclination = 0.0;
        this.calcContactLength();
        super.init();
    }

    @Override
    public double calcContactLength() {
        double phaseAngel = 3.14159265 * this.phaseFraction[1] + Math.pow(4.7123889750000005, 0.3333333333333333) * (1.0 - 2.0 * this.phaseFraction[1] + Math.pow(this.phaseFraction[1], 0.3333333333333333) - Math.pow(this.phaseFraction[0], 0.3333333333333333));
        this.wallContactLength[1] = phaseAngel * this.pipe.getDiameter();
        this.wallContactLength[0] = 3.14159265 * this.pipe.getDiameter() - this.wallContactLength[1];
        this.interphaseContactLength[0] = this.pipe.getDiameter() * Math.sin(phaseAngel);
        this.interphaseContactLength[1] = this.pipe.getDiameter() * Math.sin(phaseAngel);
        return this.wallContactLength[0];
    }

    @Override
    public FlowNodeInterface getNextNode() {
        StratifiedFlowNode newNode = this.clone();
        int i = 0;
        while (i < this.getBulkSystem().getPhases()[0].getNumberOfComponents()) {
            ++i;
        }
        return newNode;
    }

    public static void main(String[] args) {
        SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(325.3, 100.0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        PipeData pipe1 = new PipeData(0.250203, 2.5E-4);
        testSystem.addComponent("methane", 0.1, "MSm3/day", 0);
        testSystem.addComponent("water", 2.0, "kg/hr", 1);
        testSystem.addComponent("MEG", 3.0, "kg/hr", 1);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(10);
        testSystem.initPhysicalProperties();
        testSystem.init_x_y();
        testSystem.initBeta();
        testSystem.init(3);
        testSystem.display();
        DropletFlowNode test2 = new DropletFlowNode(testSystem, pipe1);
        test2.setInterphaseModelType(1);
        test2.setLengthOfNode(0.001);
        test2.getGeometry().getSurroundingEnvironment().setTemperature(277.15);
        test2.getFluidBoundary().setHeatTransferCalc(false);
        test2.getFluidBoundary().setMassTransferCalc(true);
        double length = 0.0;
        test2.initFlowCalc();
        double[][] temperatures2 = new double[3][1000];
        int k = 0;
        int i = 0;
        while (i < 100000) {
            length += test2.getLengthOfNode();
            test2.initFlowCalc();
            test2.calcFluxes();
            if (i > 1 && i % 1000 == 0) {
                test2.display("length " + length);
                System.out.println("length " + length + " wt% MEG " + test2.getBulkSystem().getPhase("aqueous").getWtFrac("MEG") * 100.0);
                temperatures2[0][++k] = length;
                temperatures2[1][k] = test2.getGeometry().getInnerWallTemperature();
            }
            test2.update();
            ++i;
        }
        i = 0;
        while (i < k) {
            System.out.println("len temp  " + temperatures2[0][i] + " " + temperatures2[1][i]);
            ++i;
        }
        System.out.println("contact length " + test2.getInterphaseContactArea());
    }
}

