/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowNode.onePhaseNode.onePhasePipeFlowNode;

import neqsim.fluidMechanics.flowNode.fluidBoundary.interphaseTransportCoefficient.interphaseOnePhase.interphasePipeFlow.InterphasePipeFlow;
import neqsim.fluidMechanics.flowNode.onePhaseNode.onePhaseFlowNode;
import neqsim.fluidMechanics.geometryDefinitions.GeometryDefinitionInterface;
import neqsim.fluidMechanics.geometryDefinitions.pipe.PipeData;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class onePhasePipeFlowNode
extends onePhaseFlowNode {
    private static final long serialVersionUID = 1000L;

    public onePhasePipeFlowNode() {
    }

    public onePhasePipeFlowNode(SystemInterface system, GeometryDefinitionInterface pipe) {
        super(system, pipe);
        this.interphaseTransportCoefficient = new InterphasePipeFlow(this);
        this.phaseOps = new ThermodynamicOperations(this.getBulkSystem());
        this.phaseOps.TPflash();
        this.initBulkSystem();
    }

    @Override
    public onePhasePipeFlowNode clone() {
        onePhasePipeFlowNode clonedSystem = null;
        try {
            clonedSystem = (onePhasePipeFlowNode)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return clonedSystem;
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public double calcReynoldsNumber() {
        this.reynoldsNumber[0] = this.getVelocity() * this.pipe.getDiameter() / this.getBulkSystem().getPhases()[0].getPhysicalProperties().getKinematicViscosity();
        return this.reynoldsNumber[0];
    }

    public static void main(String[] args) {
        System.out.println("Starter.....");
        SystemSrkEos testSystem = new SystemSrkEos(300.3, 200.0);
        PipeData pipe1 = new PipeData(1.0, 0.0025);
        testSystem.addComponent("methane", 50000.0);
        testSystem.addComponent("ethane", 1.0);
        testSystem.init(0);
        testSystem.init(1);
        onePhasePipeFlowNode[] test2 = new onePhasePipeFlowNode[100];
        test2[0] = new onePhasePipeFlowNode(testSystem, pipe1);
        test2[0].initFlowCalc();
        test2[0].init();
        System.out.println("flow: " + test2[0].getVolumetricFlow() + " velocity: " + test2[0].getVelocity() + " reynolds number " + test2[0].getReynoldsNumber() + "friction : " + test2[0].getWallFrictionFactor());
    }
}

