/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.finiteVolumeBoundary.fluidBoundarySystem.fluidBoundarySystemReactive;

import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.FluidBoundaryInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.finiteVolumeBoundary.fluidBoundaryNode.fluidBoundaryReactiveNode.FluidBoundaryNodeReactive;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.finiteVolumeBoundary.fluidBoundarySystem.FluidBoundarySystem;
import neqsim.fluidMechanics.flowNode.twoPhaseNode.twoPhasePipeFlowNode.StratifiedFlowNode;
import neqsim.fluidMechanics.geometryDefinitions.pipe.PipeData;
import neqsim.thermo.system.SystemFurstElectrolyteEos;

public class FluidBoundarySystemReactive
extends FluidBoundarySystem {
    public FluidBoundarySystemReactive() {
    }

    public FluidBoundarySystemReactive(FluidBoundaryInterface boundary) {
        super(boundary);
        this.reactive = true;
    }

    @Override
    public void createSystem() {
        this.nodes = new FluidBoundaryNodeReactive[this.numberOfNodes];
        super.createSystem();
        int i = 0;
        while (i < this.numberOfNodes) {
            this.nodes[i] = new FluidBoundaryNodeReactive(this.boundary.getInterphaseSystem());
            ++i;
        }
        System.out.println("system created...");
    }

    public static void main(String[] args) {
        SystemFurstElectrolyteEos testSystem = new SystemFurstElectrolyteEos(275.3, 1.01325);
        PipeData pipe1 = new PipeData(10.0, 0.025);
        testSystem.addComponent("methane", 0.061152181, 0);
        testSystem.addComponent("water", 0.1862204876, 1);
        testSystem.chemicalReactionInit();
        testSystem.setMixingRule(2);
        testSystem.init_x_y();
        StratifiedFlowNode test2 = new StratifiedFlowNode(testSystem, pipe1);
        test2.setInterphaseModelType(10);
        test2.initFlowCalc();
        test2.calcFluxes();
        test2.getFluidBoundary().setEnhancementType(0);
        test2.calcFluxes();
    }
}

