/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.finiteVolumeBoundary.fluidBoundarySolver;

import Jama.Matrix;
import neqsim.MathLib.generalMath.TDMAsolve;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.finiteVolumeBoundary.fluidBoundarySolver.FluidBoundarySolverInterface;
import neqsim.fluidMechanics.flowNode.fluidBoundary.heatMassTransferCalc.finiteVolumeBoundary.fluidBoundarySystem.FluidBoundarySystemInterface;

public class FluidBoundarySolver
implements FluidBoundarySolverInterface {
    FluidBoundarySystemInterface boundary;
    double[][] xNew;
    protected Matrix[] solMatrix;
    protected Matrix[] diffMatrix;
    protected double[] a;
    protected double[] b;
    protected double[] c;
    protected double[] r;
    boolean reactive = false;

    public FluidBoundarySolver() {
    }

    public FluidBoundarySolver(FluidBoundarySystemInterface boundary) {
        this.boundary = boundary;
        this.initProfiles();
        this.a = new double[boundary.getNumberOfNodes()];
        this.b = new double[boundary.getNumberOfNodes()];
        this.c = new double[boundary.getNumberOfNodes()];
        this.r = new double[boundary.getNumberOfNodes()];
        this.solMatrix = new Matrix[boundary.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()];
        this.diffMatrix = new Matrix[boundary.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()];
        int k = 0;
        while (k < boundary.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()) {
            this.diffMatrix[k] = new Matrix(this.a, 1).transpose();
            this.solMatrix[k] = new Matrix(this.a, 1).transpose();
            ++k;
        }
    }

    public FluidBoundarySolver(FluidBoundarySystemInterface boundary, boolean reactive) {
        this(boundary);
        this.reactive = reactive;
    }

    public void initProfiles() {
        Matrix reacRates = new Matrix(1, 1);
        int i = 0;
        while (i < this.boundary.getNumberOfNodes() - 1) {
            this.boundary.getNode(i).getBulkSystem().init(3);
            this.boundary.getNode(i).getBulkSystem().getPhases()[1].initPhysicalProperties();
            this.boundary.getNode(i).getBulkSystem().getPhases()[1].getPhysicalProperties().calcEffectiveDiffusionCoefficients();
            int j = 0;
            while (j < this.boundary.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()) {
                double xbulk = this.boundary.getFluidBoundary().getBulkSystem().getPhases()[1].getComponents()[j].getx();
                double xinterphase = this.boundary.getFluidBoundary().getInterphaseSystem().getPhases()[1].getComponents()[j].getx();
                double dx = xinterphase - xbulk;
                double last = this.boundary.getNode(i).getBulkSystem().getPhases()[1].getComponents()[j].getx();
                if (this.reactive) {
                    this.boundary.getNode(i + 1).getBulkSystem().getPhases()[1].getComponents()[j].setx(last - dx - reacRates.get(j, 0) / this.boundary.getNode(i).getBulkSystem().getPhases()[1].getPhysicalProperties().getEffectiveDiffusionCoefficient(j) * Math.pow(this.boundary.getNodeLength(), 2.0));
                } else {
                    this.boundary.getNode(i + 1).getBulkSystem().getPhases()[1].getComponents()[j].setx(xinterphase - dx * ((double)(i + 1) / (double)this.boundary.getNumberOfNodes()));
                }
                System.out.println("x comp " + this.reactive + "  " + this.boundary.getNode(i).getBulkSystem().getPhases()[1].getComponents()[j].getx());
                ++j;
            }
            ++i;
        }
    }

    public void initMatrix() {
        int j = 0;
        while (j < this.boundary.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()) {
            int i = 0;
            while (i < this.boundary.getNumberOfNodes()) {
                this.solMatrix[j].set(i, 0, this.boundary.getNode(i).getBulkSystem().getPhases()[1].getComponents()[j].getx());
                ++i;
            }
            ++j;
        }
    }

    public void initComposition(int iter) {
        int j = 0;
        while (j < this.boundary.getNumberOfNodes()) {
            int p = 0;
            while (p < this.boundary.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()) {
                this.boundary.getNode(j).getBulkSystem().getPhases()[1].getComponents()[p].setx(this.solMatrix[p].get(j, 0));
                ++p;
            }
            this.boundary.getNode(j).getBulkSystem().getPhases()[0].normalize();
            this.boundary.getNode(j).getBulkSystem().init(3);
            ++j;
        }
    }

    public void setComponentConservationMatrix(int componentNumber) {
        int i = 0;
        while (i < this.boundary.getNumberOfNodes()) {
            this.boundary.getNode(i).getBulkSystem().getPhases()[1].initPhysicalProperties();
            this.boundary.getNode(i).getBulkSystem().getPhases()[1].getPhysicalProperties().calcEffectiveDiffusionCoefficients();
            ++i;
        }
        this.a[0] = 0.0;
        this.c[0] = 0.0;
        this.b[0] = 1.0;
        this.r[0] = this.boundary.getNode(0).getBulkSystem().getPhases()[1].getComponents()[componentNumber].getx();
        System.out.println("b0 :" + this.b[0]);
        this.a[0] = -this.a[0];
        this.c[0] = -this.c[0];
        i = 1;
        while (i < this.boundary.getNumberOfNodes() - 1) {
            double Dw = (this.boundary.getNode(i - 1).getBulkSystem().getPhases()[1].getPhysicalProperties().getEffectiveDiffusionCoefficient(componentNumber) + this.boundary.getNode(i).getBulkSystem().getPhases()[1].getPhysicalProperties().getEffectiveDiffusionCoefficient(componentNumber)) / 2.0;
            double De = (this.boundary.getNode(i).getBulkSystem().getPhases()[1].getPhysicalProperties().getEffectiveDiffusionCoefficient(componentNumber) + this.boundary.getNode(i + 1).getBulkSystem().getPhases()[1].getPhysicalProperties().getEffectiveDiffusionCoefficient(componentNumber)) / 2.0;
            this.a[i] = Dw / this.boundary.getNodeLength();
            this.c[i] = De / this.boundary.getNodeLength();
            this.b[i] = this.a[i] + this.c[i];
            this.r[i] = 0.0;
            this.a[i] = -this.a[i];
            this.c[i] = -this.c[i];
            ++i;
        }
        i = this.boundary.getNumberOfNodes() - 1;
        this.a[i] = 0.0;
        this.c[i] = 0.0;
        this.b[i] = 1.0;
        this.r[i] = this.boundary.getNode(i).getBulkSystem().getPhases()[1].getComponents()[componentNumber].getx();
        System.out.println("bn :" + this.b[i]);
        this.a[i] = -this.a[i];
        this.c[i] = -this.c[i];
    }

    @Override
    public double getMolarFlux(int componentNumber) {
        double temp = 1.0;
        if (this.reactive) {
            temp = 2.1;
        }
        return temp * this.boundary.getNode(0).getBulkSystem().getPhases()[1].getPhysicalProperties().getEffectiveDiffusionCoefficient(componentNumber) * (this.boundary.getNode(0).getBulkSystem().getPhases()[1].getComponents()[componentNumber].getx() - this.boundary.getNode(1).getBulkSystem().getPhases()[1].getComponents()[componentNumber].getx()) / this.boundary.getNodeLength();
    }

    @Override
    public void solve() {
        int iter = 0;
        int iterTop = 0;
        double maxDiff = 0.0;
        double diff = 0.0;
        this.xNew = new double[this.boundary.getNode(0).getBulkSystem().getPhases()[0].getNumberOfComponents()][this.boundary.getNumberOfNodes()];
        this.initProfiles();
        this.initMatrix();
        this.initComposition(1);
        System.out.println(" vol " + this.boundary.getNode(2).getBulkSystem().getPhases()[0].getMolarVolume());
        do {
            maxDiff = 0.0;
            ++iterTop;
            iter = 0;
            do {
                ++iter;
                int p = 0;
                while (p < this.boundary.getNode(0).getBulkSystem().getPhases()[1].getNumberOfComponents()) {
                    this.setComponentConservationMatrix(p);
                    Matrix solOld = this.solMatrix[p].copy();
                    solOld.print(20, 20);
                    this.xNew[p] = TDMAsolve.solve(this.a, this.b, this.c, this.r);
                    this.solMatrix[p] = new Matrix(this.xNew[p], 1).transpose();
                    this.solMatrix[p].print(20, 20);
                    this.diffMatrix[p] = this.solMatrix[p].minus(solOld);
                    diff = Math.abs(this.diffMatrix[p].norm1() / this.solMatrix[p].norm1());
                    if (diff > maxDiff) {
                        maxDiff = diff;
                    }
                    ++p;
                }
            } while (diff > 1.0E-15 && iter < 100);
            System.out.println("maxDiff " + maxDiff);
        } while (Math.abs(maxDiff) > 1.0E-10 && iterTop < 10);
    }
}

