/*
 * Decompiled with CFR 0.152.
 */
package neqsim.dataPresentation.fileHandeling.createNetCDF;

import java.io.IOException;
import java.io.Serializable;
import ucar.ma2.Array;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;

public class NetCdf
implements Serializable {
    private static final long serialVersionUID = 1000L;
    String fileName = "c:/temp/example.nc";
    double[] xvalues = new double[3];
    String xName = "xDefault";
    String yName = "yDefault";
    String zName = "zDefault";
    double[] yvalues = new double[4];
    double[][] zvalues = new double[4][4];
    NetcdfFileWriteable ncfile;

    public void setOutputFileName(String name) {
        this.fileName = name;
    }

    public void setXvalues(double[] x, String name, String unit) {
        this.xvalues = x;
        this.xName = name;
    }

    public void setYvalues(double[] y, String name, String unit) {
        this.yvalues = y;
        this.yName = name;
    }

    public void setZvalues(double[][] z, String name, String unit) {
        this.zvalues = z;
        this.zName = name;
    }

    public void createFile() {
        this.ncfile = new NetcdfFileWriteable();
        this.ncfile.setName(this.fileName);
        Dimension latD = this.ncfile.addDimension(this.xName, this.xvalues.length);
        Dimension lonD = this.ncfile.addDimension(this.yName, this.yvalues.length);
        Dimension[] dim2 = new Dimension[]{latD, lonD};
        this.ncfile.addVariable("T", Double.TYPE, dim2);
        this.ncfile.addVariableAttribute("T", "long_name", "surface temperature");
        this.ncfile.addVariableAttribute("T", "units", "degC");
        this.ncfile.addVariable(latD.getName(), Double.TYPE, new Dimension[]{latD});
        this.ncfile.addVariableAttribute(latD.getName(), "units", "degrees_north");
        this.ncfile.addVariable(lonD.getName(), Double.TYPE, new Dimension[]{lonD});
        this.ncfile.addVariableAttribute(lonD.getName(), "units", "degrees_east");
        this.ncfile.addGlobalAttribute("title", "Example Data");
        try {
            this.ncfile.create();
        }
        catch (IOException e) {
            System.err.println("ERROR creating file");
        }
        try {
            this.ncfile.write("T", Array.factory((Object)this.zvalues));
            this.ncfile.write(latD.getName(), Array.factory((Object)this.xvalues));
            this.ncfile.write(lonD.getName(), Array.factory((Object)this.yvalues));
        }
        catch (Exception e) {
            System.err.println("ERROR writing file");
        }
        try {
            this.ncfile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("created " + this.fileName + " successfully");
    }
}

