/*
 * Decompiled with CFR 0.152.
 */
package neqsim.PVTsimulation.util.parameterfitting;

import neqsim.PVTsimulation.simulation.SaturationPressure;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardtFunction;
import neqsim.thermo.system.SystemInterface;

public class SaturationPressureFunction
extends LevenbergMarquardtFunction {
    double molarMass = 0.0;

    public SaturationPressureFunction() {
        this.params = new double[1];
    }

    @Override
    public double calcValue(double[] dependentValues) {
        int plusNumber = 0;
        this.molarMass = this.params[0];
        int i = 0;
        while (i < this.system.getPhase(0).getNumberOfComponents()) {
            if (this.system.getPhase(0).getComponent(i).isIsPlusFraction()) {
                plusNumber = i;
            }
            ++i;
        }
        SystemInterface tempSystem = this.system.clone();
        tempSystem.resetCharacterisation();
        tempSystem.createDatabase(true);
        tempSystem.setMixingRule(this.system.getMixingRule());
        tempSystem.getPhase(0).getComponent(plusNumber).setMolarMass(this.molarMass);
        tempSystem.getPhase(1).getComponent(plusNumber).setMolarMass(this.molarMass);
        tempSystem.setTemperature(dependentValues[0]);
        tempSystem.setPressure(50.0);
        tempSystem.getCharacterization().characterisePlusFraction();
        tempSystem.createDatabase(true);
        tempSystem.setMixingRule(this.system.getMixingRule());
        tempSystem.init(0);
        tempSystem.init(1);
        SaturationPressure satCalc = new SaturationPressure(tempSystem);
        double satPres = satCalc.calcSaturationPressure();
        return satPres;
    }

    @Override
    public void setFittingParams(int i, double value) {
        this.params[i] = value;
    }
}

