/*
 * Decompiled with CFR 0.152.
 */
package neqsim.PVTsimulation.simulation;

import java.util.ArrayList;
import neqsim.PVTsimulation.simulation.BasePVTsimulation;
import neqsim.physicalProperties.util.parameterFitting.pureComponentParameterFitting.pureCompViscosity.linearLiquidModel.ViscosityFunction;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;

public class DensitySim
extends BasePVTsimulation {
    double[] temperature = new double[1];
    double[] pressure = new double[1];
    private double[] waxFraction = null;
    private double[] gasDensity;
    private double[] oilDensity;
    private double[] aqueousDensity;

    public DensitySim(SystemInterface tempSystem) {
        super(tempSystem);
        this.temperature[0] = tempSystem.getTemperature();
        this.pressure[0] = tempSystem.getPressure();
    }

    public void setTemperaturesAndPressures(double[] temperature, double[] pressure) {
        this.pressure = pressure;
        this.temperature = temperature;
        this.experimentalData = new double[temperature.length][1];
    }

    public void runTuning() {
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        try {
            System.out.println("adding....");
            int i = 0;
            while (i < this.experimentalData[0].length) {
                ViscosityFunction function = new ViscosityFunction();
                double[] guess = new double[]{1.0};
                function.setInitialGuess(guess);
                SystemInterface tempSystem = this.getThermoSystem();
                tempSystem.setTemperature(this.temperature[i]);
                tempSystem.setPressure(this.pressure[i]);
                this.thermoOps.TPflash();
                double[] sample1 = new double[]{this.temperature[i]};
                double viscosity = this.experimentalData[0][i];
                double[] standardDeviation1 = new double[]{1.5};
                SampleValue sample = new SampleValue(viscosity, viscosity / 50.0, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(tempSystem);
                sampleList.add(sample);
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        this.optimizer = new LevenbergMarquardt();
        this.optimizer.setMaxNumberOfIterations(20);
        this.optimizer.setSampleSet(sampleSet);
        this.optimizer.solve();
        this.runCalc();
        this.optimizer.displayCurveFit();
    }

    public void runCalc() {
        this.gasDensity = new double[this.pressure.length];
        this.oilDensity = new double[this.pressure.length];
        this.aqueousDensity = new double[this.pressure.length];
        int i = 0;
        while (i < this.pressure.length) {
            this.getThermoSystem().setPressure(this.pressure[i]);
            this.getThermoSystem().setTemperature(this.temperature[i]);
            this.thermoOps.TPflash();
            this.getThermoSystem().initPhysicalProperties();
            this.waxFraction[i] = 0.0;
            if (this.getThermoSystem().hasPhaseType("gas")) {
                this.gasDensity[i] = this.getThermoSystem().getPhase("gas").getPhysicalProperties().getViscosity();
            }
            if (this.getThermoSystem().hasPhaseType("oil")) {
                this.oilDensity[i] = this.getThermoSystem().getPhase("oil").getPhysicalProperties().getViscosity();
            }
            if (this.getThermoSystem().hasPhaseType("aqueous")) {
                this.aqueousDensity[i] = this.getThermoSystem().getPhase("aqueous").getPhysicalProperties().getViscosity();
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        SystemSrkEos tempSystem = new SystemSrkEos(298.0, 10.0);
        tempSystem.addPlusFraction("C20", 10.62, 0.1, 0.73);
        tempSystem.createDatabase(true);
        tempSystem.setMixingRule(2);
        tempSystem.init(0);
        tempSystem.init(1);
        DensitySim sepSim = new DensitySim(tempSystem);
        double[] temps = new double[]{300.15, 293.15, 283.15, 273.15, 264.15};
        double[] pres = new double[]{5.0, 5.0, 5.0, 5.0, 5.0};
        sepSim.setTemperaturesAndPressures(temps, pres);
        sepSim.runCalc();
        double[][] expData = new double[][]{{2.0E-4, 3.0E-4, 4.0E-4, 5.0E-4, 6.0E-4}};
        sepSim.setExperimentalData(expData);
        sepSim.runTuning();
        double a = sepSim.getGasDensity()[0];
        double a2 = sepSim.getOilDensity()[0];
        sepSim.getThermoSystem().display();
    }

    public double[] getWaxFraction() {
        return this.waxFraction;
    }

    public double[] getGasDensity() {
        return this.gasDensity;
    }

    public double[] getOilDensity() {
        return this.oilDensity;
    }

    public double[] getAqueousDensity() {
        return this.aqueousDensity;
    }
}

