/*
 * Decompiled with CFR 0.152.
 */
package neqsim.util.generator;

import java.util.HashMap;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class PropertyGenerator {
    double[] temperatures;
    double[] pressures;
    SystemInterface fluid = null;
    HashMap<String, double[]> properties = new HashMap();

    public PropertyGenerator(SystemInterface fluid, double[] temperatures, double[] pressures) {
        this.fluid = fluid;
        this.temperatures = temperatures;
        this.pressures = pressures;
    }

    public HashMap<String, double[]> calculate() {
        ThermodynamicOperations ops = new ThermodynamicOperations(this.fluid);
        int length = this.temperatures.length;
        double[] molarmass = new double[length];
        double[] molarmassGas = new double[length];
        double[] molarmassOil = new double[length];
        double[] molarmassAqueous = new double[length];
        double[] numberOfPhases = new double[length];
        double[] locpressure = new double[length];
        double[] loctemperature = new double[length];
        double[] molefraction = new double[length];
        double[] molarVolume = new double[length];
        double[] gamma = new double[length];
        double[] thermalconductivity = new double[length];
        double[] soundspeedGas = new double[length];
        double[] wtfractionGas = new double[length];
        double[] molefractionGas = new double[length];
        double[] molarvolumeGas = new double[length];
        double[] volumefractionGas = new double[length];
        double[] gammaGas = new double[length];
        double[] joulethomsoncoefficientGas = new double[length];
        double[] thermalconductivitygas = new double[length];
        double[] soundspeedOil = new double[length];
        double[] wtfractionOil = new double[length];
        double[] molefractionOil = new double[length];
        double[] molarvolumeOil = new double[length];
        double[] volumefractionOil = new double[length];
        double[] gammaOil = new double[length];
        double[] joulethomsoncoefficientOil = new double[length];
        double[] thermalconductivityOil = new double[length];
        double[] soundspeedAqueous = new double[length];
        double[] wtfractionAqueous = new double[length];
        double[] molefractionAqueous = new double[length];
        double[] molarvolumeAqueous = new double[length];
        double[] volumefractionAqueous = new double[length];
        double[] gammaAqueous = new double[length];
        double[] joulethomsoncoefficientAqueous = new double[length];
        double[] thermalconductivityAqueous = new double[length];
        double[] Z = new double[length];
        double[] ZGas = new double[length];
        double[] ZOil = new double[length];
        double[] ZAqueous = new double[length];
        double[] viscosity = new double[length];
        double[] viscosityGas = new double[length];
        double[] viscosityOil = new double[length];
        double[] viscosityAqueous = new double[length];
        double[] enthalpy = new double[length];
        double[] enthalpyGas = new double[length];
        double[] enthalpyOil = new double[length];
        double[] enthalpyAqueous = new double[length];
        double[] entropy = new double[length];
        double[] entropyGas = new double[length];
        double[] entropyOil = new double[length];
        double[] entropyAqueous = new double[length];
        double[] Cp = new double[length];
        double[] CpGas = new double[length];
        double[] CpOil = new double[length];
        double[] CpAqueous = new double[length];
        double[] Cv = new double[length];
        double[] CvGas = new double[length];
        double[] CvOil = new double[length];
        double[] CvAqueous = new double[length];
        double[] density2 = new double[length];
        double[] densityGas = new double[length];
        double[] densityOil = new double[length];
        double[] densityAqueous = new double[length];
        int i = 0;
        while (i < length) {
            block9: {
                this.fluid.setTemperature(this.temperatures[i]);
                this.fluid.setPressure(this.pressures[i]);
                try {
                    ops.TPflash();
                    this.fluid.initProperties();
                }
                catch (Exception ex) {
                    break block9;
                }
                molarmass[i] = this.fluid.getMolarMass();
                Z[i] = this.fluid.getZ();
                viscosity[i] = this.fluid.getViscosity("cP");
                enthalpy[i] = this.fluid.getEnthalpy("J/mol");
                entropy[i] = this.fluid.getEnthalpy("J/molK");
                Cp[i] = this.fluid.getCp("kJ/kgK");
                Cv[i] = this.fluid.getCp("kJ/kgK");
                density2[i] = this.fluid.getDensity("kg/m3");
                numberOfPhases[i] = this.fluid.getNumberOfPhases();
                locpressure[i] = this.fluid.getPressure("Pa");
                loctemperature[i] = this.fluid.getTemperature("K");
                molefraction[i] = this.fluid.getMoleFractionsSum();
                molarVolume[i] = 1.0 / this.fluid.getDensity("mol/m3");
                gamma[i] = this.fluid.getGamma();
                thermalconductivity[i] = this.fluid.getThermalConductivity("W/mK");
                if (this.fluid.hasPhaseType("gas")) {
                    int phasenumb = this.fluid.getPhaseNumberOfPhase("gas");
                    molarmassGas[i] = this.fluid.getPhase(phasenumb).getMolarMass();
                    ZGas[i] = this.fluid.getPhase(phasenumb).getZ();
                    viscosityGas[i] = this.fluid.getPhase(phasenumb).getViscosity("kg/msec");
                    enthalpyGas[i] = this.fluid.getPhase(phasenumb).getEnthalpy("J/mol");
                    entropyGas[i] = this.fluid.getPhase(phasenumb).getEntropy("J/molK");
                    CpGas[i] = this.fluid.getPhase(phasenumb).getCp("kJ/kgK");
                    CvGas[i] = this.fluid.getPhase(phasenumb).getCv("kJ/kgK");
                    densityGas[i] = this.fluid.getPhase(phasenumb).getDensity("kg/m3");
                    soundspeedGas[i] = this.fluid.getPhase(phasenumb).getSoundSpeed();
                    wtfractionGas[i] = this.fluid.getWtFraction(phasenumb);
                    molefractionGas[i] = this.fluid.getMoleFraction(phasenumb);
                    molarvolumeGas[i] = 1.0 / this.fluid.getPhase(phasenumb).getDensity("mol/m3");
                    volumefractionGas[i] = this.fluid.getCorrectedVolumeFraction(phasenumb);
                    gammaGas[i] = this.fluid.getPhase(phasenumb).getKappa();
                    joulethomsoncoefficientGas[i] = this.fluid.getPhase(phasenumb).getJouleThomsonCoefficient() / 100000.0;
                    thermalconductivitygas[i] = this.fluid.getPhase(phasenumb).getThermalConductivity("W/mK");
                } else {
                    molarmassGas[i] = Double.NaN;
                    ZGas[i] = Double.NaN;
                    viscosityGas[i] = Double.NaN;
                    enthalpyGas[i] = Double.NaN;
                    entropyGas[i] = Double.NaN;
                    CpGas[i] = Double.NaN;
                    CvGas[i] = Double.NaN;
                    densityGas[i] = Double.NaN;
                    soundspeedGas[i] = Double.NaN;
                    wtfractionGas[i] = Double.NaN;
                    molefractionGas[i] = Double.NaN;
                    molarvolumeGas[i] = Double.NaN;
                    volumefractionGas[i] = Double.NaN;
                    gammaGas[i] = Double.NaN;
                    joulethomsoncoefficientGas[i] = Double.NaN;
                    thermalconductivitygas[i] = Double.NaN;
                }
                if (this.fluid.hasPhaseType("oil")) {
                    int phasenumb = this.fluid.getPhaseNumberOfPhase("oil");
                    molarmassOil[i] = this.fluid.getPhase(phasenumb).getMolarMass();
                    ZOil[i] = this.fluid.getPhase(phasenumb).getZ();
                    viscosityOil[i] = this.fluid.getPhase(phasenumb).getViscosity("kg/msec");
                    enthalpyOil[i] = this.fluid.getPhase(phasenumb).getEnthalpy("J/mol");
                    entropyOil[i] = this.fluid.getPhase(phasenumb).getEntropy("J/molK");
                    CpOil[i] = this.fluid.getPhase(phasenumb).getCp("kJ/kgK");
                    CvOil[i] = this.fluid.getPhase(phasenumb).getCv("kJ/kgK");
                    densityOil[i] = this.fluid.getPhase(phasenumb).getDensity("kg/m3");
                    soundspeedOil[i] = this.fluid.getPhase(phasenumb).getSoundSpeed();
                    wtfractionOil[i] = this.fluid.getWtFraction(phasenumb);
                    molefractionOil[i] = this.fluid.getMoleFraction(phasenumb);
                    molarvolumeOil[i] = 1.0 / this.fluid.getPhase(phasenumb).getDensity("mol/m3");
                    volumefractionOil[i] = this.fluid.getCorrectedVolumeFraction(phasenumb);
                    gammaOil[i] = this.fluid.getPhase(phasenumb).getKappa();
                    joulethomsoncoefficientOil[i] = this.fluid.getPhase(phasenumb).getJouleThomsonCoefficient() / 100000.0;
                    thermalconductivityOil[i] = this.fluid.getPhase(phasenumb).getThermalConductivity("W/mK");
                } else {
                    molarmassOil[i] = Double.NaN;
                    ZOil[i] = Double.NaN;
                    viscosityOil[i] = Double.NaN;
                    enthalpyOil[i] = Double.NaN;
                    entropyOil[i] = Double.NaN;
                    CpOil[i] = Double.NaN;
                    CvOil[i] = Double.NaN;
                    densityOil[i] = Double.NaN;
                    soundspeedOil[i] = Double.NaN;
                    wtfractionOil[i] = Double.NaN;
                    molefractionOil[i] = Double.NaN;
                    molarvolumeOil[i] = Double.NaN;
                    volumefractionOil[i] = Double.NaN;
                    gammaOil[i] = Double.NaN;
                    joulethomsoncoefficientOil[i] = Double.NaN;
                    thermalconductivityOil[i] = Double.NaN;
                }
                if (this.fluid.hasPhaseType("aqueous")) {
                    int phasenumb = this.fluid.getPhaseNumberOfPhase("aqueous");
                    molarmassAqueous[i] = this.fluid.getPhase(phasenumb).getMolarMass();
                    ZAqueous[i] = this.fluid.getPhase(phasenumb).getZ();
                    viscosityAqueous[i] = this.fluid.getPhase(phasenumb).getViscosity("kg/msec");
                    enthalpyAqueous[i] = this.fluid.getPhase(phasenumb).getEnthalpy("J/mol");
                    entropyAqueous[i] = this.fluid.getPhase(phasenumb).getEntropy("J/molK");
                    CpAqueous[i] = this.fluid.getPhase(phasenumb).getCp("kJ/kgK");
                    CvAqueous[i] = this.fluid.getPhase(phasenumb).getCv("kJ/kgK");
                    densityAqueous[i] = this.fluid.getPhase(phasenumb).getDensity("kg/m3");
                    soundspeedAqueous[i] = this.fluid.getPhase(phasenumb).getSoundSpeed();
                    wtfractionAqueous[i] = this.fluid.getWtFraction(phasenumb);
                    molefractionAqueous[i] = this.fluid.getMoleFraction(phasenumb);
                    molarvolumeAqueous[i] = 1.0 / this.fluid.getPhase(phasenumb).getDensity("mol/m3");
                    volumefractionAqueous[i] = this.fluid.getCorrectedVolumeFraction(phasenumb);
                    gammaAqueous[i] = this.fluid.getPhase(phasenumb).getKappa();
                    joulethomsoncoefficientAqueous[i] = this.fluid.getPhase(phasenumb).getJouleThomsonCoefficient() / 100000.0;
                    thermalconductivityAqueous[i] = this.fluid.getPhase(phasenumb).getThermalConductivity("W/mK");
                } else {
                    molarmassAqueous[i] = Double.NaN;
                    ZAqueous[i] = Double.NaN;
                    viscosityAqueous[i] = Double.NaN;
                    enthalpyAqueous[i] = Double.NaN;
                    entropyAqueous[i] = Double.NaN;
                    CpAqueous[i] = Double.NaN;
                    CvAqueous[i] = Double.NaN;
                    densityAqueous[i] = Double.NaN;
                    soundspeedAqueous[i] = Double.NaN;
                    wtfractionAqueous[i] = Double.NaN;
                    molefractionAqueous[i] = Double.NaN;
                    molarvolumeAqueous[i] = Double.NaN;
                    volumefractionAqueous[i] = Double.NaN;
                    gammaAqueous[i] = Double.NaN;
                    joulethomsoncoefficientAqueous[i] = Double.NaN;
                    thermalconductivityAqueous[i] = Double.NaN;
                }
            }
            ++i;
        }
        this.properties.put("molarmass[kg/mol]", molarmass);
        this.properties.put("molarmass_gas[kg/mol]", molarmassGas);
        this.properties.put("molarmass_oil[kg/mol]", molarmassOil);
        this.properties.put("molarmass_aqueous[kg/mol]", molarmassAqueous);
        this.properties.put("density[kg/m3]", density2);
        this.properties.put("Z[-]", Z);
        this.properties.put("numberofphases[-]", numberOfPhases);
        this.properties.put("pressure[Pa]", locpressure);
        this.properties.put("temperature[K]", loctemperature);
        this.properties.put("molefraction[-]", molefraction);
        this.properties.put("molarvolume[m3/mol]", molarVolume);
        this.properties.put("gamma[-]", gamma);
        this.properties.put("enthalpy[J/mol]", enthalpy);
        this.properties.put("entropy[J/molK]", entropy);
        this.properties.put("Cp[J/molK]", Cp);
        this.properties.put("Cv[J/molK]", Cv);
        this.properties.put("thermalconductivity[W/mK]", thermalconductivity);
        this.properties.put("viscosity[kg/msec]", viscosity);
        this.properties.put("density_gas[kg/m3]", densityGas);
        this.properties.put("Z_gas[-]", ZGas);
        this.properties.put("soundspeed_gas[m/sec]", soundspeedGas);
        this.properties.put("wtfraction_gas[-]", wtfractionGas);
        this.properties.put("molefraction_gas[-]", molefractionGas);
        this.properties.put("molarvolume_gas[m3/mol]", molarvolumeGas);
        this.properties.put("volumefraction_gas[-]", volumefractionGas);
        this.properties.put("gamma_gas[-]", gammaGas);
        this.properties.put("joulethomsoncoefficient_gas[K/Pa]", joulethomsoncoefficientGas);
        this.properties.put("enthalpy_gas[J/mol]", enthalpyGas);
        this.properties.put("entropy_gas[J/molK]", entropyGas);
        this.properties.put("Cp_gas[J/molK]", CpGas);
        this.properties.put("Cv_gas[J/molK]", CvGas);
        this.properties.put("thermalconductivity_gas[W/mK]", thermalconductivitygas);
        this.properties.put("viscosity_gas[kg/msec]", viscosityGas);
        this.properties.put("density_oil[kg/m3]", densityOil);
        this.properties.put("Z_oil[-]", ZOil);
        this.properties.put("soundspeed_oil[m/sec]", soundspeedOil);
        this.properties.put("wtfraction_oil[-]", wtfractionOil);
        this.properties.put("molefraction_oil[-]", molefractionOil);
        this.properties.put("molarvolume_oil[m3/mol]", molarvolumeOil);
        this.properties.put("volumefraction_oil[-]", volumefractionOil);
        this.properties.put("gamma_oil[-]", gammaOil);
        this.properties.put("joulethomsoncoefficient_oil[K/Pa]", joulethomsoncoefficientOil);
        this.properties.put("enthalpy_oil[J/mol]", enthalpyOil);
        this.properties.put("entropy_oil[J/molK]", entropyOil);
        this.properties.put("Cp_oil[J/molK]", CpOil);
        this.properties.put("Cv_oil[J/molK]", CvOil);
        this.properties.put("thermalconductivity_oil[W/mK]", thermalconductivityOil);
        this.properties.put("viscosity_oil[kg/msec]", viscosityOil);
        this.properties.put("density_aqueous[kg/m3]", densityAqueous);
        this.properties.put("Z_aqueous[-]", ZAqueous);
        this.properties.put("soundspeed_aqueous[m/sec]", soundspeedAqueous);
        this.properties.put("wtfraction_aqueous[-]", wtfractionAqueous);
        this.properties.put("molefraction_aqueous[-]", molefractionAqueous);
        this.properties.put("molarvolume_aqueous[m3/mol]", molarvolumeAqueous);
        this.properties.put("volumefraction_aqueous[-]", volumefractionAqueous);
        this.properties.put("gamma_aqueous[-]", gammaAqueous);
        this.properties.put("enthalpy_aqueous[J/mol]", enthalpyAqueous);
        this.properties.put("entropy_aqueous[J/molK]", entropyAqueous);
        this.properties.put("Cp_aqueous[J/molK]", CpAqueous);
        this.properties.put("Cv_aqueous[J/molK]", CvAqueous);
        this.properties.put("joulethomsoncoefficient_aqueous[K/Pa]", joulethomsoncoefficientAqueous);
        this.properties.put("thermalconductivity_aqueous[W/mK]", thermalconductivityAqueous);
        this.properties.put("viscosity_aqueous[kg/msec]", viscosityAqueous);
        return this.properties;
    }

    public double getValue(String propertyName) {
        return 0.0;
    }
}

