/*
 * Decompiled with CFR 0.152.
 */
package neqsim.util.database;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import neqsim.util.util.FileSystemSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NeqSimDataBase
implements FileSystemSettings,
Serializable {
    private static final long serialVersionUID = 1000L;
    public static String dataBasePath = "";
    static Logger logger = LogManager.getLogger(NeqSimDataBase.class);
    private static boolean createTemporaryTables = false;
    private static String dataBaseType = "Derby";
    private static String connectionString = "jdbc:derby:classpath:data/neqsimthermodatabase";
    private static String username = "remote";
    private static String password = "remote";
    private Statement statement = null;
    protected Connection databaseConnection = null;

    public static boolean createTemporaryTables() {
        return createTemporaryTables;
    }

    public static void setCreateTemporaryTables(boolean createTemporaryTables) {
        NeqSimDataBase.createTemporaryTables = createTemporaryTables;
    }

    public NeqSimDataBase() {
        NeqSimDataBase.setDataBaseType(dataBaseType);
        try {
            this.databaseConnection = this.openConnection();
            this.statement = this.databaseConnection.createStatement();
        }
        catch (Exception ex) {
            logger.error("SQLException " + ex.getMessage());
            throw new RuntimeException(ex);
        }
    }

    public Connection openConnection() throws SQLException, ClassNotFoundException {
        InitialContext ctx = null;
        DataSource ds = null;
        try {
            if (System.getenv("NEQSIMTHERMODB_CS") != null) {
                Properties properties = new Properties();
                properties.setProperty("user", System.getenv("MYSQL_USER"));
                properties.setProperty("password", System.getenv("MYSQL_PASSWORD"));
                properties.setProperty("useSSL", "false");
                Connection connection = DriverManager.getConnection(System.getenv("NEQSIMTHERMODB_CS"), properties);
                return connection;
            }
            if (dataBaseType.equals("MSAccess")) {
                String dir = "";
                dir = System.getProperty("NeqSim.home") == null ? "c:\\programming\\NeqSimSourceCode\\java\\neqsim" : System.getProperty("NeqSim.home");
                Connection connection = DriverManager.getConnection("jdbc:odbc:DRIVER={Microsoft Access Driver (*.mdb)};DBQ=" + dir + "\\data\\NeqSimDatabase");
                return connection;
            }
            if (dataBaseType.equals("H2") || dataBaseType.equals("H2RT")) {
                Connection connection = DriverManager.getConnection(connectionString, "sa", "");
                return connection;
            }
            if (dataBaseType.equals("MSAccessUCanAccess")) {
                Connection connection = DriverManager.getConnection(NeqSimDataBase.getConnectionString());
                return connection;
            }
            if (dataBaseType.equals("mySQL") || dataBaseType.equals("mySQLNTNU") || dataBaseType.equals("Derby")) {
                Connection connection = DriverManager.getConnection(NeqSimDataBase.getConnectionString(), username, password);
                return connection;
            }
            if (dataBaseType.equals("mySQLNeqSimWeb")) {
                ctx = new InitialContext();
                ds = (DataSource)ctx.lookup("java:comp/env/jdbc/NeqsimThermoDatabase");
                Connection connection = ds.getConnection();
                return connection;
            }
            Connection connection = DriverManager.getConnection(NeqSimDataBase.getConnectionString());
            return connection;
        }
        catch (Exception ex) {
            logger.error("error loading NeqSimDataBase... " + ex.toString());
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception ex) {
                logger.error("error", (Throwable)ex);
            }
        }
    }

    public Connection getConnection() {
        return this.databaseConnection;
    }

    public ResultSet getResultSet(String sqlString) {
        try {
            ResultSet result = this.getStatement().executeQuery(sqlString);
            return result;
        }
        catch (Exception ex) {
            logger.error("error loading NeqSimbataBase " + ex.toString());
            throw new RuntimeException(ex);
        }
    }

    public void execute(String sqlString) {
        try {
            if (this.databaseConnection == null) {
                this.databaseConnection = this.openConnection();
                this.setStatement(this.databaseConnection.createStatement());
            }
            this.getStatement().execute(sqlString);
        }
        catch (Exception ex) {
            logger.error("error in NeqSimDataBase " + ex.toString(), (Throwable)ex);
            logger.error("The database must be rgistered on the local DBMS to work.");
            throw new RuntimeException(ex);
        }
    }

    public static String getDataBaseType() {
        return dataBaseType;
    }

    public static void setDataBaseType(String aDataBaseType) {
        NeqSimDataBase.setDataBaseType(aDataBaseType, null);
    }

    public static void setDataBaseType(String aDataBaseType, String connectionString) {
        dataBaseType = aDataBaseType;
        if (connectionString != null) {
            NeqSimDataBase.connectionString = connectionString;
        }
        try {
            if (dataBaseType.equals("MSAccess")) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (dataBaseType.equals("H2")) {
                Class.forName("org.h2.Driver");
            } else if (dataBaseType.equals("H2RT")) {
                Class.forName("org.h2.Driver");
            } else if (dataBaseType.equals("MSAccessUCanAccess")) {
                Class.forName("net.ucanaccess.jdbc.UcanaccessDriver");
            } else if (dataBaseType.equals("mySQL")) {
                Class.forName("com.mysql.cj.jdbc.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (dataBaseType.equals("mySQLNTNU")) {
                Class.forName("com.mysql.cj.jdbc.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (dataBaseType.equals("Derby")) {
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (dataBaseType.equals("oracle")) {
                Class.forName("oracle.jdbc.driver.OracleDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (dataBaseType.equals("oracleST")) {
                Class.forName("oracle.jdbc.driver.OracleDriver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            }
        }
        catch (Exception ex) {
            logger.error("error loading database driver.. " + ex.toString());
            throw new RuntimeException(ex);
        }
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public static void setUsername(String aUsername) {
        username = aUsername;
    }

    public static void setPassword(String aPassword) {
        password = aPassword;
    }

    public static String getConnectionString() {
        return connectionString;
    }

    public static void setConnectionString(String aConnectionString) {
        connectionString = aConnectionString;
    }

    public static void main(String[] args) {
        NeqSimDataBase database = new NeqSimDataBase();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ResultSet dataSet = database.getResultSet("SELECT * FROM comp WHERE NAME='methane'");){
                dataSet.next();
                logger.info("dataset " + dataSet.getString("molarmass"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            logger.error("failed " + ex.toString());
            throw new RuntimeException(ex);
        }
    }

    public static String[] getComponentNames() {
        NeqSimDataBase database = new NeqSimDataBase();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ResultSet dataSet = database.getResultSet("SELECT name FROM comp ORDER BY ID");){
                ArrayList<String> names = new ArrayList<String>();
                while (dataSet.next()) {
                    names.add(dataSet.getString("name"));
                }
                return names.toArray(new String[0]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean hasComponent(String compName) {
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = null;
        try {
            dataSet = database.getResultSet("select count(*) from comp WHERE NAME='" + compName + "'");
            dataSet.next();
            int size = dataSet.getInt(1);
            return size != 0;
            {
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (database.getStatement() != null) {
                    database.getStatement().close();
                }
                if (database.getConnection() != null) {
                    database.getConnection().close();
                }
            }
            catch (Exception ex) {
                logger.error("error closing database.....", (Throwable)ex);
            }
        }
    }
}

