/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.phaseEnvelopeOps.multicomponentEnvelopeOps;

import Jama.Matrix;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.phaseEnvelopeOps.multicomponentEnvelopeOps.pTphaseEnvelope;

public class CricondenBarFlash
extends pTphaseEnvelope {
    private static final long serialVersionUID = 1000L;
    int neq = 0;
    double beta = 0.0;
    Matrix u;
    Matrix uold;
    Matrix uini;
    SystemInterface system;
    int numberOfComponents;
    int crico = 0;
    double DT = 1.0E-6;
    double funcT;
    double dfuncdT;
    double funcP;
    double dfuncdP;
    double f;
    double f1;
    double dfdt;
    double dfdt1;
    double DDQ;
    double T;
    double P;
    double Tini;
    double Pini;
    double T1;
    int ITER;
    int ITERX;
    int ITERT;
    int ITERP;

    public CricondenBarFlash() {
    }

    public CricondenBarFlash(SystemInterface system, String name, double phaseFraction, double[] cricondenBar, double[] cricondenBarX, double[] cricondenBarY) {
        this.system = system;
        this.numberOfComponents = system.getPhase(0).getNumberOfComponents();
        this.u = new Matrix(this.numberOfComponents, 1);
        this.cricondenBar = cricondenBar;
        this.cricondenBarX = cricondenBarX;
        this.cricondenBarY = cricondenBarY;
        this.beta = phaseFraction;
    }

    @Override
    public void run() {
        this.T = this.cricondenBar[0];
        this.P = this.cricondenBar[1];
        this.Tini = this.T;
        this.Pini = this.P;
        this.bubblePointFirst = false;
        this.system.setBeta(this.beta);
        this.system.setPhaseType(0, "oil");
        this.system.setPhaseType(1, "gas");
        int ii = 0;
        while (ii < this.numberOfComponents) {
            this.u.set(ii, 0, this.cricondenBarY[ii] / this.cricondenBarX[ii]);
            this.system.getPhase(0).getComponent(ii).setK(this.cricondenBarY[ii] / this.cricondenBarX[ii]);
            this.system.getPhase(0).getComponent(ii).setx(this.cricondenBarX[ii]);
            this.system.getPhase(1).getComponent(ii).setx(this.cricondenBarY[ii]);
            this.uini = this.u.copy();
            ++ii;
        }
        this.setNewX();
        int iter = 0;
        while (iter < 1000) {
            int iterT = 0;
            while (iterT <= 1000) {
                this.system.setTemperature(this.T);
                this.system.setPressure(this.P);
                this.init();
                this.funcT();
                this.f = this.funcT;
                this.dfdt = this.dfuncdT;
                this.T1 = this.T + this.DT;
                this.system.setTemperature(this.T1);
                this.system.setPressure(this.P);
                this.init();
                this.funcT();
                this.f1 = this.funcT;
                this.dfdt1 = this.dfuncdT;
                this.DDQ = (this.dfdt1 - this.dfdt) / this.DT;
                if (iterT == 1000) {
                    this.ITERT = -1;
                    break;
                }
                if (Math.abs(this.dfdt / this.DDQ) < 1.0E-7) {
                    this.ITERT = iterT;
                    break;
                }
                if (Math.abs(this.dfdt) < 1.0E-7) {
                    this.ITERT = iterT;
                    break;
                }
                this.T -= this.dfdt / this.DDQ;
                ++iterT;
            }
            int iterP = 0;
            while (iterP <= 10000) {
                this.system.setTemperature(this.T);
                this.system.setPressure(this.P);
                this.uold = this.u.copy();
                this.init();
                this.setNewK();
                double sumK = 0.0;
                int i = 0;
                while (i < this.numberOfComponents) {
                    sumK += (this.uold.get(i, 0) - this.u.get(i, 0)) * (this.uold.get(i, 0) - this.u.get(i, 0));
                    ++i;
                }
                this.setNewX();
                this.init();
                this.funcP();
                if (Math.abs(this.funcP / this.dfuncdP) < 1.0E-7 || sumK <= 1.0E-10) {
                    this.ITERP = iterP;
                    break;
                }
                this.P -= this.funcP / this.dfuncdP;
                if (this.P <= 0.0) {
                    this.P += this.funcP / this.dfuncdP;
                    this.u = this.u.copy();
                    this.setNewX();
                    break;
                }
                if (iterP == 10000) {
                    this.ITERP = -1;
                    break;
                }
                ++iterP;
            }
            this.system.setTemperature(this.T);
            this.system.setPressure(this.P);
            this.init();
            this.funcT();
            this.funcP();
            if (Math.abs(this.dfuncdT) <= 1.0E-7 && Math.abs(this.funcP) <= 1.0E-7 && Math.abs(this.dfuncdP) >= 1.0E-7) {
                this.cricondenBar[0] = this.T;
                this.cricondenBar[1] = this.P;
                break;
            }
            if (Math.abs(this.dfuncdT) <= 1.0E-7 && Math.abs(this.funcP) <= 1.0E-7 && Math.abs(this.dfuncdP) <= 1.0E-7) {
                this.T = -1.0;
                this.P = -1.0;
                this.cricondenBar[0] = this.T;
                this.cricondenBar[1] = this.P;
                break;
            }
            ++iter;
        }
    }

    public void setNewK() {
        int j = 0;
        while (j < this.numberOfComponents) {
            double kap = this.system.getPhase(0).getComponent(j).getFugacityCoefficient() / this.system.getPhase(1).getComponent(j).getFugacityCoefficient();
            this.system.getPhase(0).getComponents()[j].setK(kap);
            this.u.set(j, 0, kap);
            ++j;
        }
    }

    public void setNewX() {
        double sumx = 0.0;
        double sumy = 0.0;
        double[] xx = new double[this.numberOfComponents];
        double[] yy = new double[this.numberOfComponents];
        int j = 0;
        while (j < this.numberOfComponents) {
            xx[j] = this.system.getPhase(0).getComponents()[j].getz() / (1.0 - this.system.getBeta() + this.system.getBeta() * this.u.get(j, 0));
            yy[j] = this.system.getPhase(1).getComponents()[j].getz() * this.u.get(j, 0) / (1.0 - this.system.getBeta() + this.system.getBeta() * this.u.get(j, 0));
            xx[j] = this.system.getPhase(0).getComponents()[j].getz() / (1.0 - this.system.getBeta() + this.system.getBeta() * this.system.getPhase(0).getComponents()[j].getK());
            yy[j] = this.system.getPhase(1).getComponents()[j].getz() * this.system.getPhase(0).getComponents()[j].getK() / (1.0 - this.system.getBeta() + this.system.getBeta() * this.system.getPhase(0).getComponents()[j].getK());
            sumx += xx[j];
            sumy += yy[j];
            ++j;
        }
        j = 0;
        while (j < this.numberOfComponents) {
            this.system.getPhase(0).getComponents()[j].setx(xx[j] / sumx);
            this.system.getPhase(1).getComponents()[j].setx(yy[j] / sumy);
            xx[j] = this.system.getPhase(0).getComponents()[j].getx();
            yy[j] = this.system.getPhase(1).getComponents()[j].getx();
            ++j;
        }
    }

    public void init() {
        this.system.init(3);
    }

    public void funcT() {
        this.funcT = -1.0;
        this.dfuncdT = 0.0;
        int j = 0;
        while (j < this.numberOfComponents) {
            double xxf = this.system.getPhase(0).getComponent(j).getx();
            double yyf = this.system.getPhase(1).getComponent(j).getx();
            double fugl = this.system.getPhase(0).getComponent(j).getLogFugacityCoefficient();
            double fugv = this.system.getPhase(1).getComponent(j).getLogFugacityCoefficient();
            double fugTl = this.system.getPhase(0).getComponent(j).getdfugdt();
            double fugTv = this.system.getPhase(1).getComponent(j).getdfugdt();
            this.funcT = this.funcT + xxf + xxf * (Math.log(yyf) - Math.log(xxf) + fugv - fugl);
            this.dfuncdT += xxf * (fugTv - fugTl);
            ++j;
        }
    }

    public void funcP() {
        this.funcP = -1.0;
        this.dfuncdP = 0.0;
        int j = 0;
        while (j < this.numberOfComponents) {
            double xx = this.system.getPhase(0).getComponent(j).getx();
            double yy = this.system.getPhase(1).getComponent(j).getx();
            double fugl = this.system.getPhase(0).getComponents()[j].getLogFugacityCoefficient();
            double fugv = this.system.getPhase(1).getComponents()[j].getLogFugacityCoefficient();
            double fugPl = this.system.getPhase(0).getComponents()[j].getdfugdp();
            double fugPv = this.system.getPhase(1).getComponents()[j].getdfugdp();
            this.funcP = this.funcP + xx + xx * (Math.log(yy) - Math.log(xx) + fugv - fugl);
            this.dfuncdP += xx * (fugPv - fugPl);
            ++j;
        }
    }
}

