/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps.saturationOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.saturationOps.constantDutyTemperatureFlash;

public class dewPointTemperatureFlashDer
extends constantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;

    public dewPointTemperatureFlashDer() {
    }

    public dewPointTemperatureFlashDer(SystemInterface system) {
        super(system);
    }

    @Override
    public void run() {
        if (this.system.getPhase(0).getNumberOfComponents() == 1 && this.system.getPressure() > this.system.getPhase(0).getComponent(0).getPC()) {
            this.setSuperCritical(true);
        }
        this.system.init(0);
        this.system.setBeta(0, 0.999999999999999);
        this.system.setBeta(1, 1.0E-15);
        this.system.init(1);
        this.system.setNumberOfPhases(2);
        double oldTemp = 0.0;
        if (this.system.isChemicalSystem()) {
            this.system.getChemicalReactionOperations().solveChemEq(0);
            this.system.getChemicalReactionOperations().solveChemEq(1);
        }
        int i = 0;
        while (i < this.system.getPhases()[1].getNumberOfComponents()) {
            this.system.getPhases()[0].getComponents()[i].setx(this.system.getPhases()[0].getComponents()[i].getz());
            if (this.system.getPhases()[0].getComponents()[i].getIonicCharge() != 0.0) {
                this.system.getPhases()[0].getComponents()[i].setx(1.0E-40);
            } else if (this.system.getPhases()[1].getComponents()[i].getName().equals("water")) {
                this.system.getPhases()[1].getComponents()[i].setx(1.0);
            } else if (this.system.getPhases()[1].hasComponent("water")) {
                this.system.getPhases()[1].getComponents()[i].setx(1.0E-10);
            } else {
                this.system.getPhases()[1].getComponents()[i].setx(1.0 / this.system.getPhases()[0].getComponents()[i].getK() * this.system.getPhases()[1].getComponents()[i].getz());
            }
            ++i;
        }
        double xtotal = 0.0;
        int i2 = 0;
        while (i2 < this.system.getPhases()[1].getNumberOfComponents()) {
            xtotal += this.system.getPhases()[1].getComponents()[i2].getx();
            ++i2;
        }
        i2 = 0;
        while (i2 < this.system.getPhases()[1].getNumberOfComponents()) {
            this.system.getPhases()[1].getComponents()[i2].setx(this.system.getPhases()[1].getComponents()[i2].getx() / xtotal);
            ++i2;
        }
        int iterations = 0;
        int maxNumberOfIterations = 1000;
        double ktot = 0.0;
        do {
            oldTemp = this.system.getTemperature();
            ++iterations;
            this.system.init(2);
            xtotal = 0.0;
            double dfdT = 0.0;
            int i3 = 0;
            while (i3 < this.system.getPhases()[1].getNumberOfComponents()) {
                xtotal += 1.0 / this.system.getPhases()[0].getComponents()[i3].getK() * this.system.getPhases()[1].getComponents()[i3].getz();
                dfdT -= 1.0 / this.system.getPhases()[0].getComponents()[i3].getK() * this.system.getPhases()[1].getComponents()[i3].getz() * (this.system.getPhases()[1].getComponents()[i3].getdfugdt() - this.system.getPhases()[0].getComponents()[i3].getdfugdt());
                ++i3;
            }
            double f = xtotal - 1.0;
            if (iterations < 5) {
                this.system.setTemperature(this.system.getTemperature() + (double)iterations / ((double)iterations + 100.0) * (xtotal * this.system.getTemperature() - this.system.getTemperature()));
            } else {
                this.system.setTemperature(this.system.getTemperature() - (double)iterations / (10.0 + (double)iterations) * f / dfdT);
            }
            this.system.init(1);
            ktot = 0.0;
            int i4 = 0;
            while (i4 < this.system.getPhases()[1].getNumberOfComponents()) {
                if (this.system.getPhase(0).getComponent(i4).getIonicCharge() != 0.0) {
                    this.system.getPhases()[0].getComponents()[i4].setK(1.0E-40);
                } else {
                    this.system.getPhases()[0].getComponents()[i4].setK(Math.exp(this.system.getPhases()[1].getComponents()[i4].getLogFugacityCoefficient() - this.system.getPhases()[0].getComponents()[i4].getLogFugacityCoefficient()));
                }
                this.system.getPhases()[1].getComponents()[i4].setK(this.system.getPhases()[0].getComponents()[i4].getK());
                this.system.getPhases()[1].getComponents()[i4].setx(1.0 / this.system.getPhases()[0].getComponents()[i4].getK() * this.system.getPhases()[1].getComponents()[i4].getz());
                ktot += Math.abs(this.system.getPhases()[1].getComponents()[i4].getK() - 1.0);
                ++i4;
            }
            xtotal = 0.0;
            i4 = 0;
            while (i4 < this.system.getPhases()[1].getNumberOfComponents()) {
                xtotal += this.system.getPhases()[1].getComponents()[i4].getx();
                ++i4;
            }
            i4 = 0;
            while (i4 < this.system.getPhases()[1].getNumberOfComponents()) {
                this.system.getPhases()[1].getComponents()[i4].setx(this.system.getPhases()[1].getComponents()[i4].getx() / xtotal);
                ++i4;
            }
        } while (Math.abs(xtotal - 1.0) > 1.0E-6 || Math.abs(oldTemp - this.system.getTemperature()) / oldTemp > 1.0E-4 || iterations < 3 && iterations < maxNumberOfIterations);
        if (Math.abs(xtotal - 1.0) > 1.0E-5 || ktot < 0.001 && this.system.getPhase(0).getNumberOfComponents() > 1) {
            this.setSuperCritical(true);
        }
        if (ktot < 0.001) {
            if (this.system.getTemperature() < 90.0) {
                this.setSuperCritical(true);
            } else {
                this.setSuperCritical(false);
            }
        }
    }

    @Override
    public void printToFile(String name) {
    }
}

