/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps.saturationOps;

import Jama.Matrix;
import java.io.Serializable;
import neqsim.thermo.system.SystemInterface;
import org.jfree.chart.JFreeChart;

public class cricondenBarTemp1
implements Serializable {
    private static final long serialVersionUID = 1000L;
    int neq = 0;
    int iter = 0;
    int ic02p = -100;
    int ic03p = -100;
    int testcrit = 0;
    int npCrit = 0;
    double beta = 0.0;
    double ds = 0.0;
    double dTmax = 1.0;
    double dPmax = 1.0;
    double avscp = 0.1;
    double TC1 = 0.0;
    double TC2 = 0.0;
    double PC1 = 0.0;
    double PC2 = 0.0;
    Matrix Jac;
    Matrix fvec;
    Matrix u;
    Matrix uold;
    Matrix Xgij;
    SystemInterface system;
    int numberOfComponents;
    int speceq = 0;
    Matrix a = new Matrix(4, 4);
    Matrix s = new Matrix(1, 4);
    Matrix xg;
    Matrix dx;
    Matrix xcoef;

    public cricondenBarTemp1() {
    }

    public cricondenBarTemp1(SystemInterface system) {
        this.system = system;
        this.neq = this.numberOfComponents = system.getPhase(0).getNumberOfComponents();
        this.Jac = new Matrix(this.neq + 2, this.neq + 2);
        this.fvec = new Matrix(this.neq + 2, 1);
        this.u = new Matrix(this.neq + 2, 1);
        this.Xgij = new Matrix(this.neq + 2, 4);
        this.setu();
        this.uold = this.u.copy();
    }

    public void setfvec() {
        double xtot = 0.0;
        double dQdT = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            xtot += this.system.getPhase(1).getComponent(i).getx();
            dQdT -= this.system.getPhase(1).getComponent(i).getx() * (this.system.getPhase(0).getComponent(i).getdfugdt() - this.system.getPhase(1).getComponent(i).getdfugdt());
            this.fvec.set(i, 0, Math.log(this.system.getPhase(0).getComponents()[i].getFugacityCoefficient() * this.system.getPhase(0).getComponents()[i].getz() * this.system.getPressure()) - Math.log(this.system.getPhases()[1].getComponents()[i].getFugacityCoefficient() * this.system.getPhases()[1].getComponents()[i].getx() * this.system.getPressure()));
            ++i;
        }
        this.fvec.set(this.numberOfComponents, 0, 1.0 - xtot);
        this.fvec.set(this.numberOfComponents + 1, 0, dQdT);
    }

    public void setJac() {
        this.Jac.timesEquals(0.0);
        double dij = 0.0;
        double tempJ = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            int j = 0;
            while (j < this.numberOfComponents) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = 1.0 / this.system.getBeta() * (dij / this.system.getPhases()[0].getComponents()[i].getx() - 1.0 + this.system.getPhases()[0].getComponents()[i].getdfugdx(j)) + 1.0 / (1.0 - this.system.getBeta()) * (dij / this.system.getPhases()[1].getComponents()[i].getx() - 1.0 + this.system.getPhases()[1].getComponents()[i].getdfugdx(j));
                this.Jac.set(i, j, tempJ);
                ++j;
            }
            ++i;
        }
    }

    public void setu() {
        int i = 0;
        while (i < this.numberOfComponents) {
            this.u.set(i, 0, this.system.getBeta() * this.system.getPhases()[0].getComponents()[i].getx());
            ++i;
        }
    }

    public void init() {
        double temp = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            temp += this.u.get(i, 0);
            ++i;
        }
        this.system.setBeta(temp);
        i = 0;
        while (i < this.numberOfComponents) {
            this.system.getPhases()[0].getComponents()[i].setx(this.u.get(i, 0) / this.system.getBeta());
            this.system.getPhases()[1].getComponents()[i].setx((this.system.getPhases()[0].getComponents()[i].getz() - this.u.get(i, 0)) / (1.0 - this.system.getBeta()));
            this.system.getPhases()[0].getComponents()[i].setK(this.system.getPhases()[0].getComponents()[i].getx() / this.system.getPhases()[1].getComponents()[i].getx());
            this.system.getPhases()[1].getComponents()[i].setK(this.system.getPhases()[0].getComponents()[i].getK());
            ++i;
        }
        this.system.init(3);
    }

    public double solve() {
        ++this.iter;
        this.init();
        this.setfvec();
        this.setJac();
        this.dx = this.Jac.solve(this.fvec);
        this.dx.print(10, 10);
        this.u.minusEquals(this.dx);
        return this.dx.norm2() / this.u.norm2();
    }

    public void run() {
        this.solve();
    }

    public JFreeChart getJFreeChart(String name) {
        return null;
    }

    public double[] get(String name) {
        return new double[0];
    }

    public void printToFile(String name) {
    }

    public void displayResult() {
    }

    public double[][] getPoints(int i) {
        return null;
    }

    public String[][] getResultTable() {
        return null;
    }

    public SystemInterface getThermoSystem() {
        return this.system;
    }
}

