/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps.saturationOps;

import java.sql.ResultSet;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.thermodynamicOperations.flashOps.saturationOps.constantDutyTemperatureFlash;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class addIonToScaleSaturation
extends constantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(addIonToScaleSaturation.class);
    String saltName = "";
    String scaleSaltName = "";
    String nameOfIonToBeAdded = "";
    int phaseNumber = 1;
    String[][] resultTable = null;

    public addIonToScaleSaturation() {
    }

    public addIonToScaleSaturation(SystemInterface system, int phaseNumber, String scaleSaltName, String nameOfIonToBeAdded) {
        super(system);
        this.phaseNumber = phaseNumber;
        this.scaleSaltName = scaleSaltName;
        this.nameOfIonToBeAdded = nameOfIonToBeAdded;
        logger.info("ok ");
    }

    @Override
    public void run() {
        ThermodynamicOperations ops = new ThermodynamicOperations(this.system);
        double ksp = 0.0;
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM compsalt");
        this.resultTable = new String[10][3];
        double stoc1 = 1.0E-20;
        double stoc2 = 1.0E-20;
        String saltName = "";
        String name1 = "";
        String name2 = "";
        this.system.init(1);
        int numb = 0;
        int i = 0;
        while (i < 10) {
            int j = 0;
            while (j < 3) {
                this.resultTable[i][j] = "";
                ++j;
            }
            ++i;
        }
        this.resultTable[0][0] = "Salt";
        this.resultTable[0][1] = "relative solubility";
        this.resultTable[0][2] = "";
        double numberOfMolesMEG = 0.0;
        if (this.system.getPhase(this.phaseNumber).hasComponent("MEG")) {
            numberOfMolesMEG = this.system.getPhase(this.phaseNumber).getComponent("MEG").getNumberOfMolesInPhase();
            this.system.addComponent("MEG", -numberOfMolesMEG * 0.9999, this.phaseNumber);
            this.system.addComponent("water", numberOfMolesMEG, this.phaseNumber);
            this.system.init(1);
            this.system.getChemicalReactionOperations().solveChemEq(this.phaseNumber, 1);
        }
        try {
            while (dataSet.next()) {
                saltName = dataSet.getString("SaltName").trim();
                name1 = dataSet.getString("ion1").trim();
                name2 = dataSet.getString("ion2").trim();
                ++this.iterations;
                stoc1 = Double.parseDouble(dataSet.getString("stoc1"));
                stoc2 = Double.parseDouble(dataSet.getString("stoc2"));
                double temperatureC = this.system.getPhase(this.phaseNumber).getTemperature();
                ksp = Math.exp(Double.parseDouble(dataSet.getString("Ksp-water")) / temperatureC + Double.parseDouble(dataSet.getString("Ksp-water2")) + Math.log(temperatureC) * Double.parseDouble(dataSet.getString("Ksp-water3")) + temperatureC * Double.parseDouble(dataSet.getString("Ksp-water4")) + Double.parseDouble(dataSet.getString("Ksp-water5")) / (temperatureC * temperatureC));
                if (saltName.equals("NaCl")) {
                    ksp = -814.18 + 7.4685 * temperatureC - 0.023262 * temperatureC * temperatureC + 3.0536E-5 * Math.pow(temperatureC, 3.0) - 1.4573E-8 * Math.pow(temperatureC, 4.0);
                }
                if (!this.system.getPhase(this.phaseNumber).hasComponent(name1) || !this.system.getPhase(this.phaseNumber).hasComponent(name2)) continue;
                ++numb;
                logger.info("reaction added: " + name1 + " " + name2);
                logger.info("theoretic Ksp = " + ksp);
                double oldScalePotentialFactor = 1.0;
                double error = 1.0;
                int iterations = 0;
                do {
                    ++iterations;
                    logger.info("theoretic lnKsp = " + Math.log(ksp));
                    int compNumb1 = this.system.getPhase(this.phaseNumber).getComponent(name1).getComponentNumber();
                    int compNumb2 = this.system.getPhase(this.phaseNumber).getComponent(name2).getComponentNumber();
                    int waterompNumb = this.system.getPhase(this.phaseNumber).getComponent("water").getComponentNumber();
                    double x1 = this.system.getPhase(this.phaseNumber).getComponent(name1).getx() / (this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getx() * this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getMolarMass());
                    double x2 = this.system.getPhase(this.phaseNumber).getComponent(name2).getx() / (this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getx() * this.system.getPhase(this.phaseNumber).getComponent(waterompNumb).getMolarMass());
                    double kspReac = Math.pow(this.system.getPhase(this.phaseNumber).getActivityCoefficient(compNumb1, waterompNumb) * x1, stoc1) * Math.pow(x2 * this.system.getPhase(this.phaseNumber).getActivityCoefficient(compNumb2, waterompNumb), stoc2);
                    double stocKsp = Math.pow(x1, stoc1) * Math.pow(x2, stoc2);
                    logger.info("calc Ksp " + kspReac);
                    logger.info("stoc Ksp " + stocKsp);
                    logger.info("activity " + kspReac / stocKsp);
                    logger.info("mol/kg " + x1);
                    double scalePotentialFactor = kspReac / ksp;
                    error = (scalePotentialFactor - oldScalePotentialFactor) / scalePotentialFactor * 100.0;
                    oldScalePotentialFactor = scalePotentialFactor;
                    logger.info("Scale potential factor " + scalePotentialFactor);
                    this.resultTable[numb][0] = String.valueOf(name1) + " " + name2;
                    this.resultTable[numb][1] = Double.toString(scalePotentialFactor);
                    this.resultTable[numb][2] = "";
                    if (!saltName.equals(this.scaleSaltName)) continue;
                    logger.info("error " + error);
                    logger.info("pH : " + this.system.getPhase(this.phaseNumber).getpH());
                    this.system.addComponent(this.nameOfIonToBeAdded, (1.0 - scalePotentialFactor) / 100000.0, this.phaseNumber);
                    ops.TPflash();
                    logger.info("x1 " + this.system.getPhase(this.phaseNumber).getComponent(name1).getx());
                    logger.info("x2 " + this.system.getPhase(this.phaseNumber).getComponent(name2).getx());
                } while (saltName.equals(this.scaleSaltName) && Math.abs(error) > 1.0E-6 && iterations < 200);
            }
        }
        catch (Exception ex) {
            logger.info("failed " + ex.toString());
        }
        if (this.system.getPhase(this.phaseNumber).hasComponent("MEG")) {
            this.system.addComponent("MEG", numberOfMolesMEG * 0.9999, this.phaseNumber);
            this.system.addComponent("water", -numberOfMolesMEG, this.phaseNumber);
            this.system.init(1);
            this.system.getChemicalReactionOperations().solveChemEq(this.phaseNumber, 1);
        }
    }

    @Override
    public void printToFile(String name) {
    }

    @Override
    public String[][] getResultTable() {
        logger.info("checking table...scale " + this.resultTable[0][0]);
        logger.info("checking table...scale " + this.resultTable[0][1]);
        logger.info("checking table...scale " + this.resultTable[0][2]);
        logger.info("checking table...scale " + this.resultTable[1][0]);
        logger.info("checking table...scale " + this.resultTable[1][1]);
        logger.info("checking table...scale " + this.resultTable[1][2]);
        return this.resultTable;
    }
}

