/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.thermodynamicOperations.flashOps.Flash;
import neqsim.thermodynamicOperations.flashOps.TPflash;
import org.jfree.chart.JFreeChart;

public class VSflash
extends Flash {
    private static final long serialVersionUID = 1000L;
    double Sspec = 0.0;
    double Vspec = 0.0;
    Flash tpFlash;

    public VSflash() {
    }

    public VSflash(SystemInterface system, double Vspec, double Sspec) {
        this.system = system;
        this.tpFlash = new TPflash(system);
        this.Sspec = Sspec;
        this.Vspec = Vspec;
    }

    public double calcdQdPP() {
        double dQdVV = (this.system.getVolume() - this.Vspec) / (8.3144621 * this.system.getTemperature()) + this.system.getPressure() * this.system.getdVdPtn() / (8.3144621 * this.system.getTemperature());
        return dQdVV;
    }

    public double calcdQdTT() {
        if (this.system.getNumberOfPhases() == 1) {
            return -this.system.getPhase(0).getCp() / this.system.getTemperature() / 8.3144621;
        }
        double dQdTT = 0.0;
        int i = 0;
        while (i < this.system.getNumberOfPhases()) {
            dQdTT -= this.system.getPhase(i).getCp() / this.system.getPhase(i).getTemperature();
            ++i;
        }
        return dQdTT / 8.3144621;
    }

    public double calcdQdT() {
        double dQdT = (this.Sspec - this.system.getEntropy()) / 8.3144621;
        return dQdT;
    }

    public double calcdQdP() {
        double dQdP = this.system.getPressure() * (this.system.getVolume() - this.Vspec) / (8.3144621 * this.system.getTemperature());
        return dQdP;
    }

    public double solveQ() {
        double oldPres = this.system.getPressure();
        double nyPres = this.system.getPressure();
        double nyTemp = this.system.getTemperature();
        double oldTemp = this.system.getTemperature();
        double iterations = 1.0;
        do {
            oldPres = nyPres;
            oldTemp = nyTemp;
            this.system.init(3);
            nyPres = oldPres - (iterations += 1.0) / (iterations + 10.0) * this.calcdQdP() / this.calcdQdPP();
            nyTemp = oldTemp - iterations / (iterations + 10.0) * this.calcdQdT() / this.calcdQdTT();
            this.system.setPressure(nyPres);
            this.system.setTemperature(nyTemp);
            this.tpFlash.run();
        } while (Math.abs((nyPres - oldPres) / nyPres) + Math.abs((nyTemp - oldTemp) / nyTemp) > 1.0E-9 && iterations < 1000.0);
        return nyPres;
    }

    @Override
    public void run() {
        this.tpFlash.run();
        this.solveQ();
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(328.15, 50.0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        testSystem.addComponent("methane", 31.0);
        testSystem.addComponent("ethane", 4.0);
        testSystem.init(0);
        try {
            testOps.TPflash();
            testSystem.display();
            double entropy = testSystem.getEntropy() * 1.2;
            double volume = testSystem.getVolume() * 1.1;
            testOps.VSflash(volume, entropy);
            testSystem.display();
        }
        catch (Exception ex) {
            logger.error(ex.toString());
        }
    }
}

