/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import Jama.Matrix;
import java.util.ArrayList;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.flashOps.TPflash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TPmultiflashWAX
extends TPflash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(TPmultiflashWAX.class);
    boolean multiPhaseTest = false;
    double[] dQdbeta;
    double[][] Qmatrix;
    double[] E;
    double Q = 0.0;
    boolean doStabilityAnalysis = true;

    public TPmultiflashWAX() {
    }

    public TPmultiflashWAX(SystemInterface system) {
        super(system);
    }

    public TPmultiflashWAX(SystemInterface system, boolean check) {
        super(system, check);
    }

    public void calcMultiPhaseBeta() {
    }

    public void setXY() {
        int k = 0;
        while (k < this.system.getNumberOfPhases()) {
            int i = 0;
            while (i < this.system.getPhase(0).getNumberOfComponents()) {
                if (this.system.getPhase(0).getComponent(i).getz() > 1.0E-100) {
                    this.system.getPhase(k).getComponents()[i].setx(this.system.getPhase(0).getComponents()[i].getz() / this.E[i] / this.system.getPhase(k).getComponents()[i].getFugacityCoefficient());
                }
                if (this.system.getPhase(0).getComponent(i).getIonicCharge() != 0.0 && !this.system.getPhase(k).getPhaseTypeName().equals("aqueous")) {
                    this.system.getPhase(k).getComponents()[i].setx(1.0E-50);
                }
                if (this.system.getPhase(0).getComponent(i).getIonicCharge() != 0.0 && this.system.getPhase(k).getPhaseTypeName().equals("aqueous")) {
                    this.system.getPhase(k).getComponents()[i].setx(this.system.getPhase(k).getComponents()[i].getNumberOfmoles() / this.system.getPhase(k).getNumberOfMolesInPhase());
                }
                if (this.system.hasPhaseType("wax")) {
                    this.system.getPhaseOfType("wax").getComponents()[i].setx(0.0);
                }
                ++i;
            }
            this.system.getPhase(k).normalize();
            ++k;
        }
    }

    public void calcE() {
        this.E = new double[this.system.getPhase(0).getNumberOfComponents()];
        int i = 0;
        while (i < this.system.getPhase(0).getNumberOfComponents()) {
            int k = 0;
            while (k < this.system.getNumberOfPhases()) {
                int n = i;
                this.E[n] = this.E[n] + this.system.getPhase(k).getBeta() / this.system.getPhase(k).getComponents()[i].getFugacityCoefficient();
                ++k;
            }
            ++i;
        }
    }

    public double calcQ() {
        this.Q = 0.0;
        double betaTotal = 0.0;
        this.dQdbeta = new double[this.system.getNumberOfPhases()];
        this.Qmatrix = new double[this.system.getNumberOfPhases()][this.system.getNumberOfPhases()];
        int k = 0;
        while (k < this.system.getNumberOfPhases()) {
            betaTotal += this.system.getPhase(k).getBeta();
            ++k;
        }
        this.Q = betaTotal;
        this.calcE();
        int i = 0;
        while (i < this.system.getPhase(0).getNumberOfComponents()) {
            this.Q -= Math.log(this.E[i]) * this.system.getPhase(0).getComponents()[i].getz();
            ++i;
        }
        k = 0;
        while (k < this.system.getNumberOfPhases()) {
            this.dQdbeta[k] = 1.0;
            int i2 = 0;
            while (i2 < this.system.getPhase(0).getNumberOfComponents()) {
                int n = k;
                this.dQdbeta[n] = this.dQdbeta[n] - this.system.getPhase(0).getComponents()[i2].getz() * 1.0 / this.E[i2] / this.system.getPhase(k).getComponents()[i2].getFugacityCoefficient();
                ++i2;
            }
            ++k;
        }
        i = 0;
        while (i < this.system.getNumberOfPhases()) {
            int j = 0;
            while (j < this.system.getNumberOfPhases()) {
                this.Qmatrix[i][j] = 0.0;
                int k2 = 0;
                while (k2 < this.system.getPhase(0).getNumberOfComponents()) {
                    double[] dArray = this.Qmatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.system.getPhase(0).getComponents()[k2].getz() / (this.E[k2] * this.E[k2] * this.system.getPhase(j).getComponents()[k2].getFugacityCoefficient() * this.system.getPhase(i).getComponents()[k2].getFugacityCoefficient());
                    ++k2;
                }
                if (i == j) {
                    double[] dArray = this.Qmatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + 1.0E-10;
                }
                ++j;
            }
            ++i;
        }
        return this.Q;
    }

    public void solveBeta(boolean updateFugacities) {
        double[] oldBeta = new double[this.system.getNumberOfPhases()];
        Matrix ans = new Matrix(this.system.getNumberOfPhases() - 1, 1);
        int iter = 1;
        do {
            ++iter;
            int k = 0;
            while (k < this.system.getNumberOfPhases()) {
                oldBeta[k] = this.system.getPhase(k).getBeta();
                ++k;
            }
            this.calcQ();
            Matrix betaMatrix = new Matrix(oldBeta, 1).transpose();
            Matrix dQM = new Matrix(this.dQdbeta, 1);
            Matrix dQdBM = new Matrix(this.Qmatrix);
            try {
                ans = dQdBM.solve(dQM.transpose());
            }
            catch (Exception exception) {
                // empty catch block
            }
            betaMatrix.minusEquals(ans.times((double)iter / ((double)iter + 2.0)));
            int k2 = 0;
            while (k2 < this.system.getNumberOfPhases()) {
                this.system.setBeta(k2, betaMatrix.get(k2, 0));
                if (betaMatrix.get(k2, 0) < 0.0) {
                    this.system.setBeta(k2, 1.0E-9);
                }
                if (betaMatrix.get(k2, 0) > 1.0) {
                    this.system.setBeta(k2, 0.999999999);
                }
                ++k2;
            }
            this.calcE();
            this.setXY();
            if (!updateFugacities) continue;
            this.system.init(1);
        } while (ans.norm2() > 1.0E-6 && iter < 20 || iter < 3);
    }

    @Override
    public void stabilityAnalysis() {
        int i;
        double[] logWi = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[][] Wi = new double[this.system.getPhase(0).getNumberOfComponents()][this.system.getPhase(0).getNumberOfComponents()];
        double[] sumw = new double[this.system.getPhase(0).getNumberOfComponents()];
        double err = 0.0;
        double[] oldlogw = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[] d = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[][] x = new double[this.system.getPhase(0).getNumberOfComponents()][this.system.getPhase(0).getNumberOfComponents()];
        this.tm = new double[this.system.getPhase(0).getNumberOfComponents()];
        ArrayList<SystemInterface> clonedSystem = new ArrayList<SystemInterface>(1);
        int waxphasenumber = 5;
        SystemInterface minimumGibbsEnergySystem = this.system.clone();
        int i2 = 0;
        while (i2 < this.system.getPhase(0).getNumberOfComponents()) {
            double numb = 0.0;
            if (this.system.getPhase(0).getComponent(i2).getx() < 1.0E-100) {
                clonedSystem.add(null);
            } else {
                clonedSystem.add(this.system.clone());
                int j = 0;
                while (j < this.system.getPhase(0).getNumberOfComponents()) {
                    double d2 = numb = i2 == j ? 1.0 : 1.0E-12;
                    if (this.system.getPhase(0).getComponent(j).getz() < 1.0E-100) {
                        numb = 0.0;
                    }
                    ((SystemInterface)clonedSystem.get(i2)).getPhase(waxphasenumber).getComponents()[j].setx(numb);
                    ++j;
                }
                if (this.system.getPhase(0).getComponent(i2).getIonicCharge() == 0.0) {
                    ((SystemInterface)clonedSystem.get(i2)).init(1);
                }
            }
            ++i2;
        }
        this.lowestGibbsEnergyPhase = 0;
        int k = 0;
        while (k < minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
            int i3 = 0;
            while (i3 < minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
                if (clonedSystem.get(k) != null) {
                    int n = k;
                    sumw[n] = sumw[n] + ((SystemInterface)clonedSystem.get(k)).getPhase(waxphasenumber).getComponents()[i3].getx();
                }
                ++i3;
            }
            ++k;
        }
        k = 0;
        while (k < minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
            int i4 = 0;
            while (i4 < minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
                if (clonedSystem.get(k) != null && this.system.getPhase(0).getComponent(k).getx() > 1.0E-100) {
                    ((SystemInterface)clonedSystem.get(k)).getPhase(waxphasenumber).getComponents()[i4].setx(((SystemInterface)clonedSystem.get(k)).getPhase(waxphasenumber).getComponents()[i4].getx() / sumw[0]);
                }
                ++i4;
            }
            if (this.system.getPhase(0).getComponent(k).getx() > 1.0E-100) {
                d[k] = Math.log(minimumGibbsEnergySystem.getPhases()[this.lowestGibbsEnergyPhase].getComponents()[k].getx()) + minimumGibbsEnergySystem.getPhases()[this.lowestGibbsEnergyPhase].getComponents()[k].getLogFugacityCoefficient();
            }
            ++k;
        }
        int j = 0;
        while (j < minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
            logWi[j] = this.system.getPhase(0).getComponent(j).getz() > 1.0E-100 ? 1.0 : -10000.0;
            ++j;
        }
        int hydrocarbonTestCompNumb = 0;
        int lightTestCompNumb = 0;
        double Mmax = 0.0;
        double Mmin = 1.0E10;
        int i5 = 0;
        while (i5 < minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
            if (minimumGibbsEnergySystem.getPhase(0).getComponent(i5).isHydrocarbon()) {
                if (minimumGibbsEnergySystem.getPhase(0).getComponent(i5).getMolarMass() > Mmax) {
                    Mmax = minimumGibbsEnergySystem.getPhase(0).getComponent(i5).getMolarMass();
                }
                if (minimumGibbsEnergySystem.getPhase(0).getComponent(i5).getMolarMass() < Mmin) {
                    Mmin = minimumGibbsEnergySystem.getPhase(0).getComponent(i5).getMolarMass();
                }
            }
            ++i5;
        }
        i5 = 0;
        while (i5 < minimumGibbsEnergySystem.getPhase(0).getNumberOfComponents()) {
            if (minimumGibbsEnergySystem.getPhase(0).getComponent(i5).isHydrocarbon() && Math.abs(minimumGibbsEnergySystem.getPhase(0).getComponent(i5).getMolarMass() - Mmax) < 1.0E-5) {
                hydrocarbonTestCompNumb = i5;
            }
            if (minimumGibbsEnergySystem.getPhase(0).getComponent(i5).isHydrocarbon() && Math.abs(minimumGibbsEnergySystem.getPhase(0).getComponent(i5).getMolarMass() - Mmin) < 1.0E-5) {
                lightTestCompNumb = i5;
            }
            ++i5;
        }
        int j2 = this.system.getPhase(0).getNumberOfComponents() - 1;
        while (j2 >= 0) {
            if (!(minimumGibbsEnergySystem.getPhase(0).getComponent(j2).getx() < 1.0E-100 || minimumGibbsEnergySystem.getPhase(0).getComponent(j2).getIonicCharge() != 0.0 || minimumGibbsEnergySystem.getPhase(0).getComponent(j2).isHydrocarbon() && j2 != hydrocarbonTestCompNumb && j2 != lightTestCompNumb)) {
                int iter = 0;
                do {
                    ++iter;
                    err = 0.0;
                    ((SystemInterface)clonedSystem.get(j2)).init(1, waxphasenumber);
                    i = 0;
                    while (i < this.system.getPhase(0).getNumberOfComponents()) {
                        oldlogw[i] = logWi[i];
                        if (!Double.isInfinite(Math.log(((SystemInterface)clonedSystem.get(j2)).getPhase(waxphasenumber).getComponents()[i].getLogFugacityCoefficient())) && this.system.getPhase(0).getComponent(i).getx() > 1.0E-100) {
                            logWi[i] = d[i] - Math.log(((SystemInterface)clonedSystem.get(j2)).getPhase(waxphasenumber).getComponents()[i].getFugacityCoefficient());
                            if (((SystemInterface)clonedSystem.get(j2)).getPhase(1).getComponents()[i].getIonicCharge() != 0.0) {
                                logWi[i] = -1000.0;
                            }
                        }
                        err += Math.abs(logWi[i] - oldlogw[i]);
                        Wi[j2][i] = Math.exp(logWi[i]);
                        ++i;
                    }
                    sumw[j2] = 0.0;
                    i = 0;
                    while (i < this.system.getPhase(0).getNumberOfComponents()) {
                        int n = j2;
                        sumw[n] = sumw[n] + Math.exp(logWi[i]);
                        ++i;
                    }
                    i = 0;
                    while (i < this.system.getPhase(0).getNumberOfComponents()) {
                        ((SystemInterface)clonedSystem.get(j2)).getPhase(waxphasenumber).getComponents()[i].setx(Math.exp(logWi[i]) / sumw[j2]);
                        ++i;
                    }
                } while (Math.abs(err) > 1.0E-9 && iter < 100);
                this.tm[j2] = 1.0;
                i = 0;
                while (i < this.system.getPhase(1).getNumberOfComponents()) {
                    int n = j2;
                    this.tm[n] = this.tm[n] - Math.exp(logWi[i]);
                    x[j2][i] = ((SystemInterface)clonedSystem.get(j2)).getPhase(waxphasenumber).getComponents()[i].getx();
                    ++i;
                }
                if (iter >= 99) {
                    logger.info("iter > maxiter multiphase stability ");
                    logger.info("error " + Math.abs(err));
                    logger.info("tm: " + this.tm[j2]);
                }
                if (this.tm[j2] < -1.0E-8) break;
            }
            --j2;
        }
        int unstabcomp = 0;
        int k2 = this.system.getPhase(0).getNumberOfComponents() - 1;
        while (k2 >= 0) {
            if (this.tm[k2] < -1.0E-8 && !Double.isNaN(this.tm[k2])) {
                this.system.addPhase();
                this.system.setPhaseIndex(this.system.getNumberOfPhases() - 1, waxphasenumber);
                unstabcomp = k2;
                i = 0;
                while (i < this.system.getPhase(1).getNumberOfComponents()) {
                    this.system.getPhase(this.system.getNumberOfPhases() - 1).getComponents()[i].setx(x[k2][i]);
                    ++i;
                }
                this.multiPhaseTest = true;
                this.system.setBeta(this.system.getNumberOfPhases() - 1, this.system.getPhase(0).getComponent(unstabcomp).getz());
                this.system.init(1);
                this.system.normalizeBeta();
                return;
            }
            --k2;
        }
        this.system.normalizeBeta();
        logger.info("STABILITY ANALYSIS: ");
        logger.info("tm1: " + this.tm[0] + "  tm2: " + this.tm[1]);
    }

    @Override
    public void run() {
        if (this.doStabilityAnalysis) {
            this.stabilityAnalysis();
        }
        this.doStabilityAnalysis = true;
        int iterations = 0;
        if (this.multiPhaseTest && !this.system.isChemicalSystem()) {
            double oldBeta = 1.0;
            double diff = 1.0;
            do {
                oldBeta = this.system.getBeta(this.system.getNumberOfPhases() - 1);
                this.solveBeta(true);
            } while ((diff = Math.abs((this.system.getBeta(this.system.getNumberOfPhases() - 1) - oldBeta) / oldBeta)) > 1.0E-5 && ++iterations < 50);
            if (iterations >= 49) {
                logger.error("error in multiphase flash..did not solve in 50 iterations");
            }
        }
        double chemdev = 0.0;
        if (this.system.isChemicalSystem()) {
            int phase = 0;
            while (phase < this.system.getNumberOfPhases()) {
                chemdev = 0.0;
                double[] xchem = new double[this.system.getPhase(phase).getNumberOfComponents()];
                this.i = 0;
                while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                    xchem[this.i] = this.system.getPhase(phase).getComponents()[this.i].getx();
                    ++this.i;
                }
                this.system.init(1);
                this.system.getChemicalReactionOperations().solveChemEq(phase, 1);
                this.i = 0;
                while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                    chemdev += Math.abs(xchem[this.i] - this.system.getPhase(phase).getComponents()[this.i].getx());
                    ++this.i;
                }
                logger.info("chemdev: " + chemdev);
                ++phase;
            }
        }
        boolean hasRemovedPhase = false;
        int i = 0;
        while (i < this.system.getNumberOfPhases()) {
            if (this.system.getBeta(i) < 1.1E-9) {
                this.system.removePhaseKeepTotalComposition(i);
                this.doStabilityAnalysis = false;
                hasRemovedPhase = true;
            }
            ++i;
        }
        if (!hasRemovedPhase) {
            i = 0;
            while (i < this.system.getNumberOfPhases() - 1) {
                if (Math.abs(this.system.getPhase(i).getDensity() - this.system.getPhase(i + 1).getDensity()) < 1.1E-4) {
                    this.system.removePhaseKeepTotalComposition(i + 1);
                    this.doStabilityAnalysis = false;
                    hasRemovedPhase = true;
                }
                ++i;
            }
        }
        if (hasRemovedPhase) {
            this.run();
        }
        this.system.orderByDensity();
    }
}

