/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.thermodynamicOperations.flashOps.Flash;
import org.jfree.chart.JFreeChart;

public class PSflashSingleComp
extends Flash {
    private static final long serialVersionUID = 1000L;
    double Sspec = 0.0;

    public PSflashSingleComp() {
    }

    public PSflashSingleComp(SystemInterface system, double Sspec, int type) {
        this.system = system;
        this.Sspec = Sspec;
    }

    @Override
    public void run() {
        double initTemp;
        ThermodynamicOperations bubOps;
        block6: {
            bubOps = new ThermodynamicOperations(this.system);
            initTemp = this.system.getTemperature();
            if (this.system.getPressure() < this.system.getPhase(0).getComponent(0).getPC()) {
                try {
                    bubOps.TPflash();
                    if (this.system.getPhase(0).getPhaseTypeName().equals("gas")) {
                        bubOps.dewPointTemperatureFlash();
                        break block6;
                    }
                    bubOps.bubblePointTemperatureFlash();
                }
                catch (Exception ex) {
                    this.system.setTemperature(initTemp);
                    logger.error("error", (Throwable)ex);
                }
            } else {
                bubOps.PSflash2(this.Sspec);
                return;
            }
        }
        this.system.init(3);
        double gasEntropy = this.system.getPhase(0).getEntropy() / this.system.getPhase(0).getNumberOfMolesInPhase() * this.system.getTotalNumberOfMoles();
        double liqEntropy = this.system.getPhase(1).getEntropy() / this.system.getPhase(1).getNumberOfMolesInPhase() * this.system.getTotalNumberOfMoles();
        if (this.Sspec < liqEntropy || this.Sspec > gasEntropy) {
            this.system.setTemperature(initTemp);
            bubOps.PSflash2(this.Sspec);
            return;
        }
        double beta = (this.Sspec - liqEntropy) / (gasEntropy - liqEntropy);
        this.system.setBeta(beta);
        this.system.init(3);
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }
}

