/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations.flashOps;

import Jama.Matrix;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.BaseOperation;
import neqsim.thermodynamicOperations.flashOps.SolidFlash;
import neqsim.thermodynamicOperations.flashOps.sysNewtonRhapsonTPflash;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class Flash
extends BaseOperation {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Flash.class);
    SystemInterface system;
    SystemInterface minimumGibbsEnergySystem;
    public double[] minGibsPhaseLogZ;
    public double[] minGibsLogFugCoef;
    int i = 0;
    int j = 0;
    int iterations = 0;
    int maxNumberOfIterations = 100;
    double gibbsEnergy = 0.0;
    double gibbsEnergyOld = 0.0;
    double Kold = 0.0;
    double deviation = 0.0;
    double g0 = 0.0;
    double g1 = 0.0;
    double[] lnOldOldOldK;
    double[] lnOldOldK;
    double[] lnK;
    double[] lnOldK;
    double[] oldoldDeltalnK;
    double[] oldDeltalnK;
    double[] deltalnK;
    double[] tm;
    int lowestGibbsEnergyPhase = 0;
    sysNewtonRhapsonTPflash secondOrderSolver;
    protected boolean solidCheck = false;
    protected boolean stabilityCheck = false;
    boolean findLowesGibsPhaseIsChecked = false;

    public int findLowestGibbsEnergyPhase() {
        if (!this.findLowesGibsPhaseIsChecked) {
            this.minimumGibbsEnergySystem = this.system.clone();
            this.minimumGibbsEnergySystem.init(0);
            this.minimumGibbsEnergySystem.init(1);
            this.lowestGibbsEnergyPhase = this.minimumGibbsEnergySystem.getPhase(0).getGibbsEnergy() * (1.0 - Math.signum(this.minimumGibbsEnergySystem.getPhase(0).getGibbsEnergy()) * 1.0E-8) < this.minimumGibbsEnergySystem.getPhase(1).getGibbsEnergy() ? 0 : 1;
            this.findLowesGibsPhaseIsChecked = true;
        }
        return this.lowestGibbsEnergyPhase;
    }

    public void stabilityAnalysis() throws IsNaNException, TooManyIterationsException {
        int i;
        double[] logWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] deltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldDeltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldoldDeltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[][] Wi = new double[2][this.system.getPhases()[0].getNumberOfComponents()];
        double[] sumw = new double[2];
        boolean secondOrderStabilityAnalysis = false;
        double[] oldlogw = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldoldlogw = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldoldoldlogw = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] d = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[][] x = new double[2][this.system.getPhases()[0].getNumberOfComponents()];
        double[] error = new double[2];
        this.tm = new double[this.system.getPhase(0).getNumberOfComponents()];
        double[] alpha = null;
        Matrix f = new Matrix(this.system.getPhases()[0].getNumberOfComponents(), 1);
        Matrix df = null;
        int maxiterations = 50;
        double fNorm = 1.0E10;
        double fNormOld = 0.0;
        int i2 = 0;
        while (i2 < this.system.getPhases()[0].getNumberOfComponents()) {
            d[i2] = this.minGibsPhaseLogZ[i2] + this.minGibsLogFugCoef[i2];
            ++i2;
        }
        SystemInterface clonedSystem = this.minimumGibbsEnergySystem;
        clonedSystem.setTotalNumberOfMoles(1.0);
        sumw[1] = 0.0;
        sumw[0] = 0.0;
        int i3 = 0;
        while (i3 < clonedSystem.getPhase(0).getNumberOfComponents()) {
            sumw[1] = sumw[1] + clonedSystem.getPhase(0).getComponent(i3).getz() / clonedSystem.getPhase(0).getComponent(i3).getK();
            sumw[0] = sumw[0] + clonedSystem.getPhase(0).getComponent(i3).getK() * clonedSystem.getPhase(0).getComponent(i3).getz();
            ++i3;
        }
        int start = 0;
        int end = 1;
        int mult = 1;
        if (this.lowestGibbsEnergyPhase == 0) {
            start = end;
            end = 0;
            mult = -1;
        }
        int i4 = 0;
        while (i4 < clonedSystem.getPhase(0).getNumberOfComponents()) {
            clonedSystem.getPhase(1).getComponent(i4).setx(clonedSystem.getPhase(0).getComponent(i4).getz() / clonedSystem.getPhase(0).getComponent(i4).getK() / sumw[1]);
            clonedSystem.getPhase(0).getComponent(i4).setx(clonedSystem.getPhase(0).getComponent(i4).getK() * clonedSystem.getPhase(0).getComponent(i4).getz() / sumw[0]);
            ++i4;
        }
        int j = start;
        while (j >= end) {
            int i5 = 0;
            while (i5 < clonedSystem.getPhases()[0].getNumberOfComponents()) {
                Wi[j][i5] = clonedSystem.getPhase(j).getComponent(i5).getx();
                logWi[i5] = Math.log(Wi[j][i5]);
                ++i5;
            }
            this.iterations = 0;
            fNorm = 1.0E10;
            do {
                ++this.iterations;
                error[j] = 0.0;
                i5 = 0;
                while (i5 < clonedSystem.getPhases()[0].getNumberOfComponents()) {
                    oldoldoldlogw[i5] = oldoldlogw[i5];
                    oldoldlogw[i5] = oldlogw[i5];
                    oldlogw[i5] = logWi[i5];
                    oldoldDeltalogWi[i5] = oldoldlogw[i5] - oldoldoldlogw[i5];
                    oldDeltalogWi[i5] = oldlogw[i5] - oldoldlogw[i5];
                    ++i5;
                }
                if (this.iterations <= maxiterations - 10 || !this.system.isImplementedCompositionDeriativesofFugacity()) {
                    clonedSystem.init(1, j);
                    fNormOld = fNorm;
                    i5 = 0;
                    while (i5 < clonedSystem.getPhases()[0].getNumberOfComponents()) {
                        f.set(i5, 0, Math.sqrt(Wi[j][i5]) * (Math.log(Wi[j][i5]) + clonedSystem.getPhase(j).getComponent(i5).getLogFugacityCoefficient() - d[i5]));
                        ++i5;
                    }
                    fNorm = f.norm2();
                    if (fNorm > fNormOld && this.iterations > 3 || (this.iterations + 1) % 7 != 0) break;
                    if (this.iterations % 7 == 0 && fNorm < fNormOld && !secondOrderStabilityAnalysis) {
                        double vec1 = 0.0;
                        double vec2 = 0.0;
                        double prod1 = 0.0;
                        double prod2 = 0.0;
                        this.i = 0;
                        while (this.i < clonedSystem.getPhases()[0].getNumberOfComponents()) {
                            vec1 = oldDeltalogWi[this.i] * oldoldDeltalogWi[this.i];
                            vec2 = Math.pow(oldoldDeltalogWi[this.i], 2.0);
                            prod1 += vec1 * vec2;
                            prod2 += vec2 * vec2;
                            ++this.i;
                        }
                        double lambda = prod1 / prod2;
                        this.i = 0;
                        while (this.i < clonedSystem.getPhases()[0].getNumberOfComponents()) {
                            int n = this.i;
                            logWi[n] = logWi[n] + lambda / (1.0 - lambda) * deltalogWi[this.i];
                            int n2 = j;
                            error[n2] = error[n2] + Math.abs((logWi[this.i] - oldlogw[this.i]) / oldlogw[this.i]);
                            Wi[j][this.i] = Math.exp(logWi[this.i]);
                            ++this.i;
                        }
                    } else {
                        i5 = 0;
                        while (i5 < clonedSystem.getPhases()[0].getNumberOfComponents()) {
                            logWi[i5] = d[i5] - clonedSystem.getPhase(j).getComponent(i5).getLogFugacityCoefficient();
                            int n = j;
                            error[n] = error[n] + Math.abs((logWi[i5] - oldlogw[i5]) / oldlogw[i5]);
                            Wi[j][i5] = Math.exp(logWi[i5]);
                            ++i5;
                        }
                    }
                } else {
                    if (!secondOrderStabilityAnalysis) {
                        alpha = new double[this.system.getPhases()[0].getNumberOfComponents()];
                        df = new Matrix(this.system.getPhases()[0].getNumberOfComponents(), this.system.getPhases()[0].getNumberOfComponents());
                        secondOrderStabilityAnalysis = true;
                    }
                    clonedSystem.init(3, j);
                    i5 = 0;
                    while (i5 < clonedSystem.getPhases()[0].getNumberOfComponents()) {
                        alpha[i5] = 2.0 * Math.sqrt(Wi[j][i5]);
                        ++i5;
                    }
                    i5 = 0;
                    while (i5 < clonedSystem.getPhases()[0].getNumberOfComponents()) {
                        f.set(i5, 0, Math.sqrt(Wi[j][i5]) * (Math.log(Wi[j][i5]) + clonedSystem.getPhase(j).getComponent(i5).getLogFugacityCoefficient() - d[i5]));
                        int k = 0;
                        while (k < clonedSystem.getPhases()[0].getNumberOfComponents()) {
                            double kronDelt = i5 == k ? 1.5 : 0.0;
                            df.set(i5, k, kronDelt + Math.sqrt(Wi[j][k] * Wi[j][i5]) * clonedSystem.getPhase(j).getComponent(i5).getdfugdn(k));
                            ++k;
                        }
                        ++i5;
                    }
                    Matrix dx = df.solve(f).times(-1.0);
                    i = 0;
                    while (i < clonedSystem.getPhases()[0].getNumberOfComponents()) {
                        Wi[j][i] = Math.pow((alpha[i] + dx.get(i, 0)) / 2.0, 2.0);
                        logWi[i] = Math.log(Wi[j][i]);
                        int n = j;
                        error[n] = error[n] + Math.abs((logWi[i] - oldlogw[i]) / oldlogw[i]);
                        ++i;
                    }
                }
                sumw[j] = 0.0;
                i5 = 0;
                while (i5 < clonedSystem.getPhases()[0].getNumberOfComponents()) {
                    int n = j;
                    sumw[n] = sumw[n] + Wi[j][i5];
                    ++i5;
                }
                i5 = 0;
                while (i5 < clonedSystem.getPhases()[0].getNumberOfComponents()) {
                    deltalogWi[i5] = logWi[i5] - oldlogw[i5];
                    clonedSystem.getPhase(j).getComponent(i5).setx(Wi[j][i5] / sumw[j]);
                    ++i5;
                }
            } while (f.norm1() > 1.0E-6 && this.iterations < maxiterations || this.iterations % 7 == 0 || this.iterations < 3);
            if (this.iterations >= maxiterations) {
                logger.error("err staability check " + error[j]);
            }
            this.tm[j] = 1.0;
            i5 = 0;
            while (i5 < clonedSystem.getPhases()[0].getNumberOfComponents()) {
                int n = j;
                this.tm[n] = this.tm[n] - Wi[j][i5];
                x[j][i5] = clonedSystem.getPhase(j).getComponent(i5).getx();
                ++i5;
            }
            if (this.tm[j] < -1.0E-4 && error[j] < 1.0E-6) break;
            this.tm[j] = 1.0;
            j += mult;
        }
        double diffx = 0.0;
        i = 0;
        while (i < clonedSystem.getPhase(0).getNumberOfComponents()) {
            diffx += Math.abs(clonedSystem.getPhase(0).getComponent(i).getx() - clonedSystem.getPhase(1).getComponent(i).getx());
            ++i;
        }
        if (diffx < 1.0E-10) {
            this.tm[0] = 0.0;
            this.tm[1] = 0.0;
        }
        if ((this.tm[0] < -1.0E-4 || this.tm[1] < -1.0E-4) && !Double.isNaN(this.tm[0]) && !Double.isNaN(this.tm[1])) {
            i = 0;
            while (i < clonedSystem.getPhases()[0].getNumberOfComponents()) {
                if (!(this.system.getPhases()[1].getComponents()[i].getx() < 1.0E-100)) {
                    if (this.tm[0] < -1.0E-4) {
                        this.system.getPhases()[1].getComponents()[i].setK(Wi[0][i] / sumw[0] / (Wi[1][i] / sumw[1]));
                        this.system.getPhases()[0].getComponents()[i].setK(Wi[0][i] / sumw[0] / (Wi[1][i] / sumw[1]));
                    } else if (this.tm[1] < -1.0E-4) {
                        this.system.getPhases()[1].getComponents()[i].setK(Wi[0][i] / sumw[0] / (Wi[1][i] / sumw[1]));
                        this.system.getPhases()[0].getComponents()[i].setK(Wi[0][i] / sumw[0] / (Wi[1][i] / sumw[1]));
                    } else {
                        logger.info("error in stability anlysis");
                        this.system.init(0);
                    }
                    if (Double.isNaN(this.tm[this.j])) {
                        this.tm[this.j] = 0.0;
                    }
                }
                ++i;
            }
        }
    }

    public boolean stabilityCheck() {
        boolean stable = false;
        this.lowestGibbsEnergyPhase = this.findLowestGibbsEnergyPhase();
        if (this.system.getPhase(this.lowestGibbsEnergyPhase).getNumberOfComponents() > 1) {
            try {
                this.stabilityAnalysis();
            }
            catch (Exception ex) {
                logger.error("error ", (Throwable)ex);
            }
        }
        if (!(this.tm[0] < -1.0E-4) && !(this.tm[1] < -1.0E-4) || this.system.getPhase(0).getNumberOfComponents() == 1) {
            stable = true;
            this.system.init(0);
            this.system.setNumberOfPhases(1);
            if (this.lowestGibbsEnergyPhase == 0) {
                this.system.setPhaseType(0, 1);
            } else {
                this.system.setPhaseType(0, 0);
            }
            this.system.init(1);
            if (this.solidCheck && !this.system.doMultiPhaseCheck()) {
                this.solidPhaseFlash();
            }
        } else {
            try {
                this.system.calcBeta();
            }
            catch (Exception ex) {
                logger.error("error", (Throwable)ex);
            }
            this.system.calc_x_y();
            this.system.init(1);
        }
        return stable;
    }

    @Override
    public void displayResult() {
        this.system.display();
    }

    public void solidPhaseFlash() {
        boolean solidPhase = false;
        double frac = 0.0;
        int solid = 0;
        double[] tempVar = new double[this.system.getPhases()[0].getNumberOfComponents()];
        if (!this.system.hasSolidPhase()) {
            this.system.setNumberOfPhases(this.system.getNumberOfPhases() + 1);
            this.system.setPhaseIndex(this.system.getNumberOfPhases() - 1, 3);
        }
        this.system.init(1);
        int k = 0;
        while (k < this.system.getPhase(0).getNumberOfComponents()) {
            if (this.system.getPhase(0).getComponent(k).doSolidCheck()) {
                tempVar[k] = this.system.getPhase(0).getComponents()[k].getz();
                int i = 0;
                while (i < this.system.getNumberOfPhases() - 1) {
                    int n = k;
                    tempVar[n] = tempVar[n] - this.system.getBeta(i) * this.system.getPhases()[3].getComponent(k).getFugacityCoefficient() / this.system.getPhase(i).getComponent(k).getFugacityCoefficient();
                    ++i;
                }
                if (tempVar[k] > 0.0 && tempVar[k] > frac) {
                    solidPhase = true;
                    solid = k;
                    frac = tempVar[k];
                    int p = 0;
                    while (p < this.system.getPhases()[0].getNumberOfComponents()) {
                        this.system.getPhases()[3].getComponents()[p].setx(1.0E-20);
                        ++p;
                    }
                    this.system.getPhases()[3].getComponents()[solid].setx(1.0);
                }
            }
            ++k;
        }
        if (solidPhase) {
            if (frac < this.system.getPhases()[0].getComponents()[solid].getz() + 1.0E10) {
                int i = 0;
                while (i < this.system.getNumberOfPhases() - 1) {
                    ++i;
                }
                this.system.init(1);
                this.system.setBeta(this.system.getNumberOfPhases() - 1, frac);
                this.system.initBeta();
                this.system.setBeta(this.system.getNumberOfPhases() - 1, this.system.getPhases()[3].getComponent(solid).getNumberOfmoles() / this.system.getNumberOfMoles());
                this.system.init(1);
                SolidFlash solflash = new SolidFlash(this.system);
                solflash.setSolidComponent(solid);
                solflash.run();
            }
        } else {
            this.system.setNumberOfPhases(this.system.getNumberOfPhases() - 1);
        }
    }

    @Override
    public void printToFile(String name) {
    }

    @Override
    public double[][] getPoints(int i) {
        return null;
    }

    @Override
    public String[][] getResultTable() {
        return null;
    }

    @Override
    public void addData(String name, double[][] data) {
    }
}

