/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicOperations;

import java.awt.BorderLayout;
import java.awt.Container;
import java.io.Serializable;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.api.ioc.CalculationResult;
import neqsim.thermo.component.ComponentHydrate;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.OperationInterface;
import neqsim.thermodynamicOperations.chemicalEquilibrium.ChemicalEquilibrium;
import neqsim.thermodynamicOperations.flashOps.CriticalPointFlash;
import neqsim.thermodynamicOperations.flashOps.PHflash;
import neqsim.thermodynamicOperations.flashOps.PHflashGERG2008;
import neqsim.thermodynamicOperations.flashOps.PHflashSingleComp;
import neqsim.thermodynamicOperations.flashOps.PHsolidFlash;
import neqsim.thermodynamicOperations.flashOps.PSFlash;
import neqsim.thermodynamicOperations.flashOps.PSFlashGERG2008;
import neqsim.thermodynamicOperations.flashOps.PSflashSingleComp;
import neqsim.thermodynamicOperations.flashOps.PUflash;
import neqsim.thermodynamicOperations.flashOps.PVrefluxflash;
import neqsim.thermodynamicOperations.flashOps.SaturateWithWater;
import neqsim.thermodynamicOperations.flashOps.SolidFlash1;
import neqsim.thermodynamicOperations.flashOps.TPflash;
import neqsim.thermodynamicOperations.flashOps.TPgradientFlash;
import neqsim.thermodynamicOperations.flashOps.TSFlash;
import neqsim.thermodynamicOperations.flashOps.TVflash;
import neqsim.thermodynamicOperations.flashOps.VHflashQfunc;
import neqsim.thermodynamicOperations.flashOps.VSflash;
import neqsim.thermodynamicOperations.flashOps.VUflashQfunc;
import neqsim.thermodynamicOperations.flashOps.calcIonicComposition;
import neqsim.thermodynamicOperations.flashOps.dTPflash;
import neqsim.thermodynamicOperations.flashOps.saturationOps.HCdewPointPressureFlash;
import neqsim.thermodynamicOperations.flashOps.saturationOps.HydrateEquilibriumLine;
import neqsim.thermodynamicOperations.flashOps.saturationOps.HydrateFormationPressureFlash;
import neqsim.thermodynamicOperations.flashOps.saturationOps.HydrateFormationTemperatureFlash;
import neqsim.thermodynamicOperations.flashOps.saturationOps.HydrateInhibitorConcentrationFlash;
import neqsim.thermodynamicOperations.flashOps.saturationOps.HydrateInhibitorwtFlash;
import neqsim.thermodynamicOperations.flashOps.saturationOps.SolidComplexTemperatureCalc;
import neqsim.thermodynamicOperations.flashOps.saturationOps.WATcalc;
import neqsim.thermodynamicOperations.flashOps.saturationOps.WaterDewPointEquilibriumLine;
import neqsim.thermodynamicOperations.flashOps.saturationOps.addIonToScaleSaturation;
import neqsim.thermodynamicOperations.flashOps.saturationOps.bubblePointPressureFlash;
import neqsim.thermodynamicOperations.flashOps.saturationOps.bubblePointPressureFlashDer;
import neqsim.thermodynamicOperations.flashOps.saturationOps.bubblePointTemperatureNoDer;
import neqsim.thermodynamicOperations.flashOps.saturationOps.calcSaltSatauration;
import neqsim.thermodynamicOperations.flashOps.saturationOps.checkScalePotential;
import neqsim.thermodynamicOperations.flashOps.saturationOps.constantDutyPressureFlash;
import neqsim.thermodynamicOperations.flashOps.saturationOps.constantDutyTemperatureFlash;
import neqsim.thermodynamicOperations.flashOps.saturationOps.cricondebarFlash;
import neqsim.thermodynamicOperations.flashOps.saturationOps.dewPointPressureFlash;
import neqsim.thermodynamicOperations.flashOps.saturationOps.dewPointTemperatureFlash;
import neqsim.thermodynamicOperations.flashOps.saturationOps.dewPointTemperatureFlashDer;
import neqsim.thermodynamicOperations.flashOps.saturationOps.freezingPointTemperatureFlash;
import neqsim.thermodynamicOperations.flashOps.saturationOps.waterDewPointTemperatureFlash;
import neqsim.thermodynamicOperations.flashOps.saturationOps.waterDewPointTemperatureMultiphaseFlash;
import neqsim.thermodynamicOperations.phaseEnvelopeOps.multicomponentEnvelopeOps.CricondenBarFlash;
import neqsim.thermodynamicOperations.phaseEnvelopeOps.multicomponentEnvelopeOps.CricondenThermFlash;
import neqsim.thermodynamicOperations.phaseEnvelopeOps.multicomponentEnvelopeOps.HPTphaseEnvelope;
import neqsim.thermodynamicOperations.phaseEnvelopeOps.multicomponentEnvelopeOps.pTphaseEnvelope;
import neqsim.thermodynamicOperations.phaseEnvelopeOps.reactiveCurves.pLoadingCurve2;
import neqsim.thermodynamicOperations.propertyGenerator.OLGApropertyTableGeneratorWaterStudents;
import neqsim.thermodynamicOperations.propertyGenerator.OLGApropertyTableGeneratorWaterStudentsPH;
import neqsim.util.exception.InvalidInputException;
import neqsim.util.exception.IsNaNException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.chart.JFreeChart;

public class ThermodynamicOperations
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1000L;
    private Thread thermoOperationThread = new Thread();
    private OperationInterface operation = null;
    SystemInterface system = null;
    boolean writeFile = false;
    String fileName = null;
    private boolean runAsThread = false;
    protected String[][] resultTable = null;
    static Logger logger = LogManager.getLogger(ThermodynamicOperations.class);

    public ThermodynamicOperations() {
    }

    public ThermodynamicOperations(SystemInterface system) {
        this.system = system;
    }

    public void setSystem(SystemInterface system) {
        this.system = system;
    }

    public void TPSolidflash() {
        this.operation = new SolidFlash1(this.system);
        this.getOperation().run();
    }

    public void TPVflash(double volumeSpec, String unit) {
        unit = "m3";
        this.TPflash();
        double startVolume = this.system.getVolume(unit);
        this.system.setTotalNumberOfMoles(this.system.getNumberOfMoles() * volumeSpec / startVolume);
        this.system.init(3);
    }

    public void TPflash() {
        double flowRate = this.system.getTotalNumberOfMoles();
        double minimumFlowRate = 1.0E-50;
        if (flowRate < 0.001) {
            this.system.setTotalNumberOfMoles(1.0);
            this.system.init(1);
        }
        this.operation = new TPflash(this.system, this.system.doSolidPhaseCheck());
        if (!this.isRunAsThread()) {
            this.getOperation().run();
        } else {
            this.run();
        }
        if (flowRate < 0.001) {
            if (flowRate < minimumFlowRate) {
                this.system.setTotalNumberOfMoles(minimumFlowRate);
            } else {
                this.system.setTotalNumberOfMoles(flowRate);
            }
            this.system.init(2);
        }
    }

    public void TPflash(boolean checkSolids) {
        this.operation = new TPflash(this.system, checkSolids);
        this.getOperation().run();
    }

    public SystemInterface TPgradientFlash(double height, double temperature) {
        this.operation = new TPgradientFlash(this.system, height, temperature);
        this.getOperation().run();
        return this.operation.getThermoSystem();
    }

    public void dTPflash(String[] comps) {
        this.operation = new dTPflash(this.system, comps);
        this.getOperation().run();
    }

    public void saturateWithWater() {
        this.operation = new SaturateWithWater(this.system);
        this.getOperation().run();
    }

    public void chemicalEquilibrium() {
        if (this.system.isChemicalSystem()) {
            this.operation = new ChemicalEquilibrium(this.system);
            this.getOperation().run();
        }
    }

    public void PHflash(double Hspec, int type) {
        this.operation = this.system.getPhase(0).getNumberOfComponents() == 1 ? new PHflashSingleComp(this.system, Hspec, type) : new PHflash(this.system, Hspec, type);
        this.getOperation().run();
    }

    public void PHflash(double Hspec, String enthalpyUnit) {
        double conversionFactor = 1.0;
        switch (enthalpyUnit) {
            case "J": {
                conversionFactor = 1.0;
                break;
            }
            case "J/mol": {
                conversionFactor = 1.0 / this.system.getTotalNumberOfMoles();
                break;
            }
            case "J/kg": {
                conversionFactor = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass();
                break;
            }
            case "kJ/kg": {
                conversionFactor = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass() / 1000.0;
                break;
            }
        }
        this.PHflash(Hspec / conversionFactor);
    }

    public void PHflash(double Hspec) {
        this.PHflash(Hspec, 0);
    }

    public void PHflashGERG2008(double Hspec) {
        this.operation = new PHflashGERG2008(this.system, Hspec);
        this.getOperation().run();
    }

    public void PUflash(double Uspec) {
        this.operation = new PUflash(this.system, Uspec);
        this.getOperation().run();
    }

    public void PUflash(double Pspec, double Uspec, String unitPressure, String unitEnergy) {
        this.system.setPressure(Pspec, unitPressure);
        this.PUflash(Uspec, unitEnergy);
    }

    public void PUflash(double Uspec, String unitEnergy) {
        double conversionFactorEntr = 1.0;
        switch (unitEnergy) {
            case "J": {
                conversionFactorEntr = 1.0;
                break;
            }
            case "J/mol": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles();
                break;
            }
            case "J/kg": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass();
                break;
            }
            case "kJ/kg": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass() / 1000.0;
                break;
            }
        }
        this.PUflash(Uspec / conversionFactorEntr);
    }

    public void PHflash2(double Hspec, int type) {
        this.operation = new PHflash(this.system, Hspec, type);
        this.getOperation().run();
    }

    public void criticalPointFlash() {
        this.operation = new CriticalPointFlash(this.system);
        this.getOperation().run();
    }

    public void PHsolidFlash(double Hspec) {
        this.operation = new PHsolidFlash(this.system, Hspec);
        this.getOperation().run();
    }

    public void PSflash(double Sspec) {
        this.operation = this.system.getPhase(0).getNumberOfComponents() == 1 ? new PSflashSingleComp(this.system, Sspec, 0) : new PSFlash(this.system, Sspec, 0);
        this.getOperation().run();
    }

    /*
     * Exception decompiling
     */
    public void PSflash(double Sspec, String unit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl38 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl38 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void TSflash(double Sspec) {
        this.operation = new TSFlash(this.system, Sspec);
        this.getOperation().run();
    }

    public void TSflash(double Sspec, String unit) {
        double conversionFactor = 1.0;
        switch (unit) {
            case "J/K": {
                conversionFactor = 1.0;
                break;
            }
            case "J/molK": {
                conversionFactor = 1.0 / this.system.getTotalNumberOfMoles();
                break;
            }
            case "J/kgK": {
                conversionFactor = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass();
                break;
            }
            case "kJ/kgK": {
                conversionFactor = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass() / 1000.0;
                break;
            }
        }
        this.TSflash(Sspec / conversionFactor);
    }

    public void PSflashGERG2008(double Sspec) {
        this.operation = new PSFlashGERG2008(this.system, Sspec);
        this.getOperation().run();
    }

    public void PSflash2(double Sspec) {
        this.operation = new PSFlash(this.system, Sspec, 0);
        this.getOperation().run();
    }

    public void VSflash(double volume, double entropy, String unitVol, String unitEntropy) {
        double conversionFactorV = 1.0;
        double conversionFactorEntr = 1.0;
        switch (unitVol) {
            case "m3": {
                conversionFactorV = 100000.0;
                break;
            }
        }
        switch (unitEntropy) {
            case "J/K": {
                conversionFactorEntr = 1.0;
                break;
            }
            case "J/molK": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles();
                break;
            }
            case "J/kgK": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass();
                break;
            }
            case "kJ/kgK": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass() / 1000.0;
                break;
            }
        }
        this.VSflash(volume * conversionFactorV, entropy / conversionFactorEntr);
    }

    public void VSflash(double volume, double entropy) {
        this.operation = new VSflash(this.system, volume, entropy);
        this.getOperation().run();
    }

    public void TVflash(double Vspec, String unit) {
        double conversionFactor = 1.0;
        switch (unit) {
            case "m3": {
                conversionFactor = 100000.0;
                break;
            }
        }
        this.TVflash(Vspec * conversionFactor);
    }

    public void TVflash(double Vspec) {
        this.operation = new TVflash(this.system, Vspec);
        this.getOperation().run();
    }

    public void PVrefluxFlash(double refluxspec, int refluxPhase) {
        this.operation = new PVrefluxflash(this.system, refluxspec, refluxPhase);
        this.getOperation().run();
    }

    public void VHflash(double Vspec, double Hspec) {
        this.operation = new VHflashQfunc(this.system, Vspec, Hspec);
        this.getOperation().run();
    }

    public void VHflash(double volume, double enthalpy, String unitVol, String unitEnthalpy) {
        double conversionFactorV = 1.0;
        double conversionFactorEntr = 1.0;
        switch (unitVol) {
            case "m3": {
                conversionFactorV = 100000.0;
                break;
            }
        }
        switch (unitEnthalpy) {
            case "J/K": {
                conversionFactorEntr = 1.0;
                break;
            }
            case "J/mol": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles();
                break;
            }
            case "J/kg": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass();
                break;
            }
            case "kJ/kg": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass() / 1000.0;
                break;
            }
        }
        this.VHflash(volume * conversionFactorV, enthalpy / conversionFactorEntr);
    }

    public void VUflash(double volume, double energy, String unitVol, String unitEnergy) {
        double conversionFactorV = 1.0;
        double conversionFactorEntr = 1.0;
        switch (unitVol) {
            case "m3": {
                conversionFactorV = 100000.0;
                break;
            }
        }
        switch (unitEnergy) {
            case "J/K": {
                conversionFactorEntr = 1.0;
                break;
            }
            case "J/mol": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles();
                break;
            }
            case "J/kg": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass();
                break;
            }
            case "kJ/kg": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass() / 1000.0;
                break;
            }
        }
        this.VUflash(volume * conversionFactorV, energy / conversionFactorEntr);
    }

    public void VUflash(double Vspec, double Uspec) {
        this.operation = new VUflashQfunc(this.system, Vspec, Uspec);
        this.getOperation().run();
    }

    public void bubblePointTemperatureFlash() throws Exception {
        bubblePointTemperatureNoDer operation = new bubblePointTemperatureNoDer(this.system);
        operation.run();
        if (Double.isNaN(this.system.getTemperature()) || operation.isSuperCritical()) {
            throw new IsNaNException(this.getClass().getSimpleName(), "bubblePointTemperatureFlash", "Could not find solution - possible no bubble point exists");
        }
    }

    public void freezingPointTemperatureFlash() throws Exception {
        this.operation = new freezingPointTemperatureFlash(this.system);
        this.getOperation().run();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this.getClass().getSimpleName(), "freezingPointTemperatureFlash", "Could not find solution - possible no freezing point exists");
        }
    }

    public void freezingPointTemperatureFlash(String phaseName) throws Exception {
        this.operation = new freezingPointTemperatureFlash(this.system);
        this.getOperation().run();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this.getClass().getSimpleName(), "freezingPointTemperatureFlash", "Could not find solution - possible no freezing point exists");
        }
    }

    public void waterDewPointTemperatureFlash() throws Exception {
        this.operation = new waterDewPointTemperatureFlash(this.system);
        this.getOperation().run();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this.getClass().getSimpleName(), "waterDewPointTemperatureFlash", "Could not find solution - possible no dew point exists");
        }
    }

    public void waterDewPointTemperatureMultiphaseFlash() throws Exception {
        this.operation = new waterDewPointTemperatureMultiphaseFlash(this.system);
        this.getOperation().run();
    }

    public void waterPrecipitationTemperature() throws Exception {
        double lowTemperature = 0.0;
        this.dewPointTemperatureFlash();
        if (this.system.getTemperature() > lowTemperature) {
            lowTemperature = this.system.getTemperature();
        }
        this.system.setTemperature(lowTemperature);
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this.getClass().getSimpleName(), "waterPrecipitationTemperature", "Could not find solution - possible no dew point exists");
        }
    }

    public void calcSaltSaturation(String saltName) throws Exception {
        this.operation = new calcSaltSatauration(this.system, saltName);
        this.getOperation().run();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this.getClass().getSimpleName(), "calcSaltSaturation", "Could not find solution - possible no dew point exists");
        }
    }

    public void checkScalePotential(int phaseNumber) throws Exception {
        this.operation = new checkScalePotential(this.system, phaseNumber);
        this.getOperation().run();
        this.resultTable = this.getOperation().getResultTable();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this.getClass().getSimpleName(), "checkScalePotential", "Could not find solution - possible no dew point exists");
        }
    }

    public void addIonToScaleSaturation(int phaseNumber, String scaleSaltName, String nameOfIonToBeAdded) throws Exception {
        this.operation = new addIonToScaleSaturation(this.system, phaseNumber, scaleSaltName, nameOfIonToBeAdded);
        this.getOperation().run();
        this.resultTable = this.getOperation().getResultTable();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this.getClass().getSimpleName(), "addIonToScaleSaturation", "Could not find solution - possible no dew point exists");
        }
    }

    public void hydrateFormationPressure() throws Exception {
        this.operation = new HydrateFormationPressureFlash(this.system);
        this.getOperation().run();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this.getClass().getSimpleName(), "hydrateFormationPressure", "Could not find solution - possible no dew point exists");
        }
    }

    public void calcWAT() throws Exception {
        this.operation = new WATcalc(this.system);
        this.getOperation().run();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this.getClass().getSimpleName(), "calcWAT", "Could not find solution - possible no dew point exists");
        }
    }

    public void run() {
        this.setThermoOperationThread(new Thread(this.operation));
        this.getThermoOperationThread().start();
    }

    public boolean waitAndCheckForFinishedCalculation(int maxTime) {
        try {
            this.getThermoOperationThread().join(maxTime);
            this.getThermoOperationThread().interrupt();
        }
        catch (Exception ex) {
            logger.error("error", (Throwable)ex);
        }
        boolean didFinish = !this.getThermoOperationThread().isInterrupted();
        return didFinish;
    }

    public void waitToFinishCalculation() {
        try {
            this.getThermoOperationThread().join();
        }
        catch (Exception ex) {
            logger.error("error", (Throwable)ex);
        }
    }

    public void calcSolidComlexTemperature() throws Exception {
        this.operation = new SolidComplexTemperatureCalc(this.system);
        this.getOperation().run();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this.getClass().getSimpleName(), "calcSolidComlexTemperature", "error in WAT() - could not find solution - possible no dew point exists");
        }
    }

    public void calcSolidComlexTemperature(String comp1, String comp2) throws Exception {
        if (this.operation == null) {
            this.operation = new SolidComplexTemperatureCalc(this.system, comp1, comp2);
        }
        this.getOperation().run();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this.getClass().getSimpleName(), "calcSolidComlexTemperature", "error in WAT() - could not find solution - possible no dew point exists");
        }
    }

    public double[] calcImobilePhaseHydrateTemperature(double[] temperature, double[] pressure) {
        ThermodynamicOperations opsTemp;
        double[] hydTemps = new double[temperature.length];
        SystemInterface systemTemp = this.system.clone();
        int i = 0;
        while (i < temperature.length) {
            opsTemp = new ThermodynamicOperations(systemTemp);
            systemTemp.setTemperature(temperature[i]);
            systemTemp.setPressure(pressure[i]);
            opsTemp.TPflash();
            systemTemp.display();
            systemTemp = systemTemp.phaseToSystem(0);
            ++i;
        }
        opsTemp = new ThermodynamicOperations(systemTemp);
        systemTemp.setHydrateCheck(true);
        systemTemp.setMixingRule(9);
        try {
            opsTemp.hydrateFormationTemperature();
        }
        catch (Exception ex) {
            logger.error("error", (Throwable)ex);
        }
        systemTemp.display();
        return hydTemps;
    }

    public double calcTOLHydrateFormationTemperature() {
        this.TPflash();
        SystemInterface systemTemp = this.system.phaseToSystem(0);
        ThermodynamicOperations opsTemp = new ThermodynamicOperations(systemTemp);
        try {
            opsTemp.hydrateFormationTemperature();
        }
        catch (Exception ex) {
            logger.error("error", (Throwable)ex);
        }
        systemTemp.display();
        this.system.setTemperature(systemTemp.getTemperature());
        this.TPflash();
        return this.system.getTemperature();
    }

    public void hydrateInhibitorConcentration(String inhibitorName, double hydEqTemperature) throws Exception {
        this.operation = new HydrateInhibitorConcentrationFlash(this.system, inhibitorName, hydEqTemperature);
        this.operation.run();
    }

    public void hydrateInhibitorConcentrationSet(String inhibitorName, double wtfrac) throws Exception {
        this.operation = new HydrateInhibitorwtFlash(this.system, inhibitorName, wtfrac);
        this.operation.run();
    }

    public void hydrateFormationTemperature(double initialTemperatureGuess) throws Exception {
        this.system.setTemperature(initialTemperatureGuess);
        this.operation = new HydrateFormationTemperatureFlash(this.system);
        int i = 0;
        while (i < this.system.getPhase(4).getNumberOfComponents()) {
            ((ComponentHydrate)this.system.getPhase(4).getComponent(i)).getHydrateStructure();
            ++i;
        }
        if (!this.isRunAsThread()) {
            this.getOperation().run();
        } else {
            this.run();
        }
    }

    public void hydrateFormationTemperature() throws Exception {
        double factor = 1.0;
        if (this.system.getPhase(0).hasComponent("methanol")) {
            factor -= 2.0 * this.system.getPhase(0).getComponent("methanol").getz() / this.system.getPhase(0).getComponent("water").getz();
        }
        if (this.system.getPhase(0).hasComponent("MEG")) {
            factor -= 2.0 * this.system.getPhase(0).getComponent("MEG").getz() / this.system.getPhase(0).getComponent("water").getz();
        }
        if (factor < 2.0) {
            factor = 2.0;
        }
        this.system.setTemperature(273.0 + this.system.getPressure() / 100.0 * 20.0 * factor - 20.0);
        if (this.system.getTemperature() > 298.15) {
            this.system.setTemperature(298.0);
        }
        this.operation = new HydrateFormationTemperatureFlash(this.system);
        int i = 0;
        while (i < this.system.getPhase(4).getNumberOfComponents()) {
            ((ComponentHydrate)this.system.getPhase(4).getComponent(i)).getHydrateStructure();
            ++i;
        }
        if (!this.isRunAsThread()) {
            this.getOperation().run();
        } else {
            this.run();
        }
    }

    public void hydrateFormationTemperature(int structure) throws Exception {
        this.system.setTemperature(274.0);
        if (structure == 0) {
            this.system.setSolidPhaseCheck("water");
            this.system.setHydrateCheck(true);
            this.operation = new freezingPointTemperatureFlash(this.system);
        } else {
            this.operation = new HydrateFormationTemperatureFlash(this.system);
        }
        int i = 0;
        while (i < this.system.getPhase(4).getNumberOfComponents()) {
            ((ComponentHydrate)this.system.getPhases()[4].getComponent(i)).setHydrateStructure(structure - 1);
            ++i;
        }
        if (!this.isRunAsThread()) {
            this.getOperation().run();
        } else {
            this.run();
        }
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this.getClass().getSimpleName(), "hydrateFormationTemperature", "Could not find solution - possible no dew point exists");
        }
    }

    public void hydrateEquilibriumLine(double minimumPressure, double maximumPressure) throws Exception {
        this.operation = new HydrateEquilibriumLine(this.system, minimumPressure, maximumPressure);
        if (!this.isRunAsThread()) {
            this.getOperation().run();
        } else {
            this.run();
        }
    }

    public void calcCricoP(double[] cricondenBar, double[] cricondenBarX, double[] cricondenBarY) {
        double phasefraction = 0.9999999999;
        this.operation = new CricondenBarFlash(this.system, this.fileName, phasefraction, cricondenBar, cricondenBarX, cricondenBarY);
        this.getOperation().run();
    }

    public void calcCricoT(double[] cricondenTherm, double[] cricondenThermX, double[] cricondenThermY) {
        double phasefraction = 0.9999999999;
        this.operation = new CricondenThermFlash(this.system, this.fileName, phasefraction, cricondenTherm, cricondenThermX, cricondenThermY);
        this.getOperation().run();
    }

    public void waterDewPointLine(double minimumPressure, double maximumPressure) throws Exception {
        this.operation = new WaterDewPointEquilibriumLine(this.system, minimumPressure, maximumPressure);
        if (!this.isRunAsThread()) {
            this.getOperation().run();
        } else {
            this.run();
        }
    }

    public double calcCricondenBar() {
        this.system.init(0);
        this.operation = new cricondebarFlash(this.system);
        this.operation.run();
        return this.system.getPressure();
    }

    public void bubblePointPressureFlash() throws Exception {
        this.system.init(0);
        constantDutyPressureFlash operation = new constantDutyPressureFlash(this.system);
        this.system.setBeta(1, 0.9999999999);
        this.system.setBeta(0, 1.0E-10);
        operation.run();
        if (Double.isNaN(this.system.getPressure()) || operation.isSuperCritical()) {
            throw new IsNaNException(this.getClass().getSimpleName(), "bubblePointPressureFlash", "Could not find solution - possible no dew point exists");
        }
    }

    public void bubblePointPressureFlash(boolean derivatives) throws Exception {
        constantDutyPressureFlash operation = null;
        operation = derivatives ? new bubblePointPressureFlashDer(this.system) : new bubblePointPressureFlash(this.system);
        operation.run();
        if (Double.isNaN(this.system.getPressure()) || operation.isSuperCritical()) {
            throw new IsNaNException(this.getClass().getSimpleName(), "bubblePointPressureFlash", "Could not find solution - possible no dew point exists");
        }
    }

    public void constantPhaseFractionPressureFlash(double fraction) throws Exception {
        this.system.init(0);
        if (fraction < 1.0E-10) {
            fraction = 1.0E-10;
        }
        if (fraction > 0.9999999999) {
            fraction = 0.9999999999;
        }
        constantDutyPressureFlash operation = new constantDutyPressureFlash(this.system);
        this.system.setBeta(1, 1.0 - fraction);
        this.system.setBeta(0, fraction);
        operation.run();
        if (Double.isNaN(this.system.getPressure()) || operation.isSuperCritical()) {
            throw new IsNaNException(this.getClass().getSimpleName(), "constantPhaseFractionPressureFlash", "Could not find solution - possible no dew point exists");
        }
    }

    public void constantPhaseFractionTemperatureFlash(double fraction) throws Exception {
        this.system.init(0);
        if (fraction < 1.0E-10) {
            fraction = 1.0E-10;
        }
        if (fraction > 0.9999999999) {
            fraction = 0.9999999999;
        }
        constantDutyTemperatureFlash operation = new constantDutyTemperatureFlash(this.system);
        this.system.setBeta(1, fraction);
        this.system.setBeta(0, fraction);
        operation.run();
        if (Double.isNaN(this.system.getPressure()) || operation.isSuperCritical()) {
            throw new IsNaNException(this.getClass().getSimpleName(), "constantPhaseFractionTemperatureFlash", "Could not find solution - possible no dew point exists");
        }
    }

    public void dewPointMach(String componentName, String specification, double spec) throws Exception {
        double newTemperature;
        double dn = 0.0;
        if (!this.system.getPhase(0).hasComponent(componentName)) {
            throw new IsNaNException(this.getClass().getSimpleName(), "dewPointMach", "Specified component is not present in mixture: " + componentName);
        }
        dn = this.system.getNumberOfMoles() / 1000000.0;
        this.system.addComponent(componentName, dn);
        double oldTemperature = newTemperature = this.system.getTemperature();
        int iterations = 0;
        if (specification.equals("dewPointTemperature")) {
            do {
                this.system.init(0);
                this.dewPointTemperatureFlash();
                newTemperature = this.system.getTemperature();
                double oldMoles = this.system.getPhase(0).getComponent(componentName).getNumberOfmoles();
                if (++iterations > 1) {
                    this.system.addComponent(componentName, -((double)iterations / (30.0 + (double)iterations)) * (newTemperature - spec) / ((newTemperature - oldTemperature) / dn));
                } else {
                    this.system.addComponent(componentName, this.system.getNumberOfMoles() / 1000000.0);
                }
                dn = this.system.getPhase(0).getComponent(componentName).getNumberOfmoles() - oldMoles;
                oldTemperature = newTemperature;
            } while (Math.abs(dn / this.system.getPhase(0).getComponent(componentName).getNumberOfmoles()) > 1.0E-9 || iterations < 5 || iterations > 105);
            this.dewPointTemperatureFlash();
        }
        if (Double.isNaN(this.system.getPressure())) {
            throw new IsNaNException(this.getClass().getSimpleName(), "dewPointMach", "Could not find solution - possible no dew point exists");
        }
    }

    public void dewPointTemperatureFlash() throws Exception {
        dewPointTemperatureFlash operation = new dewPointTemperatureFlash(this.system);
        operation.run();
        if (Double.isNaN(this.system.getTemperature()) || operation.isSuperCritical()) {
            throw new IsNaNException(this.getClass().getSimpleName(), "dewPointTemperatureFlash", "Could not find solution - possible no dew point exists");
        }
    }

    public void dewPointTemperatureFlash(boolean derivatives) throws Exception {
        constantDutyTemperatureFlash operation = new dewPointTemperatureFlash(this.system);
        if (derivatives) {
            operation = new dewPointTemperatureFlashDer(this.system);
        }
        operation.run();
        if (Double.isNaN(this.system.getTemperature()) || operation.isSuperCritical()) {
            throw new IsNaNException(this.getClass().getSimpleName(), "dewPointTemperatureFlash", "Could not find solution - possible no dew point exists");
        }
    }

    public void dewPointPressureFlashHC() throws Exception {
        this.system.init(0);
        HCdewPointPressureFlash operation = new HCdewPointPressureFlash(this.system);
        operation.run();
        if (Double.isNaN(this.system.getPressure()) || operation.isSuperCritical()) {
            throw new IsNaNException(this.getClass().getSimpleName(), "dewPointPressureFlashHC", "Could not find solution - possible no dew point exists");
        }
    }

    public void dewPointPressureFlash() throws Exception {
        this.system.init(0);
        dewPointPressureFlash operation = new dewPointPressureFlash(this.system);
        operation.run();
        if (Double.isNaN(this.system.getPressure()) || operation.isSuperCritical()) {
            throw new IsNaNException(this.getClass().getSimpleName(), "dewPointPressureFlash", "Could not find solution - possible no dew point exists");
        }
    }

    public JFreeChart getJfreeChart() {
        return this.getOperation().getJFreeChart("");
    }

    public void calcPTphaseEnvelope() {
        this.operation = new pTphaseEnvelope(this.system, this.fileName, 0.9999999999, 1.0, false);
        this.getOperation().run();
    }

    public void calcPTphaseEnvelope(boolean bubfirst, double lowPres) {
        double phasefraction = 0.9999999999;
        if (bubfirst) {
            phasefraction = 1.0E-10;
        }
        this.operation = new pTphaseEnvelope(this.system, this.fileName, phasefraction, lowPres, bubfirst);
        this.getOperation().run();
    }

    public void calcPTphaseEnvelope(double lowPres) {
        this.operation = new pTphaseEnvelope(this.system, this.fileName, 1.0E-10, lowPres, true);
        this.getOperation().run();
    }

    public void calcPTphaseEnvelope(boolean bubfirst) {
        double phasefraction = 0.9999999999;
        if (bubfirst) {
            phasefraction = 1.0E-10;
        }
        this.operation = new pTphaseEnvelope(this.system, this.fileName, phasefraction, 1.0, bubfirst);
        if (!this.isRunAsThread()) {
            this.getOperation().run();
        } else {
            this.run();
        }
    }

    public void calcPTphaseEnvelope(double lowPres, double phasefraction) {
        this.operation = new pTphaseEnvelope(this.system, this.fileName, phasefraction, lowPres, true);
        this.getOperation().run();
    }

    public void calcPTphaseEnvelopeNew() {
        this.getOperation().run();
    }

    public void OLGApropTable(double minTemp, double maxTemp, int temperatureSteps, double minPres, double maxPres, int pressureSteps, String filename, int TABtype) {
        this.operation = new OLGApropertyTableGeneratorWaterStudents(this.system);
        ((OLGApropertyTableGeneratorWaterStudents)this.operation).setFileName(filename);
        ((OLGApropertyTableGeneratorWaterStudents)this.operation).setPressureRange(minPres, maxPres, pressureSteps);
        ((OLGApropertyTableGeneratorWaterStudents)this.operation).setTemperatureRange(minTemp, maxTemp, temperatureSteps);
        this.getOperation().run();
    }

    public void OLGApropTablePH(double minEnthalpy, double maxEnthalpy, int enthalpySteps, double minPres, double maxPres, int pressureSteps, String filename, int TABtype) {
        this.operation = new OLGApropertyTableGeneratorWaterStudentsPH(this.system);
        ((OLGApropertyTableGeneratorWaterStudentsPH)this.operation).setFileName(filename);
        ((OLGApropertyTableGeneratorWaterStudentsPH)this.operation).setPressureRange(minPres, maxPres, pressureSteps);
        ((OLGApropertyTableGeneratorWaterStudentsPH)this.operation).setEnthalpyRange(minEnthalpy, maxEnthalpy, enthalpySteps);
        this.getOperation().run();
    }

    public void calcPloadingCurve() {
        this.operation = new pLoadingCurve2(this.system);
        this.getOperation().run();
    }

    public void calcHPTphaseEnvelope() {
        this.operation = new HPTphaseEnvelope(this.system);
        this.operation.run();
    }

    public void printToFile(String name) {
        this.getOperation().printToFile(name);
    }

    public double[][] getData() {
        return this.getOperation().getPoints(0);
    }

    public String[][] getDataPoints() {
        String[][] str = new String[this.getOperation().getPoints(0).length][this.getOperation().getPoints(0)[0].length];
        int i = 0;
        while (i < this.getOperation().getPoints(0).length) {
            int j = 0;
            while (j < this.getOperation().getPoints(0)[0].length) {
                str[i][j] = Double.toString(this.getOperation().getPoints(0)[i][j]);
                ++j;
            }
            ++i;
        }
        return str;
    }

    public String[][] getResultTable() {
        return this.resultTable;
    }

    public double dewPointTemperatureCondensationRate() {
        double dT = 1.1;
        try {
            this.dewPointTemperatureFlash();
        }
        catch (Exception ex) {
            logger.error("error", (Throwable)ex);
        }
        this.system.setTemperature(this.system.getTemperature() - dT);
        this.TPflash();
        double condensationRate = this.system.getPhase(1).getMass() / (this.system.getVolume() * 1.0E-5);
        try {
            this.dewPointTemperatureFlash();
        }
        catch (Exception ex) {
            logger.error("error", (Throwable)ex);
        }
        return condensationRate / dT;
    }

    public void displayResult() {
        try {
            this.getThermoOperationThread().join();
        }
        catch (Exception ex) {
            logger.error("Thread did not finish");
        }
        this.getOperation().displayResult();
    }

    public void setResultTable(String[][] resultTable) {
        this.resultTable = resultTable;
    }

    public void display() {
        JFrame dialog = new JFrame("System-Report");
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new BorderLayout());
        Object[] names = new String[this.resultTable[0].length];
        int i = 0;
        while (i < names.length) {
            names[i] = "";
            ++i;
        }
        JTable Jtab = new JTable(this.resultTable, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.pack();
        dialog.setVisible(true);
    }

    public double[] get(String name) {
        return this.getOperation().get(name);
    }

    public OperationInterface getOperation() {
        return this.operation;
    }

    public boolean isRunAsThread() {
        return this.runAsThread;
    }

    public void setRunAsThread(boolean runAsThread) {
        this.runAsThread = runAsThread;
    }

    public Thread getThermoOperationThread() {
        return this.thermoOperationThread;
    }

    public void setThermoOperationThread(Thread thermoOperationThread) {
        this.thermoOperationThread = thermoOperationThread;
    }

    public void addData(String name, double[][] data) {
        this.operation.addData(name, data);
    }

    public void calcIonComposition(int phaseNumber) {
        this.operation = new calcIonicComposition(this.system, phaseNumber);
        this.getOperation().run();
        this.resultTable = this.getOperation().getResultTable();
    }

    public void flash(String flashType, double spec1, double spec2, String unitSpec1, String unitSpec2) {
        if (flashType.equals("TP")) {
            this.system.setTemperature(spec1, unitSpec1);
            this.system.setPressure(spec2, unitSpec2);
        } else if (flashType.equals("TV")) {
            this.system.setTemperature(spec1, unitSpec1);
            this.TVflash(spec2, unitSpec2);
        } else if (flashType.equals("PH")) {
            this.system.setPressure(spec1, unitSpec1);
            this.PHflash(spec2, unitSpec2);
        } else if (flashType.equals("TS")) {
            this.system.setTemperature(spec1, unitSpec1);
            this.TSflash(spec2, unitSpec2);
        }
    }

    /*
     * Unable to fully structure code
     */
    public CalculationResult propertyFlash(List<Double> Spec1, List<Double> Spec2, int FlashMode, List<String> components, List<List<Double>> onlineFractions) {
        fluidProperties = new Double[Spec1.size()][70];
        calculationError = new String[Spec1.size()];
        sum = new Double[Spec1.size()];
        if (onlineFractions != null) {
            t = 0;
            while (t < sum.length) {
                sum[t] = 0.0;
                comp = 0;
                while (comp < onlineFractions.size()) {
                    sum[t] = sum[t] + onlineFractions.get(comp).get(t);
                    ++comp;
                }
                ++t;
            }
            if (this.system.getNumberOfMoles() == 0.0) {
                this.system.setTotalNumberOfMoles(1.0);
            }
        } else {
            fraction = this.system.getMolarComposition();
            sum[0] = 0.0;
            comp = 0;
            while (comp < fraction.length) {
                sum[0] = sum[0] + fraction[comp];
                ++comp;
            }
        }
        t = 0;
        while (t < Spec1.size()) {
            block20: {
                try {
                    block21: {
                        Sp1 = Spec1.get(t);
                        Sp2 = Spec2.get(t);
                        if (Sp1 == null || Sp2 == null || Double.isNaN(Sp1) || Double.isNaN(Sp2)) {
                            calculationError[t] = "Sp1 or Sp2 is NaN";
                            ThermodynamicOperations.logger.info("Sp1 or Sp2 is NULL for datapoint {}", (Object)t);
                            break block20;
                        }
                        if (onlineFractions == null) break block21;
                        range = 5.0;
                        if (!(sum[t] >= 1.0 - range / 100.0 && sum[t] <= 1.0 + range / 100.0 || sum[t] >= 100.0 - range && sum[t] <= 100.0 + range)) {
                            calculationError[t] = "Sum of fractions must be approximately 1 or 100, currently (" + String.valueOf(sum[t]) + ")";
                            ThermodynamicOperations.logger.info("Online fraction does not sum to approximately 1 or 100 for datapoint {}", (Object)t);
                            break block20;
                        }
                        fraction = new double[this.system.getNumberOfComponents()];
                        comp = 0;
                        while (comp < onlineFractions.size()) {
                            fraction[comp] = onlineFractions.get(comp).get(t);
                            ++comp;
                        }
                        this.system.setMolarComposition(fraction);
                        this.system.init(0);
                        ** GOTO lbl-1000
                    }
                    range = 1.0E-8;
                    if (!(sum[0] >= 1.0 - range && sum[0] <= 1.0 + range || sum[0] >= 100.0 - range && sum[0] <= 100.0 + range)) {
                        calculationError[t] = "Sum of fractions must be equal to 1 or 100, currently (" + String.valueOf(sum[t]) + ")";
                        ThermodynamicOperations.logger.info("Sum of fractions must be equal to 1 or 100 for datapoint {}", (Object)t);
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.system.setPressure(Sp1);
                        if (FlashMode == 1) {
                            this.system.setTemperature(Sp2);
                            this.TPflash();
                        } else if (FlashMode == 2) {
                            this.PHflash((double)Sp2, "J/mol");
                        } else if (FlashMode == 3) {
                            this.PSflash(Sp2, "J/molK");
                        } else {
                            throw new RuntimeException(new InvalidInputException("ThermodynamicOperations", "propertyFlash", "mode", "must be 1, 2 or 3"));
                        }
                        this.system.init(2);
                        this.system.initPhysicalProperties();
                        fluidProperties[t] = this.system.getProperties().getValues();
                    }
                }
                catch (Exception ex) {
                    calculationError[t] = ex.getMessage();
                    ThermodynamicOperations.logger.error(ex.getMessage());
                }
            }
            ++t;
        }
        return new CalculationResult(fluidProperties, calculationError);
    }
}

