/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.specificHeat;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.specificHeat.SpecificHeatCpFunction;
import neqsim.util.database.NeqSimExperimentDatabase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestCp {
    static Logger logger = LogManager.getLogger(TestCp.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimExperimentDatabase database = new NeqSimExperimentDatabase();
        int i = 0;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ResultSet dataSet = database.getResultSet("SELECT * FROM PureComponentCpHeatCapacity WHERE ComponentName='seawater'");){
                while (dataSet.next() && i < 4) {
                    ++i;
                    SpecificHeatCpFunction function = new SpecificHeatCpFunction();
                    double[] guess = new double[]{36.54003, -0.034802404, 1.168117E-4, -1.3003096E-7};
                    function.setInitialGuess(guess);
                    SystemSrkEos testSystem = new SystemSrkEos(280.0, 1.101);
                    testSystem.addComponent(dataSet.getString("ComponentName"), 1.0);
                    testSystem.setMixingRule(2);
                    testSystem.init(0);
                    testSystem.setTemperature(Double.parseDouble(dataSet.getString("Temperature")));
                    testSystem.setPressure(5.0);
                    double[] sample1 = new double[]{testSystem.getPhase(0).getComponent(0).getz()};
                    double[] standardDeviation1 = new double[]{0.1, 0.1, 0.1};
                    double val = Double.parseDouble(dataSet.getString("HeatCapacityCp"));
                    SampleValue sample = new SampleValue(val, val / 100.0, sample1, standardDeviation1);
                    sample.setFunction(function);
                    sample.setReference(dataSet.getString("Reference"));
                    sample.setThermodynamicSystem(testSystem);
                    sampleList.add(sample);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
    }
}

