/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.hydrate;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.hydrate.HydrateFunction;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestHydrateFunction {
    static Logger logger = LogManager.getLogger(TestHydrateFunction.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        double[] guess = new double[]{155.8090060223, 3.1907109417, 0.4069986258};
        int numb = 0;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (ResultSet dataSet = database.getResultSet("SELECT * FROM HydratePureComp WHERE GuestMolecule='methane' AND Type<>'IHV' AND Pressure<57  AND Temperature>273.15");){
                logger.info("adding....");
                while (dataSet.next() && numb < 6) {
                    ++numb;
                    HydrateFunction function = new HydrateFunction();
                    function.setInitialGuess(guess);
                    double pres = Double.parseDouble(dataSet.getString("Pressure"));
                    double temp = Double.parseDouble(dataSet.getString("Temperature"));
                    SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(280.0, 1.0);
                    testSystem.addComponent(dataSet.getString("GuestMolecule"), 1.0);
                    testSystem.addComponent("water", 1.0);
                    testSystem.setHydrateCheck(true);
                    testSystem.createDatabase(true);
                    testSystem.setMixingRule(7);
                    testSystem.setTemperature(temp);
                    testSystem.setPressure(pres);
                    testSystem.init(0);
                    double[] sample1 = new double[]{temp};
                    double[] standardDeviation1 = new double[]{0.1};
                    SampleValue sample = new SampleValue(temp, 1.0, sample1, standardDeviation1);
                    sample.setFunction(function);
                    sample.setThermodynamicSystem(testSystem);
                    sample.setDescription(Double.toString(testSystem.getPressure()));
                    sample.setReference(dataSet.getString("Reference"));
                    sampleList.add(sample);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            logger.error("database error: ", (Throwable)ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
    }
}

