/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.cpaParam;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkCPA;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.cpaParam.CPAFunction;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.cpaParam.CPAFunctionDens;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestCPA_ice {
    static Logger logger = LogManager.getLogger(TestCPA_ice.class);

    public static void main(String[] args) {
        double dens;
        double[] standardDeviation1;
        double[] sample1;
        double temp;
        SystemSrkCPA testSystem;
        CPAFunction function;
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        double[] guess = new double[]{1.453, 0.9894, 1.0669, 0.05787};
        double[][] bounds = new double[][]{{0.0, 3.0055}, {0.0, 8.0055}, {1.0E-5, 10.001}, {-1.0015, 1.0015}, {-320.0015, 320.0015}, {-320.901, 320.900195}, {-1.0, 1000.0}, {-0.800001, 0.8}, {-80000.01, 20000.8}, {-0.01, 10.6}, {-0.01, 0.0015}, {-0.01, 0.0015}};
        ResultSet dataSet = database.getResultSet("SELECT * FROM SolidVapourPressure WHERE ComponentName='water' ORDER BY Temperature");
        try {
            while (dataSet.next()) {
                function = new CPAFunction();
                testSystem = new SystemSrkCPA(Double.parseDouble(dataSet.getString("Temperature")), Double.parseDouble(dataSet.getString("VapourPressure")));
                testSystem.addComponent(dataSet.getString("ComponentName"), 1.0);
                testSystem.createDatabase(true);
                testSystem.setMixingRule(2);
                temp = testSystem.getTemperature();
                double val = testSystem.getPressure();
                sample1 = new double[]{temp};
                standardDeviation1 = new double[]{0.1};
                double stddev = val / 100.0;
                double logVal = Math.log(val);
                SampleValue sample = new SampleValue(val, stddev, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                function.setInitialGuess(guess);
                sample.setReference(dataSet.getString("Reference"));
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        dataSet = database.getResultSet("SELECT * FROM SolidVapourPressure WHERE ComponentName='water' ORDER BY Temperature");
        try {
            while (dataSet.next()) {
                function = new CPAFunctionDens(1);
                testSystem = new SystemSrkCPA(Double.parseDouble(dataSet.getString("Temperature")), 1.1);
                temp = testSystem.getTemperature();
                testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                testSystem.setPressure(Double.parseDouble(dataSet.getString("VapourPressure")));
                testSystem.setTemperature(temp);
                testSystem.setMixingRule(1);
                dens = Double.parseDouble(dataSet.getString("soliddensity"));
                sample1 = new double[]{temp};
                standardDeviation1 = new double[]{0.1};
                SampleValue sample = new SampleValue(dens, dens / 100.0, sample1, standardDeviation1);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(dataSet.getString("Reference"));
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        dataSet = database.getResultSet("SELECT * FROM PureComponentVapourPressures WHERE ComponentName='water' ORDER BY Temperature");
        try {
            while (!dataSet.next()) {
                function = new CPAFunctionDens(0);
                testSystem = new SystemSrkCPA(280.0, 5.001);
                temp = Double.parseDouble(dataSet.getString("Temperature"));
                testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                testSystem.setPressure(Double.parseDouble(dataSet.getString("VapourPressure")) + 0.5);
                testSystem.setTemperature(temp);
                testSystem.setMixingRule(2);
                testSystem.init(0);
                dens = Double.parseDouble(dataSet.getString("gasdensity"));
                sample1 = new double[]{temp};
                standardDeviation1 = new double[]{0.1};
                SampleValue sample = new SampleValue(dens, dens / 100.0, sample1, standardDeviation1);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(dataSet.getString("Reference"));
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        dataSet = database.getResultSet("SELECT * FROM PureComponentVapourPressures WHERE ComponentName='water' AND Temperature>273.15 AND Temperature<620.15 ORDER BY Temperature");
        try {
            while (dataSet.next()) {
                function = new CPAFunctionDens(0);
                testSystem = new SystemSrkCPA(280.0, 5.001);
                temp = Double.parseDouble(dataSet.getString("Temperature"));
                testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                testSystem.setPressure(Double.parseDouble(dataSet.getString("VapourPressure")) + 0.5);
                testSystem.setTemperature(temp);
                testSystem.setMixingRule(2);
                testSystem.init(0);
                dens = Double.parseDouble(dataSet.getString("gasdensity"));
                sample1 = new double[]{temp};
                standardDeviation1 = new double[]{0.1};
                SampleValue sample = new SampleValue(dens, dens / 100.0, sample1, standardDeviation1);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(dataSet.getString("Reference"));
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        LevenbergMarquardt optim = new LevenbergMarquardt();
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
        optim.writeToTextFile("c:/test.txt");
    }
}

