/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.cpaParam;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.cpaParam.CPAFunctionStatoil;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestCPAStatoil {
    static Logger logger = LogManager.getLogger(TestCPAStatoil.class);

    public static void main(String[] args) {
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        LevenbergMarquardt optim = new LevenbergMarquardt();
        NeqSimDataBase database = new NeqSimDataBase();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ResultSet dataSet = database.getResultSet("SELECT * FROM PureComponentVapourPressures WHERE ComponentName='MEG' AND Temperature<500.0");){
                while (dataSet.next()) {
                    CPAFunctionStatoil function = new CPAFunctionStatoil();
                    SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(280.0, 0.001);
                    testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                    testSystem.createDatabase(true);
                    double[] sample1 = new double[]{Double.parseDouble(dataSet.getString("Temperature"))};
                    double[] standardDeviation1 = new double[]{0.1};
                    double val = Double.parseDouble(dataSet.getString("VapourPressure"));
                    testSystem.setPressure(val);
                    double stddev = val / 10.0;
                    double logVal = Math.log(val);
                    SampleValue sample = new SampleValue(val, stddev, sample1, standardDeviation1);
                    testSystem.init(0);
                    double[] guess = new double[]{0.7892765953, -1.0606510837, 2.207193651};
                    function.setInitialGuess(guess);
                    sample.setFunction(function);
                    sample.setThermodynamicSystem(testSystem);
                    sample.setReference(dataSet.getString("Reference"));
                    sampleList.add(sample);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
    }
}

