/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.cpaParam;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkCPAs;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.cpaParam.CPAFunction;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.cpaParam.CPAFunctionDens;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestCPA {
    static Logger logger = LogManager.getLogger(TestCPA.class);

    public static void main(String[] args) {
        double val;
        double[] standardDeviation1;
        double[] sample1;
        SystemSrkCPAs testSystem;
        CPAFunction function;
        ResultSet dataSet;
        Object var4_8;
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        try {
            Throwable throwable = null;
            var4_8 = null;
            try {
                dataSet = database.getResultSet("SELECT * FROM PureComponentVapourPressures WHERE ComponentName='MDEA' AND VapourPressure>0");
                try {
                    while (dataSet.next()) {
                        function = new CPAFunction();
                        testSystem = new SystemSrkCPAs(280.0, 0.1);
                        testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                        sample1 = new double[]{Double.parseDouble(dataSet.getString("Temperature"))};
                        testSystem.setTemperature(sample1[0]);
                        standardDeviation1 = new double[]{0.1};
                        val = Double.parseDouble(dataSet.getString("VapourPressure"));
                        testSystem.setPressure(val);
                        double stddev = val / 100.0;
                        double logVal = Math.log(val);
                        SampleValue sample = new SampleValue(val, stddev, sample1, standardDeviation1);
                        testSystem.init(0);
                        double[] guess = new double[]{13.21, 39.123563589168, 1.1692, 0.0188, 14337.0};
                        function.setInitialGuess(guess);
                        sample.setFunction(function);
                        sample.setThermodynamicSystem(testSystem);
                        sample.setReference(dataSet.getString("Reference"));
                        sampleList.add(sample);
                    }
                }
                finally {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        try {
            Throwable ex = null;
            var4_8 = null;
            try {
                dataSet = database.getResultSet("SELECT * FROM PureComponentDensity WHERE ComponentName='MDEA'");
                try {
                    while (dataSet.next()) {
                        function = new CPAFunctionDens();
                        testSystem = new SystemSrkCPAs(280.0, 0.001);
                        testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                        testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")));
                        sample1 = new double[]{Double.parseDouble(dataSet.getString("Temperature"))};
                        testSystem.setTemperature(sample1[0]);
                        testSystem.init(0);
                        testSystem.setMixingRule(1);
                        standardDeviation1 = new double[]{0.1};
                        val = Double.parseDouble(dataSet.getString("Density"));
                        SampleValue sample = new SampleValue(val, val / 100.0, sample1, standardDeviation1);
                        double[] guess = new double[]{13.21, 39.123563589168, 1.1692, 0.0188, 14337.0};
                        function.setInitialGuess(guess);
                        sample.setFunction(function);
                        sample.setThermodynamicSystem(testSystem);
                        sample.setReference(dataSet.getString("Reference"));
                        sampleList.add(sample);
                    }
                }
                finally {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (ex == null) {
                    ex = throwable;
                } else if (ex != throwable) {
                    ex.addSuppressed(throwable);
                }
                throw ex;
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        LevenbergMarquardt optim = new LevenbergMarquardt();
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
        optim.writeToTextFile("c:/test.txt");
    }
}

