/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.cpaParam;

import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardtFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CPAFunction
extends LevenbergMarquardtFunction {
    static Logger logger = LogManager.getLogger(CPAFunction.class);

    @Override
    public double calcValue(double[] dependentValues) {
        this.system.init(0);
        try {
            this.thermoOps.bubblePointPressureFlash(false);
        }
        catch (Exception ex) {
            logger.error(ex.toString());
        }
        return this.system.getPressure();
    }

    @Override
    public double calcTrueValue(double val) {
        return val;
    }

    @Override
    public void setFittingParams(int i, double value) {
        this.params[i] = value;
        if (i == 11) {
            this.system.getPhases()[0].getComponents()[0].seta(value * 10000.0);
            this.system.getPhases()[1].getComponents()[0].seta(value * 10000.0);
        }
        if (i == 10) {
            this.system.getPhases()[0].getComponents()[0].setb(value);
            this.system.getPhases()[1].getComponents()[0].setb(value);
        }
        if (i == 12) {
            this.system.getPhase(0).getComponent(0).getAttractiveTerm().setm(value);
            this.system.getPhases()[1].getComponents()[0].getAttractiveTerm().setm(value);
        }
        if (i == 14) {
            this.system.getPhase(0).getComponent(0).setAssociationEnergy(value * 10000.0);
            this.system.getPhase(1).getComponent(0).setAssociationEnergy(value * 10000.0);
        }
        if (i == 13) {
            this.system.getPhase(0).getComponent(0).setAssociationVolume(value);
            this.system.getPhase(1).getComponent(0).setAssociationVolume(value);
        }
        if (i == 15) {
            this.system.getPhase(0).getComponent(0).getAttractiveTerm().setm(value);
            this.system.getPhases()[1].getComponents()[0].getAttractiveTerm().setm(value);
        }
        if (i >= 5 && i < 8) {
            this.system.getPhases()[0].getComponents()[0].setMatiascopemanParams(i - 5, value);
            this.system.getPhases()[1].getComponents()[0].setMatiascopemanParams(i - 5, value);
            this.system.getPhases()[0].getComponents()[0].getAttractiveTerm().setParameters(i - 5, value);
            this.system.getPhases()[1].getComponents()[0].getAttractiveTerm().setParameters(i - 5, value);
        }
        if (i == 0) {
            this.system.getPhases()[0].getComponents()[0].setRacketZCPA(value);
            this.system.getPhases()[1].getComponents()[0].setRacketZCPA(value);
        }
        if (i == 1) {
            this.system.getPhases()[0].getComponents()[0].setVolumeCorrectionT_CPA(value);
            this.system.getPhases()[1].getComponents()[0].setVolumeCorrectionT_CPA(value);
        }
    }
}

