/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkMathiasCopeman;
import neqsim.thermo.util.parameterFitting.pureComponentParameterFitting.acentricFactorFitting.MathiasCopemanToDewPoint;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestMathiasCopemanToDewPoint {
    static Logger logger = LogManager.getLogger(TestMathiasCopemanToDewPoint.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = null;
        double[] guess = new double[]{0.7131945439, 0.4140076386, -2.5691833434, 4.3710359391, -1.1086000763, 7.3866869416, 1.1183339865, -2.1831081128, 0.9948380388, 1.5665073967, -5.5636308059, -1.4091055663, 0.8232405436, -0.3922156128, -1.4347079752, 1.3771397711, -1.2103436623, 0.0028643344, 1.3423413878, -0.3330681068, -2.1604332713, 1.155491503, -1.7359747766, 1.108443834, 1.180035836, -1.4810259893, 1.4887592454};
        String[] nameList = new String[]{"methane", "ethane", "propane", "n-butane", "i-butane", "n-pentane", "c-hexane", "benzene", "n-heptane"};
        int compNumb = 0;
        while (compNumb < nameList.length) {
            dataSet = database.getResultSet("SELECT * FROM PureComponentVapourPressures WHERE ComponentName='" + nameList[compNumb] + "' AND VapourPressure>0 ORDER BY Temperature ASC");
            try {
                long numberOfPoint = 3L;
                logger.error("point " + numberOfPoint);
                int i = 0;
                while (dataSet.next()) {
                    if ((long)(++i) % numberOfPoint != 0L) continue;
                    MathiasCopemanToDewPoint function = new MathiasCopemanToDewPoint();
                    function.setInitialGuess(guess);
                    SystemSrkMathiasCopeman testSystem = new SystemSrkMathiasCopeman(Double.parseDouble(dataSet.getString("Temperature")), Double.parseDouble(dataSet.getString("VapourPressure")));
                    testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                    double[] sample1 = new double[]{testSystem.getPressure()};
                    double[] standardDeviation1 = new double[]{0.1, 0.1, 0.1};
                    double val = testSystem.getTemperature();
                    double stdErr = 1.0;
                    SampleValue sample = new SampleValue(val, stdErr, sample1, standardDeviation1);
                    sample.setFunction(function);
                    sample.setReference(dataSet.getString("Reference"));
                    sample.setThermodynamicSystem(testSystem);
                    sampleList.add(sample);
                }
            }
            catch (Exception ex) {
                logger.error("database error" + ex);
            }
            ++compNumb;
        }
        dataSet = database.getResultSet("SELECT * FROM dewPointDataSynthHCStatoil WHERE Pressure<80.0");
        try {
            long numberOfPoint = 1L;
            logger.info("point " + numberOfPoint);
            int i = 0;
            while (dataSet.next() && i < 100) {
                if ((long)(++i) % numberOfPoint != 0L) continue;
                MathiasCopemanToDewPoint function = new MathiasCopemanToDewPoint();
                function.setInitialGuess(guess);
                SystemSrkMathiasCopeman testSystem = new SystemSrkMathiasCopeman(Double.parseDouble(dataSet.getString("Temperature")), Double.parseDouble(dataSet.getString("Pressure")));
                testSystem.addComponent(dataSet.getString("comp1"), Double.parseDouble(dataSet.getString("x1")));
                testSystem.addComponent(dataSet.getString("comp2"), Double.parseDouble(dataSet.getString("x2")));
                testSystem.addComponent(dataSet.getString("comp3"), Double.parseDouble(dataSet.getString("x3")));
                testSystem.addComponent(dataSet.getString("comp4"), Double.parseDouble(dataSet.getString("x4")));
                testSystem.addComponent(dataSet.getString("comp5"), Double.parseDouble(dataSet.getString("x5")));
                testSystem.addComponent(dataSet.getString("comp6"), Double.parseDouble(dataSet.getString("x6")));
                testSystem.addComponent(dataSet.getString("comp7"), Double.parseDouble(dataSet.getString("x7")));
                testSystem.addComponent(dataSet.getString("comp8"), Double.parseDouble(dataSet.getString("x8")));
                testSystem.addComponent(dataSet.getString("comp9"), Double.parseDouble(dataSet.getString("x9")));
                double[] sample1 = new double[]{testSystem.getPressure()};
                double[] standardDeviation1 = new double[]{0.1, 0.1, 0.1};
                double val = testSystem.getTemperature();
                double stdErr = 1.0;
                SampleValue sample = new SampleValue(val, stdErr, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setReference(dataSet.getString("reference"));
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
    }
}

