/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.ionicInteractionCoefficientFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.ionicInteractionCoefficientFitting.IonicInteractionParameterFittingFunctionCH4;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.ionicInteractionCoefficientFitting.IonicInteractionParameterFittingFunctionCH4_1;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestIonicInteractionParameterFittingCH4 {
    static Logger logger = LogManager.getLogger(TestIonicInteractionParameterFittingCH4.class);

    public static void main(String[] args) {
        double[] standardDeviation1;
        double[] sample1;
        double pressure;
        double temperature;
        SystemFurstElectrolyteEos testSystem;
        IonicInteractionParameterFittingFunctionCH4 function;
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM Co2Ch4MDEA WHERE loading<1.9");
        double[] guess = new double[]{-1.617266E-4, 5.0E-4};
        try {
            int i = 0;
            while (dataSet.next() && i < 100) {
                ++i;
                function = new IonicInteractionParameterFittingFunctionCH4();
                testSystem = new SystemFurstElectrolyteEos(298.15, 100.0);
                testSystem.addComponent(dataSet.getString("gass2"), Double.parseDouble(dataSet.getString("molCH4")));
                testSystem.addComponent(dataSet.getString("gass1"), Double.parseDouble(dataSet.getString("molCO2")));
                testSystem.addComponent(dataSet.getString("liquid1"), Double.parseDouble(dataSet.getString("molMDEA")));
                testSystem.addComponent(dataSet.getString("liquid2"), Double.parseDouble(dataSet.getString("molWater")));
                temperature = Double.parseDouble(dataSet.getString("Temperature"));
                pressure = Double.parseDouble(dataSet.getString("Pressure"));
                testSystem.setPressure(pressure);
                testSystem.setTemperature(temperature);
                testSystem.chemicalReactionInit();
                testSystem.setMixingRule(4);
                testSystem.init(0);
                sample1 = new double[]{testSystem.getPhases()[0].getComponents()[0].getNumberOfMolesInPhase() / testSystem.getPhases()[0].getComponents()[2].getNumberOfMolesInPhase()};
                standardDeviation1 = new double[]{0.01};
                SampleValue sample = new SampleValue(pressure, pressure / 100.0, sample1, standardDeviation1);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setReference("addicks");
                sample.setDescription(Double.toString(pressure));
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        dataSet = database.getResultSet("SELECT * FROM Co2Ch4MDEA WHERE loading<1.9");
        try {
            int i = 0;
            while (!dataSet.next() && i < 100) {
                ++i;
                function = new IonicInteractionParameterFittingFunctionCH4_1();
                testSystem = new SystemFurstElectrolyteEos(298.15, 100.0);
                testSystem.addComponent(dataSet.getString("gass2"), Double.parseDouble(dataSet.getString("molCH4")));
                testSystem.addComponent(dataSet.getString("gass1"), Double.parseDouble(dataSet.getString("molCO2")));
                testSystem.addComponent(dataSet.getString("liquid1"), Double.parseDouble(dataSet.getString("molMDEA")));
                testSystem.addComponent(dataSet.getString("liquid2"), Double.parseDouble(dataSet.getString("molWater")));
                temperature = Double.parseDouble(dataSet.getString("Temperature"));
                pressure = Double.parseDouble(dataSet.getString("Pressure"));
                testSystem.setPressure(pressure);
                testSystem.setTemperature(temperature);
                testSystem.chemicalReactionInit();
                testSystem.setMixingRule(4);
                testSystem.init(0);
                sample1 = new double[]{testSystem.getPhases()[0].getComponents()[1].getNumberOfMolesInPhase() / testSystem.getPhases()[0].getComponents()[2].getNumberOfMolesInPhase()};
                standardDeviation1 = new double[]{0.01};
                double y1 = Double.parseDouble(dataSet.getString("y1"));
                SampleValue sample = new SampleValue(pressure * y1, y1 * pressure / 100.0, sample1, standardDeviation1);
                function.setInitialGuess(guess);
                sample.setFunction(function);
                sample.setReference("addicks");
                sample.setDescription(Double.toString(pressure));
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
        optim.writeToTextFile("c:/testFit.txt");
    }
}

