/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemPrEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.HuronVidalParameterFitting.BinaryHVParameterFittingToDewPointData;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestBinaryHVParameterFittingToDewPointData {
    static Logger logger = LogManager.getLogger(TestBinaryHVParameterFittingToDewPointData.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ResultSet dataSet = database.getResultSet("SELECT * FROM dewpointquaternary WHERE temperature>173.1 AND x4>0.0000021 ORDER BY x4,pressure");){
                int p = 0;
                logger.info("adding....");
                while (dataSet.next() && p < 300) {
                    ++p;
                    BinaryHVParameterFittingToDewPointData function = new BinaryHVParameterFittingToDewPointData();
                    SystemPrEos testSystem = new SystemPrEos(290.0, 1.0);
                    testSystem.addComponent(dataSet.getString("comp1"), Double.parseDouble(dataSet.getString("x1")));
                    testSystem.addComponent(dataSet.getString("comp2"), Double.parseDouble(dataSet.getString("x2")));
                    testSystem.addComponent("ethane", Double.parseDouble(dataSet.getString("x3")));
                    testSystem.addComponent(dataSet.getString("comp4"), Double.parseDouble(dataSet.getString("x4")));
                    testSystem.setMixingRule(4);
                    testSystem.setTemperature(Double.parseDouble(dataSet.getString("temperature")));
                    testSystem.setPressure(Double.parseDouble(dataSet.getString("pressure")));
                    testSystem.init(0);
                    double[] sample1 = new double[]{testSystem.getPressure(), testSystem.getTemperature()};
                    double[] standardDeviation1 = new double[]{0.01};
                    SampleValue sample = new SampleValue(testSystem.getTemperature(), testSystem.getTemperature() / 100.0, sample1, standardDeviation1);
                    sample.setFunction(function);
                    sample.setThermodynamicSystem(testSystem);
                    sample.setReference(Double.toString(testSystem.getTemperature()));
                    double[] parameterGuess = new double[]{0.01};
                    sample.setReference(Double.toString(testSystem.getPressure()));
                    function.setInitialGuess(parameterGuess);
                    sampleList.add(sample);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
        optim.displayResult();
    }
}

