/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermo.util.parameterFitting.binaryInteractionParameterFitting.EosInteractionParameterFitting.EosInteractionParameterFittingFunction;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestEosInteractionParameterFitting {
    static Logger logger = LogManager.getLogger(TestEosInteractionParameterFitting.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ResultSet dataSet = database.getResultSet("SELECT * FROM binaryequilibriumdata WHERE Component1='methane' AND Component2='ethane'");){
                logger.info("adding....");
                while (dataSet.next()) {
                    EosInteractionParameterFittingFunction function = new EosInteractionParameterFittingFunction();
                    double[] guess = new double[]{0.01};
                    function.setInitialGuess(guess);
                    SystemSrkEos testSystem = new SystemSrkEos(280.0, 0.01);
                    testSystem.addComponent(dataSet.getString("Component1"), 1.0);
                    testSystem.addComponent(dataSet.getString("Component2"), 1.0);
                    testSystem.setMixingRule(2);
                    testSystem.setTemperature(Double.parseDouble(dataSet.getString("Temperature")));
                    testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")));
                    double[] sample1 = new double[]{Double.parseDouble(dataSet.getString("x1")), Double.parseDouble(dataSet.getString("y1"))};
                    double[] standardDeviation1 = new double[]{0.01, 0.01};
                    SampleValue sample = new SampleValue(0.0, 0.01, sample1, standardDeviation1);
                    sample.setFunction(function);
                    sample.setThermodynamicSystem(testSystem);
                    sampleList.add(sample);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
    }
}

