/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Statoil.Acids;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermo.util.parameterFitting.Statoil.Acids.IonicInteractionParameterFittingFunctionAcid;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestIonicInteractionParameterFittingAcid {
    static Logger logger = LogManager.getLogger(TestIonicInteractionParameterFittingAcid.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        int error = 1;
        double[] guess = new double[]{7.08122E-5};
        try {
            Throwable throwable = null;
            Object var21_9 = null;
            try (ResultSet dataSet = database.getResultSet("SELECT * FROM Sleipner");){
                int i = 0;
                logger.info("adding....");
                while (dataSet.next()) {
                    ++i;
                    IonicInteractionParameterFittingFunctionAcid function = new IonicInteractionParameterFittingFunctionAcid();
                    double ID = Integer.parseInt(dataSet.getString("ID"));
                    double pressure = Double.parseDouble(dataSet.getString("Pressure"));
                    double temperature = Double.parseDouble(dataSet.getString("Temperature"));
                    double x1 = Double.parseDouble(dataSet.getString("x1"));
                    double x2 = Double.parseDouble(dataSet.getString("x2"));
                    double x3 = Double.parseDouble(dataSet.getString("x3"));
                    double x4 = Double.parseDouble(dataSet.getString("x4"));
                    SystemFurstElectrolyteEos testSystem = new SystemFurstElectrolyteEos(temperature, pressure);
                    testSystem.addComponent("CO2", x1);
                    testSystem.addComponent("AceticAcid", x3);
                    testSystem.addComponent("MDEA", x4);
                    testSystem.addComponent("water", x2);
                    testSystem.chemicalReactionInit();
                    testSystem.createDatabase(true);
                    testSystem.setMixingRule(4);
                    testSystem.init(0);
                    double[] sample1 = new double[]{x1 / x4};
                    double[] standardDeviation1 = new double[]{0.01};
                    error = ID == 162.0 ? 5 : 1;
                    SampleValue sample = new SampleValue(pressure, (double)error * pressure / 100.0, sample1, standardDeviation1);
                    function.setInitialGuess(guess);
                    sample.setFunction(function);
                    sample.setDescription(Double.toString(ID));
                    sample.setThermodynamicSystem(testSystem);
                    sampleList.add(sample);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayCurveFit();
    }
}

