/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Procede.WaterMDEA;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermo.util.parameterFitting.Procede.WaterMDEA.BinaryHVParameterFittingFunction_MDEA;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestBinaryHVParameterFitting_MDEA {
    static Logger logger = LogManager.getLogger(TestBinaryHVParameterFitting_MDEA.class);

    public static void main(String[] args) {
        SampleValue sample;
        double stddev;
        double[] standardDeviation1;
        double[] sample1;
        SystemSrkSchwartzentruberEos testSystem;
        double x1;
        double temperature;
        double ID;
        BinaryHVParameterFittingFunction_MDEA function;
        boolean i;
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        double[] guess = new double[]{-5596.6518968945, 3995.5032952165, 10.9677849623, -8.0407258862, 0.2703018372};
        ResultSet dataSet = database.getResultSet("SELECT * FROM WaterMDEA WHERE ID<62");
        dataSet = database.getResultSet("SELECT * FROM WaterMDEAactivity WHERE ID<20");
        try {
            i = false;
            logger.info("adding....");
            while (dataSet.next()) {
                function = new BinaryHVParameterFittingFunction_MDEA(1, 3);
                function.setInitialGuess(guess);
                ID = Double.parseDouble(dataSet.getString("ID"));
                double act1 = Double.parseDouble(dataSet.getString("act1"));
                temperature = Double.parseDouble(dataSet.getString("Temperature"));
                x1 = Double.parseDouble(dataSet.getString("x1"));
                testSystem = new SystemSrkSchwartzentruberEos(temperature, 1.0);
                testSystem.addComponent("water", x1);
                testSystem.addComponent("MDEA", 1.0 - x1);
                logger.info("...........ID............." + ID);
                testSystem.createDatabase(true);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                sample1 = new double[]{x1};
                standardDeviation1 = new double[]{0.1};
                stddev = act1 / 100.0;
                sample = new SampleValue(act1, stddev, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setReference(Double.toString(ID));
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.info("database error" + ex);
        }
        dataSet = database.getResultSet("SELECT * FROM WaterMDEAactivity WHERE ID>19");
        try {
            i = false;
            logger.info("adding....");
            while (dataSet.next()) {
                function = new BinaryHVParameterFittingFunction_MDEA(1, 4);
                function.setInitialGuess(guess);
                ID = Double.parseDouble(dataSet.getString("ID"));
                double act2 = Double.parseDouble(dataSet.getString("act2"));
                temperature = Double.parseDouble(dataSet.getString("Temperature"));
                x1 = Double.parseDouble(dataSet.getString("x1"));
                testSystem = new SystemSrkSchwartzentruberEos(temperature, 1.0);
                testSystem.addComponent("water", x1);
                testSystem.addComponent("MDEA", 1.0 - x1);
                logger.info("...........ID............." + ID);
                testSystem.createDatabase(true);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                sample1 = new double[]{x1};
                standardDeviation1 = new double[]{0.1};
                stddev = act2 / 100.0;
                sample = new SampleValue(act2, stddev, sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setReference(Double.toString(ID));
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error" + ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
    }
}

