/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Procede.CO2WaterMDEA;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.ResultSet;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CO2_MDEA {
    static Logger logger = LogManager.getLogger(CO2_MDEA.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        int i = 0;
        int CO2Numb = 0;
        int WaterNumb = 0;
        int MDEANumb = 0;
        int HCO3Numb = 0;
        int MDEAHpNumb = 0;
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM CO2WaterMDEA WHERE ID>196 AND ID<231");
        try {
            while (dataSet.next()) {
                logger.info("Adding.... " + ++i);
                double ID = Double.parseDouble(dataSet.getString("ID"));
                double pressure = Double.parseDouble(dataSet.getString("PressureCO2"));
                double temperature = Double.parseDouble(dataSet.getString("Temperature"));
                double x1 = Double.parseDouble(dataSet.getString("x1"));
                double x2 = Double.parseDouble(dataSet.getString("x2"));
                double x3 = Double.parseDouble(dataSet.getString("x3"));
                logger.info("................ID............ " + ID);
                SystemFurstElectrolyteEos testSystem = new SystemFurstElectrolyteEos(temperature, pressure);
                testSystem.addComponent("CO2", x1);
                testSystem.addComponent("MDEA", x3);
                testSystem.addComponent("water", x2);
                testSystem.chemicalReactionInit();
                testSystem.createDatabase(true);
                testSystem.setMixingRule(4);
                testSystem.init(0);
                int j = 0;
                do {
                    CO2Numb = j++;
                } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("CO2"));
                j = 0;
                do {
                    MDEANumb = j++;
                } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("MDEA"));
                j = 0;
                do {
                    WaterNumb = j++;
                } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("water"));
                j = 0;
                do {
                    HCO3Numb = j++;
                } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("HCO3-"));
                j = 0;
                do {
                    MDEAHpNumb = j++;
                } while (!testSystem.getPhases()[1].getComponents()[j - 1].getComponentName().equals("MDEA+"));
                ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
                try {
                    testOps.bubblePointPressureFlash(false);
                }
                catch (Exception ex) {
                    logger.error(ex.toString());
                }
                double bias = (pressure - testSystem.getPressure() * testSystem.getPhase(0).getComponent(CO2Numb).getx()) / pressure * 100.0;
                try {
                    Throwable ex = null;
                    Object var27_24 = null;
                    try (PrintStream p = new PrintStream(new FileOutputStream("C:/java/NeqSimSource/Patrick.txt", true));){
                        p.println(String.valueOf(ID) + " " + pressure + " " + testSystem.getPressure() * testSystem.getPhase(0).getComponent(CO2Numb).getx());
                    }
                    catch (Throwable throwable) {
                        if (ex == null) {
                            ex = throwable;
                            throw ex;
                        }
                        if (ex == throwable) throw ex;
                        ex.addSuppressed(throwable);
                        throw ex;
                    }
                }
                catch (FileNotFoundException ex) {
                    logger.error("Could not find file" + ex.getMessage());
                }
            }
        }
        catch (Exception ex) {
            logger.error("database error " + ex);
        }
        logger.info("Finished");
    }
}

