/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.parameterFitting.Procede.CO2MDEA;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class N2O {
    static Logger logger = LogManager.getLogger(N2O.class);

    public static void main(String[] args) {
        double temperature = 313.0;
        double wt = 0.4;
        temperature = 283.0;
        while (temperature <= 363.0) {
            double x = wt / 119.16 / (wt / 119.16 + (1.0 - wt) / 18.02);
            SystemSrkSchwartzentruberEos testSystem = new SystemSrkSchwartzentruberEos(temperature, 1.0);
            testSystem.addComponent("CO2", 0.001 * x);
            testSystem.addComponent("water", 1.0 - x);
            testSystem.addComponent("MDEA", x);
            testSystem.createDatabase(true);
            testSystem.setMixingRule(4);
            testSystem.init(0);
            testSystem.init(1);
            ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
            try {
                testOps.bubblePointPressureFlash(false);
            }
            catch (Exception ex) {
                logger.error(ex.toString());
            }
            double aCO2 = testSystem.getPhase(1).getActivityCoefficient(0, 1);
            double aMDEA = testSystem.getPhase(1).getActivityCoefficient(2);
            double awater = testSystem.getPhase(1).getActivityCoefficient(1);
            logger.info(aCO2);
            try {
                Throwable throwable = null;
                Object var16_3 = null;
                try (PrintStream p = new PrintStream(new FileOutputStream("C:/java/NeqSimSource/Patrick.txt", true));){
                    p.println(String.valueOf(temperature) + " " + testSystem.getPressure() * testSystem.getPhase(0).getComponent(0).getx() + " " + aCO2 + " " + aMDEA + " " + awater);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException ex) {
                logger.error("Could not find file" + ex.getMessage());
                logger.error("Could not read from Patrick.txt" + ex.getMessage());
            }
            temperature += 10.0;
        }
        logger.info("Finished");
    }
}

