/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.phase.PhaseRK;
import neqsim.thermo.system.SystemEos;

public class SystemRKEos
extends SystemEos {
    private static final long serialVersionUID = 1000L;

    public SystemRKEos() {
        this.modelName = "RK-EOS";
        this.attractiveTermNumber = 5;
        int i = 0;
        while (i < this.numberOfPhases) {
            this.phaseArray[i] = new PhaseRK();
            this.phaseArray[i].setTemperature(298.15);
            this.phaseArray[i].setPressure(1.0);
            ++i;
        }
    }

    public SystemRKEos(double T, double P) {
        super(T, P);
        this.attractiveTermNumber = 5;
        this.modelName = "RK-EOS";
        int i = 0;
        while (i < this.numberOfPhases) {
            this.phaseArray[i] = new PhaseRK();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
            ++i;
        }
    }

    public SystemRKEos(double T, double P, boolean solidCheck) {
        this(T, P);
        this.attractiveTermNumber = 5;
        this.setNumberOfPhases(4);
        this.modelName = "RK-EOS";
        this.solidPhaseCheck = solidCheck;
        int i = 0;
        while (i < this.numberOfPhases) {
            this.phaseArray[i] = new PhaseRK();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
            ++i;
        }
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemRKEos clone() {
        SystemRKEos clonedSystem = null;
        try {
            clonedSystem = (SystemRKEos)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }
}

