/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import java.util.HashMap;
import java.util.Objects;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;

public class SystemProperties {
    private Double[] values;
    private String[] names;
    public static final int nCols = 70;

    public SystemProperties(SystemInterface fluid) {
        String[] phaseName = new String[]{"gas", "oil", "aqueous"};
        this.values = new Double[70];
        this.names = new String[70];
        int k = 0;
        this.names[k] = "Mix Number of Phases";
        this.values[k] = fluid.getNumberOfPhases();
        this.names[++k] = "Mix Pressure [Pa]";
        this.values[k] = fluid.getPressure("Pa");
        this.names[++k] = "Mix Temperature [K]";
        this.values[k] = fluid.getTemperature("K");
        this.names[++k] = "Mix Mole Percent";
        this.values[k] = fluid.getNumberOfMoles() * 100.0;
        this.names[++k] = "Mix Weight Percent";
        this.values[k] = 100.0;
        this.names[++k] = "Mix Molar Volume [m3/mol]";
        this.values[k] = 1.0 / fluid.getDensity("mol/m3");
        this.names[++k] = "Mix Volume Percent";
        this.values[k] = 100.0;
        this.names[++k] = "Mix Density [kg/m3]";
        this.values[k] = fluid.getDensity("kg/m3");
        this.names[++k] = "Mix Z Factor";
        this.values[k] = fluid.getZ();
        this.names[++k] = "Mix Molecular Weight [g/mol]";
        this.values[k] = fluid.getMolarMass() * 1000.0;
        this.names[++k] = "Mix Enthalpy [J/mol]";
        this.values[k] = fluid.getEnthalpy("J/mol");
        this.names[++k] = "Mix Entropy [J/molK]";
        this.values[k] = fluid.getEntropy("J/molK");
        this.names[++k] = "Mix Heat Capacity-Cp [J/molK]";
        this.values[k] = fluid.getCp("J/molK");
        this.names[++k] = "Mix Heat Capacity-Cv [J/molK]";
        this.values[k] = fluid.getCv("J/molK");
        this.names[++k] = "Mix Kappa (Cp/Cv)";
        this.values[k] = fluid.getGamma();
        this.names[++k] = "Mix JT Coefficient [K/Pa]";
        this.values[k] = Double.NaN;
        this.names[++k] = "Mix Velocity of Sound [m/s]";
        this.values[k] = Double.NaN;
        this.names[++k] = "Mix Viscosity [Pa s] or [kg/(m*s)]";
        this.values[k] = fluid.getViscosity("kg/msec");
        this.names[++k] = "Mix Thermal Conductivity [W/mK]";
        this.values[k] = fluid.getThermalConductivity("W/mK");
        int j = 0;
        while (j < 3) {
            String currPhaseName = phaseName[j];
            if (fluid.hasPhaseType(phaseName[j])) {
                int phaseNumber = fluid.getPhaseNumberOfPhase(phaseName[j]);
                PhaseInterface currPhase = fluid.getPhase(phaseNumber);
                this.names[++k] = String.valueOf(currPhaseName) + " Mole Percent";
                this.values[k] = fluid.getMoleFraction(phaseNumber) * 100.0;
                this.names[++k] = String.valueOf(currPhaseName) + " Weight Percent";
                this.values[k] = fluid.getWtFraction(phaseNumber) * 100.0;
                this.names[++k] = String.valueOf(currPhaseName) + " Molar Volume [m3/mol]";
                this.values[k] = 1.0 / currPhase.getDensity("mol/m3");
                this.names[++k] = String.valueOf(currPhaseName) + " Volume Percent";
                this.values[k] = fluid.getCorrectedVolumeFraction(phaseNumber) * 100.0;
                this.names[++k] = String.valueOf(currPhaseName) + " Density [kg/m3]";
                this.values[k] = currPhase.getDensity("kg/m3");
                this.names[++k] = String.valueOf(currPhaseName) + " Z Factor";
                this.values[k] = Objects.equals(phaseName[j], "oil") || Objects.equals(phaseName[j], "aqueous") ? Double.valueOf(Double.NaN) : Double.valueOf(currPhase.getZ());
                this.names[++k] = String.valueOf(currPhaseName) + "Molecular Weight [g/mol]";
                this.values[k] = currPhase.getMolarMass() * 1000.0;
                this.names[++k] = String.valueOf(currPhaseName) + "Enthalpy [J/mol]";
                this.values[k] = currPhase.getEnthalpy("J/mol");
                this.names[++k] = String.valueOf(currPhaseName) + "Entropy [J/molK]";
                this.values[k] = currPhase.getEntropy("J/molK");
                this.names[++k] = String.valueOf(currPhaseName) + "Heat Capacity-Cp [J/molK]";
                this.values[k] = currPhase.getCp("J/molK");
                this.names[++k] = String.valueOf(currPhaseName) + " Heat Capacity-Cv [J/molK]";
                this.values[k] = currPhase.getCv("J/molK");
                this.names[++k] = String.valueOf(currPhaseName) + " Kappa (Cp/Cv)";
                this.values[k] = currPhase.getGamma();
                this.names[++k] = String.valueOf(currPhaseName) + " JT Coefficient [K/Pa]";
                if (Objects.equals(phaseName[j], "oil") || Objects.equals(phaseName[j], "aqueous")) {
                    this.values[k] = Double.NaN;
                    this.names[++k] = String.valueOf(currPhaseName) + " Velocity of Sound [m/s]";
                    this.values[k] = Double.NaN;
                } else {
                    this.values[k] = currPhase.getJouleThomsonCoefficient() / 100000.0;
                    this.names[++k] = String.valueOf(currPhaseName) + " Velocity of Sound [m/s]";
                    this.values[k] = currPhase.getSoundSpeed();
                }
                this.names[++k] = String.valueOf(currPhaseName) + " Viscosity [Pa s] or [kg/msec]";
                this.values[k] = currPhase.getViscosity("kg/msec");
                this.names[++k] = String.valueOf(currPhaseName) + " Thermal Conductivity [W/mK]";
                this.values[k] = currPhase.getThermalConductivity("W/mK");
            } else {
                this.names[++k] = String.valueOf(currPhaseName) + " Mole Percent";
                this.values[k] = Double.NaN;
                this.names[++k] = String.valueOf(currPhaseName) + " Weight Percent";
                this.values[k] = Double.NaN;
                this.names[++k] = String.valueOf(currPhaseName) + " Molar Volume [m3/mol]";
                this.values[k] = Double.NaN;
                this.names[++k] = String.valueOf(currPhaseName) + " Volume Percent";
                this.values[k] = Double.NaN;
                this.names[++k] = String.valueOf(currPhaseName) + " Density [kg/m3]";
                this.values[k] = Double.NaN;
                this.names[++k] = String.valueOf(currPhaseName) + " Z Factor";
                this.values[k] = Double.NaN;
                this.names[++k] = String.valueOf(currPhaseName) + " Molecular Weight [g/mol]";
                this.values[k] = Double.NaN;
                this.names[++k] = String.valueOf(currPhaseName) + " Enthalpy [J/mol]";
                this.values[k] = Double.NaN;
                this.names[++k] = String.valueOf(currPhaseName) + " Entropy [J/molK]";
                this.values[k] = Double.NaN;
                this.names[++k] = String.valueOf(currPhaseName) + " Heat Capacity-Cp [J/molK]";
                this.values[k] = Double.NaN;
                this.names[++k] = String.valueOf(currPhaseName) + " Heat Capacity-Cv [J/molK]";
                this.values[k] = Double.NaN;
                this.names[++k] = String.valueOf(currPhaseName) + " Kappa (Cp/Cv)";
                this.values[k] = Double.NaN;
                this.names[++k] = String.valueOf(currPhaseName) + " JT Coefficient [K/Pa]";
                this.values[k] = Double.NaN;
                this.names[++k] = String.valueOf(currPhaseName) + " Velocity of Sound [m/s]";
                this.values[k] = Double.NaN;
                this.names[++k] = String.valueOf(currPhaseName) + " Viscosity [Pa s] or [kg/msec]";
                this.values[k] = Double.NaN;
                this.names[++k] = String.valueOf(currPhaseName) + " Thermal Conductivity [W/mK]";
                this.values[k] = Double.NaN;
            }
            ++j;
        }
        this.names[++k] = "Interfacial Tension Gas/Oil [N/m]";
        this.values[k] = fluid.hasPhaseType("gas") && fluid.hasPhaseType("oil") ? Double.valueOf(fluid.getInterfacialTension("gas", "oil")) : Double.valueOf(Double.NaN);
        this.names[++k] = "Interfacial Tension Gas/Aqueous [N/m]";
        this.values[k] = fluid.hasPhaseType("gas") && fluid.hasPhaseType("aqueous") ? Double.valueOf(fluid.getInterfacialTension("gas", "aqueous")) : Double.valueOf(Double.NaN);
        this.names[++k] = "Interfacial Tension Oil/Aqueous [N/m]";
        this.values[k] = fluid.hasPhaseType("oil") && fluid.hasPhaseType("aqueous") ? Double.valueOf(fluid.getInterfacialTension("oil", "aqueous")) : Double.valueOf(Double.NaN);
    }

    public HashMap<String, Double> getProperties() {
        HashMap<String, Double> propMap = new HashMap<String, Double>();
        int i = 0;
        while (i < this.names.length) {
            propMap.put(this.names[i], this.values[i]);
            ++i;
        }
        return propMap;
    }

    public Double[] getValues() {
        return this.values;
    }

    public static String[] getPropertyNames() {
        SystemProperties p = new SystemProperties(new SystemSrkEos());
        return p.names;
    }
}

