/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhasePrEos;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.system.SystemPrEos;

public class SystemPrDanesh
extends SystemPrEos {
    private static final long serialVersionUID = 1000L;

    public SystemPrDanesh() {
        this.modelName = "PR-Danesh-EOS";
        this.attractiveTermNumber = 9;
        int i = 0;
        while (i < this.numberOfPhases) {
            this.phaseArray[i] = new PhasePrEos();
            this.phaseArray[i].setTemperature(298.15);
            this.phaseArray[i].setPressure(1.0);
            ++i;
        }
    }

    public SystemPrDanesh(double T, double P) {
        super(T, P);
        this.modelName = "PR-Danesh-EOS";
        this.attractiveTermNumber = 9;
        int i = 0;
        while (i < this.numberOfPhases) {
            this.phaseArray[i] = new PhasePrEos();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
            ++i;
        }
    }

    public SystemPrDanesh(double T, double P, boolean solidCheck) {
        this(T, P);
        this.modelName = "PR-Danesh-EOS";
        this.attractiveTermNumber = 9;
        this.setNumberOfPhases(5);
        this.solidPhaseCheck = solidCheck;
        int i = 0;
        while (i < this.numberOfPhases) {
            this.phaseArray[i] = new PhasePrEos();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
            ++i;
        }
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        if (this.hydrateCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhaseHydrate();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemPrDanesh clone() {
        SystemPrDanesh clonedSystem = null;
        try {
            clonedSystem = (SystemPrDanesh)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }
}

