/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import java.io.Serializable;
import neqsim.chemicalReactions.ChemicalReactionOperations;
import neqsim.physicalProperties.interfaceProperties.InterphasePropertiesInterface;
import neqsim.standards.StandardInterface;
import neqsim.thermo.characterization.Characterise;
import neqsim.thermo.characterization.WaxCharacterise;
import neqsim.thermo.characterization.WaxModelInterface;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.system.SystemProperties;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;

public interface SystemInterface
extends Cloneable,
Serializable {
    public void saveFluid(int var1);

    public void saveFluid(int var1, String var2);

    public String getComponentNameTag();

    public void setComponentNameTagOnNormalComponents(String var1);

    public void addPhaseFractionToPhase(double var1, String var3, String var4, String var5);

    public void addPhaseFractionToPhase(double var1, String var3, String var4, String var5, String var6);

    public void renameComponent(String var1, String var2);

    public void setComponentNameTag(String var1);

    default public void addComponents(String[] names) {
        int i = 0;
        while (i < names.length) {
            this.addComponent(names[i], 0.0);
            ++i;
        }
    }

    default public void addComponents(String[] names, double[] moles) {
        int i = 0;
        while (i < names.length) {
            this.addComponent(names[i], moles[i]);
            ++i;
        }
    }

    default public String[][] calcResultTable() {
        return this.createTable("");
    }

    public double getKinematicViscosity();

    public double getKinematicViscosity(String var1);

    public int getNumberOfComponents();

    public void setMolarCompositionPlus(double[] var1);

    public void setMolarCompositionOfPlusFluid(double[] var1);

    public double getExergy(double var1, String var3);

    public double getExergy(double var1);

    public double getJouleThomsonCoefficient();

    public double getJouleThomsonCoefficient(String var1);

    public double getMass(String var1);

    public double getMoleFractionsSum();

    public double getSoundSpeed(String var1);

    public double getSoundSpeed();

    public void removePhaseKeepTotalComposition(int var1);

    public void initPhysicalProperties();

    public void initPhysicalProperties(String var1);

    public void initProperties();

    public static SystemInterface addFluids(SystemInterface addFluid1, SystemInterface addFluid2) {
        SystemInterface newFluid = addFluid1.clone();
        newFluid.addFluid(addFluid2);
        return newFluid;
    }

    public double getInterfacialTension(String var1, String var2);

    public double getInterfacialTension(int var1, int var2);

    public double getInterfacialTension(int var1, int var2, String var3);

    default public double getGamma2() {
        return this.getCp() / (this.getCp() - 8.3144621 * this.getTotalNumberOfMoles());
    }

    public double getGamma();

    public double getVolume();

    public double getVolume(String var1);

    public double getFlowRate(String var1);

    public void setPressure(double var1);

    public void setPressure(double var1, String var3);

    public void setTemperature(double var1);

    public void setTemperature(double var1, int var3);

    public void setTemperature(double var1, String var3);

    public double getVolumeFraction(int var1);

    public double getCorrectedVolumeFraction(int var1);

    public double getHeatOfVaporization();

    public double getInternalEnergy();

    public double getInternalEnergy(String var1);

    public boolean isForcePhaseTypes();

    public void setForcePhaseTypes(boolean var1);

    @Deprecated
    default public void removeMoles() {
        this.setEmptyFluid();
    }

    public void setEmptyFluid();

    public void setMolarFlowRates(double[] var1);

    public void setComponentNames(String[] var1);

    public void calc_x_y_nonorm();

    public void saveObjectToFile(String var1, String var2);

    public SystemInterface readObjectFromFile(String var1, String var2);

    public double getLiquidVolume();

    public void resetPhysicalProperties();

    public SystemInterface phaseToSystem(int var1);

    public SystemInterface phaseToSystem(PhaseInterface var1);

    public SystemInterface phaseToSystem(String var1);

    public SystemInterface phaseToSystem(int var1, int var2);

    public void changeComponentName(String var1, String var2);

    public WaxModelInterface getWaxModel();

    public WaxCharacterise getWaxCharacterisation();

    public double[] getMolarRate();

    @Deprecated
    default public boolean IsPhase(int i) {
        return this.isPhase(i);
    }

    public boolean isPhase(int var1);

    public PhaseInterface getPhase(int var1);

    public PhaseInterface getPhase(String var1);

    public int getPhaseIndexOfPhase(String var1);

    public void setTotalFlowRate(double var1, String var3);

    public double[] getMolarComposition();

    public int getNumberOfOilFractionComponents();

    public boolean setHeavyTBPfractionAsPlusFraction();

    public String[] getCapeOpenProperties11();

    public String[] getCapeOpenProperties10();

    public PhaseInterface getLowestGibbsEnergyPhase();

    public double[] getOilFractionNormalBoilingPoints();

    public double[] getOilFractionLiquidDensityAt25C();

    public double[] getOilFractionMolecularMass();

    public int[] getOilFractionIDs();

    public double getMoleFraction(int var1);

    public double getCv();

    public double getCv(String var1);

    public Characterise getCharacterization();

    public SystemInterface readObject(int var1);

    public String[] getCompIDs();

    public void saveObject(int var1, String var2);

    public void reset();

    public String[] getCASNumbers();

    public double[] getMolecularWeights();

    public double[] getNormalBoilingPointTemperatures();

    public String[] getCompNames();

    public String[] getCompFormulaes();

    public double getWtFraction(int var1);

    public boolean isMultiphaseWaxCheck();

    public void setMultiphaseWaxCheck(boolean var1);

    public void setMolarComposition(double[] var1);

    public PhaseInterface getPhaseOfType(String var1);

    public void setUseTVasIndependentVariables(boolean var1);

    public void addTBPfraction(String var1, double var2, double var4, double var6);

    public void addTBPfraction(String var1, double var2, double var4, double var6, double var8, double var10, double var12);

    public void addPlusFraction(String var1, double var2, double var4, double var6);

    public void addSalt(String var1, double var2);

    public void deleteFluidPhase(int var1);

    public void setBmixType(int var1);

    public boolean hasSolidPhase();

    public void addSolidComplexPhase(String var1);

    public void resetCharacterisation();

    public int getMaxNumberOfPhases();

    public void setMaxNumberOfPhases(int var1);

    public String getMixingRuleName();

    public String getModelName();

    public void tuneModel(String var1, double var2, int var4);

    public void addComponent(ComponentInterface var1);

    public void addComponent(String var1);

    public void addComponent(String var1, double var2);

    public void addComponent(String var1, double var2, String var4);

    public void addComponent(String var1, double var2, double var4, double var6, double var8);

    public void addComponent(String var1, double var2, int var4);

    public void addComponent(String var1, double var2, String var4, int var5);

    public void addComponent(int var1, double var2);

    public void addComponent(int var1, double var2, int var4);

    public double getBeta();

    public double getBeta(int var1);

    public void save(String var1);

    public SystemInterface setModel(String var1);

    public void removeComponent(String var1);

    public void setMixingRule(String var1, String var2);

    public void setMixingRule(int var1);

    public void setMixingRule(String var1);

    public void normalizeBeta();

    public int getPhaseIndex(int var1);

    public void setInitType(int var1);

    public boolean checkStability();

    public void checkStability(boolean var1);

    public boolean hasPlusFraction();

    public int getInitType();

    public void invertPhaseTypes();

    public double getCorrectedVolume();

    public void readFluid(String var1);

    public void calcKIJ(boolean var1);

    public void write(String var1, String var2, boolean var3);

    public void useVolumeCorrection(boolean var1);

    public boolean isNumericDerivatives();

    public void setNumericDerivatives(boolean var1);

    public String getFluidInfo();

    public void setFluidInfo(String var1);

    public void setPhaseIndex(int var1, int var2);

    public void setPhase(PhaseInterface var1, int var2);

    public void createDatabase(boolean var1);

    public void resetDatabase();

    public void setSolidPhaseCheck(boolean var1);

    public void setSolidPhaseCheck(String var1);

    public boolean doSolidPhaseCheck();

    public boolean doMultiPhaseCheck();

    public void setMultiPhaseCheck(boolean var1);

    default public void init() {
        this.init(this.getInitType());
    }

    public void init(int var1);

    public void init(int var1, int var2);

    default public void initThermoProperties() {
        this.init(2);
    }

    public void initNumeric();

    public void display();

    public void display(String var1);

    public SystemInterface addFluid(SystemInterface var1);

    @Deprecated
    public boolean doHydrateCheck();

    public boolean getHydrateCheck();

    public String[][] createTable(String var1);

    public void setHydrateCheck(boolean var1);

    public double calcBeta() throws IsNaNException, TooManyIterationsException;

    public void setAllComponentsInPhase(int var1);

    public void initTotalNumberOfMoles(double var1);

    public void calc_x_y();

    public void reset_x_y();

    public void addPhase();

    public void setAttractiveTerm(int var1);

    public void setBeta(double var1);

    public void setBeta(int var1, double var2);

    public void removePhase(int var1);

    public double getPressure();

    public double getPressure(int var1);

    public double getPressure(String var1);

    public void reInitPhaseType();

    public void setPhysicalPropertyModel(int var1);

    public void clearAll();

    public double getDensity();

    public double getDensity(String var1);

    public ChemicalReactionOperations getChemicalReactionOperations();

    public boolean isChemicalSystem();

    public void isChemicalSystem(boolean var1);

    public double getMolarVolume();

    public double getMolarMass();

    public double getMolarMass(String var1);

    public double getEnthalpy();

    public double getEnthalpy(String var1);

    public void calcInterfaceProperties();

    public InterphasePropertiesInterface getInterphaseProperties();

    public double initBeta();

    public void init_x_y();

    public double getEntropy();

    public double getEntropy(String var1);

    public double getTemperature();

    public double getTemperature(String var1);

    public double getTemperature(int var1);

    public void chemicalReactionInit();

    public void setPhaseType(int var1, int var2);

    public void setPhaseType(String var1, int var2);

    public void setPhaseType(int var1, String var2);

    public void setNumberOfPhases(int var1);

    public double getTC();

    public double getPC();

    public void setTC(double var1);

    public void setPC(double var1);

    public PhaseInterface[] getPhases();

    public int getNumberOfPhases();

    public double getGibbsEnergy();

    public double getHelmholtzEnergy();

    public ComponentInterface getComponent(String var1);

    public ComponentInterface getComponent(int var1);

    public double getNumberOfMoles();

    public SystemInterface clone();

    public String[] getComponentNames();

    public double getdVdPtn();

    public double getdVdTpn();

    public double getCp();

    public double getCp(String var1);

    public double getKappa();

    public void replacePhase(int var1, PhaseInterface var2);

    public PhaseInterface getGasPhase();

    public PhaseInterface getLiquidPhase();

    public double getZ();

    public double getViscosity();

    public double getViscosity(String var1);

    @Deprecated
    public double getConductivity();

    @Deprecated
    public double getConductivity(String var1);

    public double getThermalConductivity();

    public double getThermalConductivity(String var1);

    public void initRefPhases();

    public String getFluidName();

    public void setFluidName(String var1);

    public boolean allowPhaseShift();

    public void allowPhaseShift(boolean var1);

    public double getPhaseFraction(String var1, String var2);

    public double getProperty(String var1, String var2, int var3);

    public double getProperty(String var1, int var2);

    public double getProperty(String var1);

    public StandardInterface getStandard();

    public StandardInterface getStandard(String var1);

    public void setStandard(String var1);

    public void saveToDataBase();

    public int getMixingRule();

    public String[][] getResultTable();

    public SystemInterface autoSelectModel();

    public void autoSelectMixingRule();

    public void orderByDensity();

    public void addLiquidToGas(double var1);

    public void addGasToLiquid(double var1);

    public double getTotalNumberOfMoles();

    public void setTotalNumberOfMoles(double var1);

    public boolean hasPhaseType(String var1);

    public int getPhaseNumberOfPhase(String var1);

    public SystemInterface getEmptySystemClone();

    public double calcHenrysConstant(String var1);

    public boolean isImplementedTemperatureDeriativesofFugacity();

    public void setImplementedTemperatureDeriativesofFugacity(boolean var1);

    public boolean isImplementedPressureDeriativesofFugacity();

    public void setImplementedPressureDeriativesofFugacity(boolean var1);

    public boolean isImplementedCompositionDeriativesofFugacity();

    public void isImplementedCompositionDeriativesofFugacity(boolean var1);

    public void setImplementedCompositionDeriativesofFugacity(boolean var1);

    public void addCapeOpenProperty(String var1);

    public SystemProperties getProperties();

    public boolean equals(Object var1);

    public int hashCode();

    public void addToComponentNames(String var1);

    public void addOilFractions(String[] var1, double[] var2, double[] var3, double[] var4, boolean var5);

    public void addOilFractions(String[] var1, double[] var2, double[] var3, double[] var4, boolean var5, boolean var6, int var7);

    public void addCharacterized(String[] var1, double[] var2, double[] var3, double[] var4);

    public double getIdealLiquidDensity(String var1);
}

