/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentSolid;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseSrkEos;

public abstract class PhaseSolid
extends PhaseSrkEos {
    private static final long serialVersionUID = 1000L;

    public PhaseSolid() {
        this.phaseTypeName = "solid";
    }

    @Override
    public PhaseSolid clone() {
        PhaseSolid clonedPhase = null;
        try {
            clonedPhase = (PhaseSolid)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedPhase;
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
        this.phaseTypeName = "solid";
    }

    @Override
    public void addcomponent(String componentName, double molesInPhase, double moles, int compNumber) {
        super.addcomponent(molesInPhase);
        this.componentArray[compNumber] = new ComponentSolid(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public double getEnthalpy() {
        double fusionHeat = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            fusionHeat += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(i).getHeatOfFusion();
            ++i;
        }
        return super.getEnthalpy() - fusionHeat;
    }

    public void setSolidRefFluidPhase(PhaseInterface refPhase) {
        int i = 0;
        while (i < this.numberOfComponents) {
            ((ComponentSolid)this.componentArray[i]).setSolidRefFluidPhase(refPhase);
            ++i;
        }
    }

    public double getDensityTemp() {
        double density2 = 0.0;
        int i = 0;
        while (i < this.numberOfComponents) {
            density2 += this.getWtFrac(i) * ((ComponentSolid)this.componentArray[i]).getPureComponentSolidDensity(this.getTemperature()) * 1000.0;
            ++i;
        }
        this.molarVolume = density2 / this.getMolarMass() * 1.0E-5;
        return density2;
    }
}

